/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.forge.platform;

import io.github.flemmli97.mobbattle.forge.network.PacketHandler;
import io.github.flemmli97.mobbattle.forge.registry.ModMenuType;
import io.github.flemmli97.mobbattle.inv.ContainerArmor;
import io.github.flemmli97.mobbattle.network.Packet;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CrossPlatformStuffImpl
implements CrossPlatformStuff {
    @Override
    public MenuType<ContainerArmor> getArmorMenuType() {
        return (MenuType)ModMenuType.ARMOR_MENU.get();
    }

    @Override
    public void openGuiArmor(ServerPlayer player, final Mob living) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return living.m_7755_();
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory arg, Player arg2) {
                return new ContainerArmor(i, arg, (Entity)living);
            }
        }, buf -> buf.writeInt(living.m_19879_()));
    }

    @Override
    public LivingEntity tryGetEntity(Entity entity) {
        LivingEntity living = CrossPlatformStuff.super.tryGetEntity(entity);
        if (living == null && entity.isMultipartEntity()) {
            for (PartEntity part : entity.getParts()) {
                LivingEntity e;
                Entity parent;
                if (part == null || !((parent = part.getParent()) instanceof LivingEntity)) continue;
                living = e = (LivingEntity)parent;
                break;
            }
        }
        return living;
    }

    @Override
    public boolean canEquip(ItemStack stack, EquipmentSlot slot, LivingEntity living) {
        return stack.canEquip(slot, (Entity)living);
    }

    @Override
    public GoalSelector goalSelectorFrom(Mob mob, boolean target) {
        return target ? mob.f_21346_ : mob.f_21345_;
    }

    @Override
    public void sendToClient(Packet packet, ServerPlayer player) {
        PacketHandler.sendToClient(packet, player);
    }

    @Override
    public void sendToServer(Packet packet) {
        PacketHandler.sendToServer(packet);
    }
}

