/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.client.gui;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SuggestionEditBox
extends EditBox {
    private final Font font;
    private final int limit;
    private final int lineHeight;
    private final Collection<SuggestionContent> allSuggestions;
    private final boolean top;
    private int offset;
    private int current;
    private String[] suggestions;
    private Rect2i rect;
    private boolean hidden;
    private boolean init;
    private int paddingX = 4;
    private int paddingY = 2;

    public SuggestionEditBox(Font font, int x, int y, int width, int height, Component message, int maxLimit, boolean top, Collection<SuggestionContent> suggestions) {
        super(font, x, y, width, height, message);
        this.font = font;
        this.allSuggestions = suggestions;
        this.limit = maxLimit;
        Objects.requireNonNull(this.font);
        this.lineHeight = 9 + 3;
        this.top = top;
        this.recalculateSuggestions("");
        this.select(0);
        this.m_94151_(null);
    }

    public static Collection<SuggestionContent> ofString(Collection<String> strings) {
        return strings.stream().map(s -> new SuggestionContent((String)s){
            final /* synthetic */ String val$s;
            {
                this.val$s = string;
            }

            @Override
            public boolean matches(String input) {
                return this.val$s.startsWith(input);
            }

            @Override
            public String asString() {
                return this.val$s;
            }
        }).toList();
    }

    public static Collection<SuggestionContent> ofResourceLocation(Collection<ResourceLocation> strings) {
        return strings.stream().map(res -> new SuggestionContent((ResourceLocation)res){
            final /* synthetic */ ResourceLocation val$res;
            {
                this.val$res = resourceLocation;
            }

            @Override
            public boolean matches(String input) {
                return this.val$res.m_135815_().startsWith(input) || this.val$res.toString().startsWith(input);
            }

            @Override
            public String asString() {
                return this.val$res.toString();
            }
        }).toList();
    }

    public SuggestionEditBox withPadding(int paddingX, int paddingY) {
        this.paddingX = paddingX;
        this.paddingY = paddingY;
        return this;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.suggestionsHidden() || this.suggestions.length == 0) {
            return;
        }
        if (this.suggestions.length == 1 && this.m_94155_().equals(this.suggestions[0])) {
            return;
        }
        int idx = this.indexFromMouse(mouseY);
        if (idx >= 0 && idx < this.suggestions.length) {
            this.select(idx);
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 50.0f);
        guiGraphics.m_280509_(this.rect.m_110085_(), this.rect.m_110086_(), this.rect.m_110085_() + this.rect.m_110090_(), this.rect.m_110086_() + this.rect.m_110091_(), -535818224);
        int x = this.m_252754_() + this.paddingX;
        int y = this.rect.m_110086_() + this.paddingY;
        for (int i = 0; i < this.suggestions.length; ++i) {
            int idxx = (this.offset + i) % this.suggestions.length;
            if (i >= 5 || idxx >= this.suggestions.length) break;
            String string = this.suggestions[idxx];
            guiGraphics.m_280488_(this.font, string, x, y + i * this.lineHeight, this.current == idxx ? 0xFFFF55 : 0xFFFFFF);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private boolean suggestionsHidden() {
        return this.hidden || !this.m_94204_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            this.hidden = false;
            return true;
        }
        if (this.suggestionsHidden() || !this.rect.m_110087_((int)mouseX, (int)mouseY)) {
            return false;
        }
        int i = this.indexFromMouse(mouseY);
        if (i >= 0 && i < this.suggestions.length) {
            this.select(i);
            this.useSuggestion();
        }
        return true;
    }

    private int indexFromMouse(double mouseY) {
        return (int)((mouseY - (double)(this.rect.m_110086_() - this.paddingY)) / (double)this.lineHeight + (double)this.offset);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        super.m_6050_(mouseX, mouseY, delta);
        if (this.rect.m_110087_((int)mouseX, (int)mouseY)) {
            this.offset = Mth.m_14045_((int)((int)((double)this.offset - delta)), (int)0, (int)Math.max(this.suggestions.length - this.limit, 0));
            return true;
        }
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (!this.suggestionsHidden() && this.rect.m_110087_((int)mouseX, (int)mouseY)) {
            return true;
        }
        return super.m_5953_(mouseX, mouseY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_94204_()) {
            if (keyCode == 265) {
                this.cycle(-1);
                return true;
            }
            if (keyCode == 264) {
                this.cycle(1);
                return true;
            }
            if (keyCode == 257) {
                this.useSuggestion();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_94151_(Consumer<String> responder) {
        super.m_94151_(this.of(responder));
    }

    private Consumer<String> of(Consumer<String> other) {
        Consumer<String> updater = s -> {
            String val = this.m_94155_();
            this.recalculateSuggestions(val);
        };
        if (other == null || !this.init) {
            this.init = true;
            return updater;
        }
        return s -> {
            other.accept((String)s);
            updater.accept((String)s);
        };
    }

    private void recalculateSuggestions(String input) {
        this.suggestions = (String[])this.allSuggestions.stream().filter(ctx -> ctx.matches(input)).map(SuggestionContent::asString).toArray(String[]::new);
        int sizeY = Math.min(this.suggestions.length, this.limit) * this.lineHeight;
        int y = this.m_252907_() + (this.top ? -sizeY - this.paddingY : this.m_93694_() + this.paddingY);
        int width = this.f_93618_;
        for (String sugg : this.suggestions) {
            int newWidth = this.font.m_92895_(sugg) + this.paddingX * 2;
            if (newWidth <= width) continue;
            width = newWidth;
        }
        this.rect = new Rect2i(this.m_252754_(), y, width, sizeY + this.paddingY);
        this.hidden = false;
    }

    public void cycle(int change) {
        this.select(this.current + change);
        int i = this.offset;
        int j = this.offset + this.limit - 1;
        if (this.current < i) {
            this.offset = Mth.m_14045_((int)this.current, (int)0, (int)Math.max(this.suggestions.length - this.limit, 0));
        } else if (this.current > j) {
            this.offset = Mth.m_14045_((int)(this.current - this.limit), (int)0, (int)Math.max(this.suggestions.length - this.limit, 0));
        }
    }

    public void select(int index) {
        this.current = index;
        if (this.current < 0) {
            this.current += this.suggestions.length;
        }
        if (this.current >= this.suggestions.length) {
            this.current -= this.suggestions.length;
        }
    }

    public void useSuggestion() {
        String suggestion = this.suggestions[this.current];
        this.m_94144_(suggestion);
        this.m_94196_(suggestion.length());
        this.m_94208_(suggestion.length());
        this.select(this.current);
        this.hidden = true;
    }

    public static interface SuggestionContent {
        public boolean matches(String var1);

        public String asString();
    }
}

