/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.mobbattle.client.gui;

import io.github.flemmli97.mobbattle.MobBattle;
import io.github.flemmli97.mobbattle.client.gui.SuggestionEditBox;
import io.github.flemmli97.mobbattle.items.ItemExtendedSpawnEgg;
import io.github.flemmli97.mobbattle.network.C2SSpawnEgg;
import io.github.flemmli97.mobbattle.platform.CrossPlatformStuff;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SpawnEggScreen
extends Screen {
    private final Player player;
    protected final Mob entity;
    private final InteractionHand hand;
    private int leftPos;
    private int topPos;
    private final int sizeX = 240;
    private final int sizeY = 200;
    private String team;
    private int amount;
    private int spacing;
    private EditBox teamBox;

    public SpawnEggScreen(InteractionHand hand) {
        super((Component)Component.m_237119_());
        Mob mob;
        this.hand = hand;
        this.player = Minecraft.m_91087_().f_91074_;
        ItemStack stack = this.player.m_21120_(this.hand);
        Entity entity = ItemExtendedSpawnEgg.getEntity(this.player.m_9236_(), stack);
        this.entity = entity instanceof Mob ? (mob = (Mob)entity) : null;
        ItemExtendedSpawnEgg.SpawnOptions options = ItemExtendedSpawnEgg.getOptions(stack);
        this.team = options.team() != null ? options.team() : "";
        this.amount = options.amount();
        this.spacing = options.spacing();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.entity == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        this.leftPos = this.f_96543_ / 2 - this.sizeX / 2;
        this.topPos = this.f_96544_ / 2 - this.sizeY / 2;
        this.buttons();
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.entity.f_19797_;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int xPadding;
        guiGraphics.m_280024_(this.leftPos, this.topPos, this.leftPos + this.sizeX, this.topPos + this.sizeY, -1072689136, -1072689136);
        int yOff = xPadding = 16;
        int width = this.f_96547_.m_92852_((FormattedText)this.entity.m_6095_().m_20676_());
        Component component = this.entity.m_6095_().m_20676_();
        float f = this.leftPos;
        Objects.requireNonNull(this);
        guiGraphics.m_280430_(this.f_96547_, component, (int)(f + 240.0f * 0.5f - (float)width * 0.5f), this.topPos + yOff, ChatFormatting.GOLD.m_126665_().intValue());
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"mobbattle.gui.team"), this.leftPos + xPadding, this.topPos + (yOff += 16), 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"mobbattle.gui.amount"), this.leftPos + xPadding, this.topPos + (yOff += 44), 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"mobbattle.gui.spacing"), this.leftPos + xPadding, this.topPos + (yOff += 36), 0xFFFFFF);
        SpawnEggScreen.renderEntityMouseNoClip(guiGraphics, this.leftPos + this.sizeX - xPadding - 90, this.topPos + xPadding + 16, 30, 3.0f, 3.0f, mouseX, mouseY, (LivingEntity)this.entity);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public static void renderEntityMouseNoClip(GuiGraphics guiGraphics, int x, int y, int scale, float maxWidth, float maxHeight, float mouseX, float mouseY, LivingEntity entity) {
        float sizeX = maxWidth * (float)scale;
        float sizeY = maxHeight * (float)scale;
        float scaleMult = 1.0f;
        if (entity.m_20205_() > maxWidth) {
            scaleMult = maxWidth / entity.m_20205_();
        }
        if (entity.m_20206_() > maxHeight) {
            scaleMult = Math.min(scaleMult, maxHeight / entity.m_20206_());
        }
        float xPos = ((float)(x + x) + sizeX) / 2.0f;
        float yPos = ((float)(y + y) + sizeY) / 2.0f + entity.m_20206_() * 0.5f * scaleMult * (float)scale;
        float eyePos = yPos - entity.m_20192_() * scaleMult * (float)scale;
        InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)((int)xPos), (int)((int)yPos), (int)((int)((float)scale * scaleMult)), (float)(xPos - mouseX), (float)(eyePos - mouseY), (LivingEntity)entity);
    }

    protected void buttons() {
        int padding = 16;
        int yOff = padding + 12 + 16;
        this.teamBox = new SuggestionEditBox(this.f_96547_, this.leftPos + padding, this.topPos + yOff, 100, 14, (Component)Component.m_237119_(), 5, false, SuggestionEditBox.ofString(this.player.m_9236_().m_6188_().m_83488_()));
        this.teamBox.m_94151_(s -> {
            this.team = s;
        });
        this.teamBox.m_94199_(35);
        this.teamBox.m_94186_(true);
        this.teamBox.m_94144_(this.team);
        this.m_142416_((GuiEventListener)this.teamBox);
        EditBox amountBox = new EditBox(this.f_96547_, this.leftPos + padding, this.topPos + (yOff += 44), 27, 10, (Component)Component.m_237119_()){

            public boolean m_5534_(char typedChar, int keyCode) {
                if ((Character.isDigit(typedChar) || SpawnEggScreen.this.isHelperKey(keyCode)) && super.m_5534_(typedChar, keyCode) && !this.m_94155_().isEmpty()) {
                    try {
                        int amount = Integer.parseInt(this.m_94155_());
                        if (amount > 100) {
                            amount = 100;
                            this.m_94144_("" + amount);
                        }
                        SpawnEggScreen.this.amount = amount;
                    }
                    catch (NumberFormatException e) {
                        MobBattle.LOGGER.error(this.m_94155_() + " not a number");
                    }
                    return true;
                }
                return false;
            }
        };
        amountBox.m_94199_(3);
        amountBox.m_94186_(true);
        amountBox.m_94144_("" + this.amount);
        this.m_142416_((GuiEventListener)amountBox);
        EditBox spacingBox = new EditBox(this.f_96547_, this.leftPos + padding, this.topPos + (yOff += 36), 27, 10, (Component)Component.m_237119_()){

            public boolean m_5534_(char typedChar, int keyCode) {
                if ((Character.isDigit(typedChar) || SpawnEggScreen.this.isHelperKey(keyCode)) && super.m_5534_(typedChar, keyCode) && !this.m_94155_().isEmpty()) {
                    try {
                        SpawnEggScreen.this.spacing = Integer.parseInt(this.m_94155_());
                    }
                    catch (NumberFormatException e) {
                        MobBattle.LOGGER.error(this.m_94155_() + " not a number");
                    }
                    return true;
                }
                return false;
            }
        };
        spacingBox.m_94199_(2);
        spacingBox.m_94186_(true);
        spacingBox.m_94144_("" + this.spacing);
        this.m_142416_((GuiEventListener)spacingBox);
        yOff = this.sizeY - padding - 20;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"mobbattle.gui.save"), b -> {
            CrossPlatformStuff.INSTANCE.sendToServer(new C2SSpawnEgg(this.hand, this.team, this.amount, this.spacing));
            this.f_96541_.m_91152_(null);
        }).m_252987_(this.leftPos + this.sizeX / 2 - 50, this.topPos + yOff, 100, 20).m_253136_());
    }

    private boolean isHelperKey(int keyCode) {
        return keyCode == 14 || keyCode == 199 || keyCode == 203 || keyCode == 205 || keyCode == 207 || keyCode == 211;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.teamBox.m_94204_() && this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean click = super.m_6375_(mouseX, mouseY, button);
        if (!click) {
            this.m_7522_(null);
        }
        return click;
    }
}

