/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.LicowitchEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class SugarStaffHexEntity
extends Entity {
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(SugarStaffHexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> HEX_SCALE = SynchedEntityData.m_135353_(SugarStaffHexEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int despawnsIn = -1;
    private int prevDespawnsIn;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private final float yRenderOffset = this.f_19796_.m_188501_() * 0.05f;

    public SugarStaffHexEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public SugarStaffHexEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.SUGAR_STAFF_HEX.get(), level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFESPAN, (Object)100);
        this.f_19804_.m_135372_(HEX_SCALE, (Object)Float.valueOf(1.0f));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setOwner(@Nullable LivingEntity living) {
        this.owner = living;
        this.ownerUUID = living == null ? null : living.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.despawnsIn == -1) {
            this.despawnsIn = this.getLifespan();
        }
        this.prevDespawnsIn = this.despawnsIn;
        if (this.despawnsIn > 0) {
            --this.despawnsIn;
        } else {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_) {
            if (this.despawnsIn < 5) {
                for (int i = 0; i < 8 + this.f_19796_.m_188503_(8); ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.PURPLE_WITCH_EXPLOSION.get(), this.m_20208_(0.45f), this.m_20187_(), this.m_20262_(0.45f), 0.0, 0.0, 0.0);
                }
            } else if (this.f_19796_.m_188501_() < 0.6f) {
                Vec3 ambientParticlePos = new Vec3((double)((this.f_19796_.m_188501_() * 4.0f - 2.0f) * this.getHexScale()), (double)0.1f, (double)((this.f_19796_.m_188501_() * 4.0f - 2.0f) * this.getHexScale()));
                Vec3 vec3 = this.m_20182_().m_82549_(ambientParticlePos);
                Vec3 vec31 = this.m_20182_().m_82549_(ambientParticlePos.m_82490_(1.5).m_82520_(0.0, (double)this.f_19796_.m_188501_(), 0.0));
                this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.PURPLE_WITCH_MAGIC.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
            }
        }
        this.hurtEntities(this.despawnsIn < 5);
        Vec3 vec3 = this.m_20184_();
        this.f_19794_ = true;
        this.m_6478_(MoverType.SELF, vec3);
        this.m_20256_(vec3.m_82542_((double)0.7f, (double)0.8f, (double)0.7f));
    }

    public void setDespawnsIn(int i) {
        this.despawnsIn = i;
    }

    public float getDespawnTime(float partialTicks) {
        return (float)this.prevDespawnsIn + (float)(this.despawnsIn - this.prevDespawnsIn) * partialTicks;
    }

    public void setLifespan(int lifespan) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)lifespan);
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("DespawnsIn")) {
            this.despawnsIn = compoundTag.m_128451_("DespawnsIn");
        }
        this.setLifespan(compoundTag.m_128451_("Lifespan"));
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_("DespawnsIn", this.despawnsIn);
        compoundTag.m_128405_("Lifespan", this.getLifespan());
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
    }

    private void hurtEntities(boolean finalExplosion) {
        AABB bashBox = this.m_20191_();
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
            LicowitchEntity licowitch;
            LivingEntity livingEntity;
            if (this.m_7307_((Entity)entity) || !(entity.m_20270_((Entity)this) <= 4.0f) || this.owner == null || entity.m_7306_((Entity)this.owner) || (this.owner instanceof LicowitchEntity || entity.m_7307_((Entity)this.owner)) && (!((livingEntity = this.owner) instanceof LicowitchEntity) || (licowitch = (LicowitchEntity)livingEntity).isFriendlyFire(entity))) continue;
            entity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.owner), finalExplosion ? 6.0f : 1.0f);
            if (!finalExplosion) continue;
            entity.m_147240_((double)0.9f, this.m_20185_() - entity.m_20185_(), this.m_20189_() - entity.m_20189_());
        }
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (HEX_SCALE.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    public float getHexScale() {
        return ((Float)this.f_19804_.m_135370_(HEX_SCALE)).floatValue();
    }

    public void setHexScale(float f) {
        this.f_19804_.m_135381_(HEX_SCALE, (Object)Float.valueOf(f));
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)(this.getHexScale() * 4.0f), (float)0.25f);
    }

    public float getYRenderOffset() {
        return this.yRenderOffset;
    }
}

