/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.MagnetronModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.living.MagnetronEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.MagnetronPartEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.MagnetronJoint;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.client.render.LightningBoltData;
import com.github.alexthe666.citadel.client.render.LightningRender;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector4f;

public class MagnetronRenderer
extends MobRenderer<MagnetronEntity, MagnetronModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/magnetron.png");
    private static final ResourceLocation TEXTURE_GLOW_RED = new ResourceLocation("alexscaves:textures/entity/magnetron_glow_red.png");
    private static final ResourceLocation TEXTURE_GLOW_BLUE = new ResourceLocation("alexscaves:textures/entity/magnetron_glow_blue.png");
    private static final ResourceLocation TEXTURE_GLOW_EYES = new ResourceLocation("alexscaves:textures/entity/magnetron_glow_eyes.png");
    private Map<UUID, LightningRender> lightningRenderMap = new HashMap<UUID, LightningRender>();

    public MagnetronRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new MagnetronModel(), 0.8f);
        this.m_115326_(new LayerGlow());
    }

    public void render(MagnetronEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        double x = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
        float yaw = entityIn.f_20884_ + (entityIn.f_20883_ - entityIn.f_20884_) * partialTicks;
        LightningRender lightningRender = this.getLightingRender(entityIn.m_20148_());
        poseStack.m_85836_();
        if (entityIn.isFunctionallyMultipart() && entityIn.allParts.length > 0) {
            Object rShoulder = entityIn;
            Object lShoulder = entityIn;
            Object rElbow = entityIn;
            Object lElbow = entityIn;
            Object rHand = entityIn;
            Object lHand = entityIn;
            Object rKnee = entityIn;
            Object lKnee = entityIn;
            Object rFoot = entityIn;
            Object lFoot = entityIn;
            for (MagnetronPartEntity part : entityIn.allParts) {
                double partX = Mth.m_14139_((double)partialTicks, (double)part.f_19790_, (double)part.m_20185_()) - x;
                double partY = Mth.m_14139_((double)partialTicks, (double)part.f_19791_, (double)part.m_20186_()) - y;
                double partZ = Mth.m_14139_((double)partialTicks, (double)part.f_19792_, (double)part.m_20189_()) - z;
                BlockState blockstate = part.getVisualBlockState();
                if (blockstate != null) {
                    poseStack.m_85836_();
                    poseStack.m_85837_(partX, partY, partZ);
                    poseStack.m_85837_(-0.5, 0.0, -0.5);
                    if (blockstate.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                        blockstate = (BlockState)blockstate.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH);
                    }
                    if (blockstate.m_61138_((Property)BlockStateProperties.f_61372_)) {
                        blockstate = (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN);
                    }
                    if (blockstate.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
                        poseStack.m_85837_(0.5, 0.5, 0.5);
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(-((Direction)blockstate.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_()));
                        poseStack.m_85837_(-0.5, -0.5, -0.5);
                    }
                    if (blockstate.m_204336_(ACTagRegistry.MAGNETRON_WEAPONS) && part.getJoint() == MagnetronJoint.HAND) {
                        poseStack.m_85837_(0.5, 0.5, 0.5);
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
                        float poseProgress = entityIn.getAttackPoseProgress(1.0f);
                        float priorPoseProgress = 1.0f - poseProgress;
                        this.rotateHandFor(poseStack, part, entityIn.getAttackPose(), poseProgress);
                        this.rotateHandFor(poseStack, part, entityIn.getPrevAttackPose(), priorPoseProgress);
                        poseStack.m_85837_(-0.5, -0.5, -0.5);
                    }
                    Minecraft.m_91087_().m_91289_().m_110912_(blockstate, poseStack, bufferIn, packedLightIn, OverlayTexture.f_118083_);
                    poseStack.m_85849_();
                }
                if (part.getJoint() == MagnetronJoint.SHOULDER) {
                    if (part.left) {
                        lShoulder = part;
                        continue;
                    }
                    rShoulder = part;
                    continue;
                }
                if (part.getJoint() == MagnetronJoint.ELBOW) {
                    if (part.left) {
                        lElbow = part;
                        continue;
                    }
                    rElbow = part;
                    continue;
                }
                if (part.getJoint() == MagnetronJoint.HAND) {
                    if (part.left) {
                        lHand = part;
                        continue;
                    }
                    rHand = part;
                    continue;
                }
                if (part.getJoint() == MagnetronJoint.KNEE) {
                    if (part.left) {
                        lKnee = part;
                        continue;
                    }
                    rKnee = part;
                    continue;
                }
                if (part.getJoint() != MagnetronJoint.FOOT) continue;
                if (part.left) {
                    lFoot = part;
                    continue;
                }
                rFoot = part;
            }
            Vector4f red = new Vector4f(0.9f, 0.2f, 0.2f, 1.0f);
            Vector4f blue = new Vector4f(0.2f, 0.2f, 0.8f, 1.0f);
            this.spawnLightningBetweenEntities((Entity)entityIn, (Entity)rShoulder, 0.5f, lightningRender, blue, partialTicks, entityIn.lightningAnimOffsets[0]);
            this.spawnLightningBetweenEntities((Entity)entityIn, (Entity)lShoulder, 0.5f, lightningRender, red, partialTicks, entityIn.lightningAnimOffsets[1]);
            this.spawnLightningBetweenEntities((Entity)rShoulder, (Entity)rElbow, 0.5f, lightningRender, blue, partialTicks, Vec3.f_82478_);
            this.spawnLightningBetweenEntities((Entity)rElbow, (Entity)rHand, 0.0f, lightningRender, blue, partialTicks, Vec3.f_82478_);
            this.spawnLightningBetweenEntities((Entity)lShoulder, (Entity)lElbow, 0.0f, lightningRender, red, partialTicks, Vec3.f_82478_);
            this.spawnLightningBetweenEntities((Entity)lElbow, (Entity)lHand, 0.0f, lightningRender, red, partialTicks, Vec3.f_82478_);
            this.spawnLightningBetweenEntities((Entity)entityIn, (Entity)rKnee, 0.5f, lightningRender, blue, partialTicks, entityIn.lightningAnimOffsets[2]);
            this.spawnLightningBetweenEntities((Entity)entityIn, (Entity)lKnee, 0.5f, lightningRender, red, partialTicks, entityIn.lightningAnimOffsets[3]);
            this.spawnLightningBetweenEntities((Entity)rKnee, (Entity)rFoot, 0.0f, lightningRender, blue, partialTicks, Vec3.f_82478_);
            this.spawnLightningBetweenEntities((Entity)lKnee, (Entity)lFoot, 0.0f, lightningRender, red, partialTicks, Vec3.f_82478_);
            Vec3 lightningHeadFrom = entityIn.m_20318_(partialTicks).m_82520_(0.0, 0.5, 0.0);
            float yawRadian = (float)Math.toRadians(-yaw);
            Vec3 lHeadFrom = lightningHeadFrom.m_82549_(new Vec3(0.2, 1.0, 0.0).m_82524_(yawRadian));
            Vec3 rHeadFrom = lightningHeadFrom.m_82549_(new Vec3(-0.2, 1.0, 0.0).m_82524_(yawRadian));
            this.spawnLightningBetweenVecs(entityIn, lightningHeadFrom.m_82549_(entityIn.lightningAnimOffsets[4]), lHeadFrom, lightningRender, blue, partialTicks);
            this.spawnLightningBetweenVecs(entityIn, lightningHeadFrom.m_82549_(entityIn.lightningAnimOffsets[5]), rHeadFrom, lightningRender, red, partialTicks);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(-x, -y, -z);
        lightningRender.render(partialTicks, poseStack, bufferIn);
        poseStack.m_85849_();
        if (!entityIn.m_6084_() && this.lightningRenderMap.containsKey(entityIn.m_20148_())) {
            this.lightningRenderMap.remove(entityIn.m_20148_());
        }
        poseStack.m_85849_();
    }

    private void rotateHandFor(PoseStack poseStack, MagnetronPartEntity part, MagnetronEntity.AttackPose attackPose, float poseProgress) {
        if (attackPose.isRotatedJoint(part.getJoint(), part.left)) {
            poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f * poseProgress));
        }
    }

    private void spawnLightningBetweenVecs(MagnetronEntity entityIn, Vec3 from, Vec3 end, LightningRender lightningRender, Vector4f color, float partialTicks) {
        float size = 0.1f;
        LightningBoltData.BoltRenderInfo blueBoltData = new LightningBoltData.BoltRenderInfo(0.05f, 0.05f, 0.0f, 0.0f, color, 0.3f);
        LightningBoltData bolt1 = new LightningBoltData(blueBoltData, from, end, 4).size(size).lifespan(2).spawn(LightningBoltData.SpawnFunction.NO_DELAY).fade(LightningBoltData.FadeFunction.fade((float)0.75f));
        if (!Minecraft.m_91087_().m_91104_()) {
            lightningRender.update((Object)entityIn, bolt1, partialTicks);
        }
    }

    private void spawnLightningBetweenEntities(Entity start, Entity end, float centerUp, LightningRender lightningRender, Vector4f color, float partialTicks, Vec3 offset) {
        int segCount = 14;
        float spreadFactor = 0.05f;
        float size = 0.15f;
        Vec3 sizeAdjust = new Vec3((double)size, (double)size, (double)size);
        LightningBoltData.BoltRenderInfo blueBoltData = new LightningBoltData.BoltRenderInfo(0.05f, spreadFactor, 0.0f, 0.0f, color, 0.0f);
        LightningBoltData bolt1 = new LightningBoltData(blueBoltData, start.m_20318_(partialTicks).m_82549_(sizeAdjust).m_82520_(offset.f_82479_, offset.f_82480_ + (double)centerUp, offset.f_82481_), end.m_20318_(partialTicks).m_82520_(0.0, 0.5, 0.0), segCount).size(size).lifespan(2).spawn(LightningBoltData.SpawnFunction.NO_DELAY).fade(LightningBoltData.FadeFunction.fade((float)0.75f));
        if (!Minecraft.m_91087_().m_91104_()) {
            lightningRender.update((Object)end, bolt1, partialTicks);
        }
    }

    private LightningRender getLightingRender(UUID uuid) {
        if (this.lightningRenderMap.get(uuid) == null) {
            this.lightningRenderMap.put(uuid, new LightningRender());
        }
        return this.lightningRenderMap.get(uuid);
    }

    public ResourceLocation getTextureLocation(MagnetronEntity entity) {
        return TEXTURE;
    }

    class LayerGlow
    extends RenderLayer<MagnetronEntity, MagnetronModel> {
        public LayerGlow() {
            super((RenderLayerParent)MagnetronRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, MagnetronEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            float alpha1 = (float)Math.sin(ageInTicks * 0.1f) * 0.5f + 0.5f;
            VertexConsumer ivertexbuilder1 = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_GLOW_BLUE));
            ((MagnetronModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder1, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, alpha1);
            float alpha2 = (float)Math.cos(ageInTicks * 0.1f) * 0.5f + 0.5f;
            VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_GLOW_RED));
            ((MagnetronModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder2, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, alpha2);
            VertexConsumer ivertexbuilder3 = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)TEXTURE_GLOW_EYES));
            ((MagnetronModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder3, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

