/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.gui;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.gui.SpelunkeryTableWordButton;
import com.github.alexmodguy.alexscaves.server.inventory.SpelunkeryTableMenu;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.CaveInfoItem;
import com.github.alexmodguy.alexscaves.server.message.SpelunkeryTableChangeMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.io.IOUtils;
import org.joml.Matrix4f;

public class SpelunkeryTableScreen
extends AbstractContainerScreen<SpelunkeryTableMenu> {
    protected static final Style GLYPH_FONT = Style.f_131099_.m_131150_(new ResourceLocation("minecraft", "alt"));
    public static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves", "textures/gui/spelunkery_table.png");
    public static final ResourceLocation TABLET_TEXTURE = new ResourceLocation("alexscaves", "textures/gui/spelunkery_table_tablet.png");
    public static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("alexscaves", "textures/gui/spelunkery_table_widgets.png");
    public static final ResourceLocation DEFAULT_WORDS = new ResourceLocation("alexscaves", "minigame/en_us/magnetic_caves.txt");
    private int tickCount = 0;
    private int attemptsLeft = 0;
    private boolean draggingMagnify = false;
    private float magnifyPosX;
    private float magnifyPosY;
    private float prevMagnifyPosX;
    private float prevMagnifyPosY;
    private int lastMouseX;
    private int lastMouseY;
    private ResourceLocation prevWordsFile = null;
    private List<SpelunkeryTableWordButton> wordButtons = new ArrayList<SpelunkeryTableWordButton>();
    private SpelunkeryTableWordButton targetWordButton = null;
    private int highlightColor = 0xFFFFFF;
    private int level = 0;
    private boolean finishedLevel;
    private float prevPassLevelProgress = 0.0f;
    private float passLevelProgress = 0.0f;
    private int tutorialStep = 0;
    private boolean hasClickedLens = false;
    private boolean doneWithTutorial = false;
    private boolean invalidTablet = false;
    private ItemStack lastTablet;
    private Random random = new Random();

    public SpelunkeryTableScreen(SpelunkeryTableMenu menu, Inventory inventory, Component name) {
        super((AbstractContainerMenu)menu, inventory, name);
        this.f_97726_ = 208;
        this.f_97727_ = 256;
        this.f_97728_ = this.f_97726_ / 2;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.prevMagnifyPosX = this.magnifyPosX = (float)(this.f_97735_ + 170);
        this.prevMagnifyPosY = this.magnifyPosY = (float)(this.f_97736_ + 130);
        for (SpelunkeryTableWordButton button : this.wordButtons) {
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTick) {
        this.m_280273_(guiGraphics);
        this.m_7286_(guiGraphics, partialTick, x, y);
        super.m_88315_(guiGraphics, x, y, partialTick);
        this.renderMagnify(guiGraphics, partialTick);
        this.m_280072_(guiGraphics, x, y);
        this.renderDescText(guiGraphics);
        this.renderTabletText(guiGraphics);
    }

    private void renderDescText(GuiGraphics guiGraphics) {
        block5: {
            int j;
            int i;
            block4: {
                i = this.f_97735_ - 58;
                j = this.f_97736_;
                if (!this.invalidTablet) break block4;
                MutableComponent badTablet = Component.m_237115_((String)"alexscaves.container.spelunkery_table.bad_tablet");
                guiGraphics.m_280614_(this.f_96547_, (Component)badTablet, this.f_97735_ + 105 - this.f_96547_.m_92852_((FormattedText)badTablet) / 2, j + 60, 0, false);
                CompoundTag badTag = ((SpelunkeryTableMenu)this.f_97732_).m_38853_(0).m_7993_().m_41783_();
                if (badTag == null || badTag.m_128456_()) break block5;
                int nbtLine = 0;
                for (String key : badTag.m_128431_()) {
                    MutableComponent badData = Component.m_237113_((String)(key + ": " + badTag.m_128423_(key).m_7916_()));
                    guiGraphics.m_280614_(this.f_96547_, (Component)badData, this.f_97735_ + 105 - this.f_96547_.m_92852_((FormattedText)badData) / 2, j + 75 + nbtLine, 0, false);
                    nbtLine += 9;
                }
                break block5;
            }
            if (this.targetWordButton != null && this.hasTablet() && this.hasPaper()) {
                MutableComponent find = Component.m_237115_((String)"alexscaves.container.spelunkery_table.find");
                MutableComponent attempts = Component.m_237115_((String)"alexscaves.container.spelunkery_table.attempts");
                guiGraphics.m_280614_(this.f_96547_, (Component)find, i + 20 - this.f_96547_.m_92852_((FormattedText)find) / 2, j + 20, 10061676, false);
                guiGraphics.m_280614_(this.f_96547_, this.targetWordButton.getNormalText(), i + 20 - this.f_96547_.m_92852_((FormattedText)this.targetWordButton.getNormalText()) / 2, j + 35, this.highlightColor, false);
                guiGraphics.m_280614_(this.f_96547_, (Component)attempts, i + 20 - this.f_96547_.m_92852_((FormattedText)attempts) / 2, j + 60, 10061676, false);
                int tallySpace = 0;
                for (int tally = 1; tally <= this.attemptsLeft; ++tally) {
                    if (tally % 5 == 0) {
                        guiGraphics.m_280218_(WIDGETS_TEXTURE, i + 10 + tallySpace - 22, j + 70, 3, 52, 27, 14);
                        tallySpace += 7;
                        continue;
                    }
                    guiGraphics.m_280218_(WIDGETS_TEXTURE, i + 10 + tallySpace, j + 70, 0, 52, 3, 14);
                    guiGraphics.m_280218_(WIDGETS_TEXTURE, i + 10 + tallySpace, j + 70, 0, 52, 3, 14);
                    tallySpace += 4;
                }
            }
        }
    }

    private void renderTabletText(GuiGraphics guiGraphics) {
        float partialTick = Minecraft.m_91087_().getPartialTick();
        float x = this.getMagnifyPosX(partialTick);
        float y = this.getMagnifyPosY(partialTick);
        if (this.hasTablet()) {
            guiGraphics.m_280168_().m_85836_();
            for (Renderable renderable : this.f_169369_) {
                if (!(renderable instanceof SpelunkeryTableWordButton)) continue;
                SpelunkeryTableWordButton tableWordButton = (SpelunkeryTableWordButton)renderable;
                tableWordButton.renderTranslationText(this.tickCount, this.highlightColor, guiGraphics, this.f_96547_, x + 5.0f, x + 32.0f, y + 6.0f, y + 32.0f);
            }
            guiGraphics.m_280168_().m_85849_();
        }
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isFirstTimeUsing() && this.tutorialStep < 6) {
            int i = this.f_97735_;
            int j = this.f_97736_;
            int exclaimX = 0;
            int exclaimY = 0;
            if (this.tutorialStep == 0) {
                exclaimX = 54;
                exclaimY = 143;
                if (mouseX > i + exclaimX - 5 && mouseY > j + exclaimY - 5 && mouseX < i + exclaimX + 15 && mouseY < j + exclaimY + 15) {
                    MutableComponent tabletName = Component.m_237115_((String)((Item)ACItemRegistry.CAVE_TABLET.get()).m_5524_()).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.YELLOW);
                    List<MutableComponent> step1Tooltip = List.of(Component.m_237110_((String)"alexscaves.container.spelunkery_table.slot_info_tablet_0", (Object[])new Object[]{tabletName}).m_130940_(ChatFormatting.GRAY), Component.m_237115_((String)"alexscaves.container.spelunkery_table.slot_info_tablet_1").m_130940_(ChatFormatting.GRAY));
                    guiGraphics.m_280677_(this.f_96547_, step1Tooltip, Optional.empty(), mouseX, mouseY);
                }
            } else if (this.tutorialStep == 1) {
                exclaimX = 74;
                exclaimY = 143;
                if (mouseX > i + exclaimX - 5 && mouseY > j + exclaimY - 5 && mouseX < i + exclaimX + 15 && mouseY < j + exclaimY + 15) {
                    MutableComponent paperName = Component.m_237115_((String)Items.f_42516_.m_5524_()).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.WHITE);
                    List<MutableComponent> step1Tooltip = List.of(Component.m_237110_((String)"alexscaves.container.spelunkery_table.slot_info_paper", (Object[])new Object[]{paperName}).m_130940_(ChatFormatting.GRAY));
                    guiGraphics.m_280677_(this.f_96547_, step1Tooltip, Optional.empty(), mouseX, mouseY);
                }
            } else if (this.tutorialStep == 2) {
                exclaimX = 170;
                exclaimY = 23;
                if (mouseX > i + exclaimX - 5 && mouseY > j + exclaimY - 5 && mouseX < i + exclaimX + 15 && mouseY < j + exclaimY + 15) {
                    List<MutableComponent> step1Tooltip = List.of(Component.m_237115_((String)"alexscaves.container.spelunkery_table.translate").m_130940_(ChatFormatting.GRAY));
                    guiGraphics.m_280677_(this.f_96547_, step1Tooltip, Optional.empty(), mouseX, mouseY);
                }
            } else if (this.tutorialStep == 3) {
                exclaimX = 185;
                exclaimY = 140;
                if (mouseX > i + exclaimX - 5 && mouseY > j + exclaimY - 5 && mouseX < i + exclaimX + 15 && mouseY < j + exclaimY + 15) {
                    List<MutableComponent> step1Tooltip = List.of(Component.m_237115_((String)"alexscaves.container.spelunkery_table.glass").m_130940_(ChatFormatting.GRAY));
                    guiGraphics.m_280677_(this.f_96547_, step1Tooltip, Optional.empty(), mouseX, mouseY);
                }
            } else if (this.tutorialStep == 4) {
                exclaimX = -15;
                exclaimY = 15;
                if (mouseX > i + exclaimX - 5 && mouseY > j + exclaimY - 5 && mouseX < i + exclaimX + 15 && mouseY < j + exclaimY + 15) {
                    List<MutableComponent> step1Tooltip = List.of(Component.m_237115_((String)"alexscaves.container.spelunkery_table.guess_name").m_130940_(ChatFormatting.GRAY));
                    guiGraphics.m_280677_(this.f_96547_, step1Tooltip, Optional.empty(), mouseX, mouseY);
                }
            } else if (this.tutorialStep == 5) {
                exclaimX = 35;
                exclaimY = 142;
                if (mouseX > i + exclaimX - 5 && mouseY > j + exclaimY - 5 && mouseX < i + exclaimX + 15 && mouseY < j + exclaimY + 15) {
                    MutableComponent scrollName = Component.m_237115_((String)((Item)ACItemRegistry.CAVE_CODEX.get()).m_5524_()).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.YELLOW);
                    int toDoLevels = Math.max(0, 3 - this.level);
                    List<MutableComponent> step1Tooltip = List.of(Component.m_237110_((String)(toDoLevels == 1 ? "alexscaves.container.spelunkery_table.level" : "alexscaves.container.spelunkery_table.levels"), (Object[])new Object[]{toDoLevels, scrollName}).m_130940_(ChatFormatting.GRAY));
                    guiGraphics.m_280677_(this.f_96547_, step1Tooltip, Optional.empty(), mouseX, mouseY);
                }
            }
            guiGraphics.m_280218_(WIDGETS_TEXTURE, i + exclaimX, j + exclaimY, this.tickCount % 20 < 10 ? 7 : 0, 70, 7, 16);
        }
        super.m_280072_(guiGraphics, mouseX, mouseY);
    }

    public float getMagnifyPosX(float f) {
        return this.prevMagnifyPosX + (this.magnifyPosX - this.prevMagnifyPosX) * f;
    }

    public float getMagnifyPosY(float f) {
        return this.prevMagnifyPosY + (this.magnifyPosY - this.prevMagnifyPosY) * f;
    }

    private void renderMagnify(GuiGraphics guiGraphics, float partialTick) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WIDGETS_TEXTURE);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        float actualPartialTick = Minecraft.m_91087_().m_91296_();
        float lerpX = this.getMagnifyPosX(actualPartialTick);
        float lerpY = this.getMagnifyPosY(actualPartialTick);
        float size = 0.1484375f;
        float u = 0.0f;
        float v = 0.0546875f;
        float x0 = lerpX;
        float x1 = lerpX + 38.0f;
        float y0 = lerpY;
        float y1 = lerpY + 38.0f;
        float u0 = u;
        float u1 = u + size;
        float v0 = v;
        float v1 = v + size;
        float zOffset = this.draggingMagnify ? 500.0f : 200.0f;
        bufferbuilder.m_252986_(matrix4f, x0, y0, zOffset).m_7421_(u0, v0).m_5752_();
        bufferbuilder.m_252986_(matrix4f, x0, y1, zOffset).m_7421_(u0, v1).m_5752_();
        bufferbuilder.m_252986_(matrix4f, x1, y1, zOffset).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_252986_(matrix4f, x1, y0, zOffset).m_7421_(u1, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    protected void m_7286_(GuiGraphics guiGraphics, float f, int x, int y) {
        int tablet;
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        for (int bulb = 0; bulb < Math.min(this.level, 3); ++bulb) {
            guiGraphics.m_280218_(WIDGETS_TEXTURE, i + 92 + bulb * 15, j + 143, 0, 0, 13, 14);
        }
        if (this.hasPaper()) {
            guiGraphics.m_280218_(WIDGETS_TEXTURE, i - 80, j + 10, 176, 0, 80, 149);
        }
        int n = this.hasTablet() ? (this.attemptsLeft <= 1 ? 2 : 1) : (tablet = 0);
        if (tablet > 0) {
            guiGraphics.m_280218_(TABLET_TEXTURE, i + 20, j + 19, 0, (tablet - 1) * 121, 168, 120);
        }
    }

    public boolean hasTablet() {
        return ((SpelunkeryTableMenu)this.f_97732_).m_38853_(0).m_6657_() && ((SpelunkeryTableMenu)this.f_97732_).m_38853_(0).m_7993_().m_150930_((Item)ACItemRegistry.CAVE_TABLET.get());
    }

    public boolean hasPaper() {
        return ((SpelunkeryTableMenu)this.f_97732_).m_38853_(1).m_6657_() && ((SpelunkeryTableMenu)this.f_97732_).m_38853_(1).m_7993_().m_150930_(Items.f_42516_);
    }

    public boolean isFirstTimeUsing() {
        return !AlexsCaves.PROXY.isSpelunkeryTutorialComplete();
    }

    protected void m_181908_() {
        boolean resetTabletFromWin;
        int maxDistance;
        int targetMagnifyY;
        int targetMagnifyX;
        ++this.tickCount;
        if (this.lastTablet == null && this.hasTablet()) {
            this.lastTablet = ((SpelunkeryTableMenu)this.f_97732_).m_38853_(0).m_7993_();
        } else if (this.lastTablet != null && this.hasTablet() && this.lastTablet != ((SpelunkeryTableMenu)this.f_97732_).m_38853_(0).m_7993_()) {
            this.lastTablet = ((SpelunkeryTableMenu)this.f_97732_).m_38853_(0).m_7993_();
            this.invalidTablet = false;
            this.fullResetWords();
        }
        this.prevMagnifyPosX = this.magnifyPosX;
        this.prevMagnifyPosY = this.magnifyPosY;
        this.prevPassLevelProgress = this.passLevelProgress;
        if (this.draggingMagnify) {
            targetMagnifyX = this.lastMouseX - 19;
            targetMagnifyY = this.lastMouseY - 19;
            maxDistance = 15;
        } else {
            targetMagnifyX = this.f_97735_ + 170;
            targetMagnifyY = this.f_97736_ + 130;
            maxDistance = 20;
        }
        Vec3 vec3 = new Vec3((double)((float)targetMagnifyX - this.magnifyPosX), (double)((float)targetMagnifyY - this.magnifyPosY), 0.0);
        if (vec3.m_82553_() > (double)maxDistance) {
            vec3 = vec3.m_82541_().m_82490_((double)maxDistance);
        }
        this.magnifyPosX = (float)((double)this.magnifyPosX + vec3.f_82479_);
        this.magnifyPosY = (float)((double)this.magnifyPosY + vec3.f_82480_);
        if (this.finishedLevel && this.passLevelProgress < 10.0f) {
            this.passLevelProgress += 0.5f;
        }
        if (!this.finishedLevel && this.passLevelProgress > 0.0f) {
            this.passLevelProgress -= 0.5f;
        }
        boolean bl = resetTabletFromWin = this.finishedLevel && this.passLevelProgress >= 10.0f && this.attemptsLeft > 0;
        if (!((SpelunkeryTableMenu)this.f_97732_).m_38853_(0).m_6657_()) {
            this.prevWordsFile = null;
            this.invalidTablet = false;
        } else if (this.prevWordsFile == null || resetTabletFromWin) {
            this.prevWordsFile = this.getWordsForItem(((SpelunkeryTableMenu)this.f_97732_).m_38853_(0).m_7993_());
            if (this.prevWordsFile == null) {
                this.clearWordWidgets();
            } else {
                this.finishedLevel = false;
                this.generateWords(this.prevWordsFile);
            }
        }
        int currentColor = ((SpelunkeryTableMenu)this.f_97732_).getHighlightColor((Level)Minecraft.m_91087_().f_91073_);
        if (currentColor != -1) {
            this.highlightColor = currentColor;
        }
        if (resetTabletFromWin && this.level >= 3) {
            this.doneWithTutorial = true;
            SpelunkeryTableMenu cfr_ignored_0 = (SpelunkeryTableMenu)this.f_97732_;
            SpelunkeryTableMenu.setTutorialComplete((Player)Minecraft.m_91087_().f_91074_, true);
            AlexsCaves.NETWORK_WRAPPER.sendToServer((Object)new SpelunkeryTableChangeMessage(true));
            this.level = 0;
            this.fullResetWords();
        } else if (this.finishedLevel && this.passLevelProgress >= 10.0f && this.attemptsLeft <= 0) {
            this.level = 0;
            AlexsCaves.NETWORK_WRAPPER.sendToServer((Object)new SpelunkeryTableChangeMessage(false));
            this.fullResetWords();
            Minecraft.m_91087_().m_91152_(null);
        }
        if (!this.hasTablet() && !this.wordButtons.isEmpty()) {
            this.clearWordWidgets();
        }
        this.tutorialStep = this.doneWithTutorial ? 6 : (!this.hasTablet() ? 0 : (!this.hasPaper() ? 1 : (this.attemptsLeft == 5 && this.level == 0 ? 2 : (!this.hasClickedLens ? 3 : (this.level == 0 ? 4 : 5)))));
    }

    public void fullResetWords() {
        this.clearWordWidgets();
        this.prevWordsFile = this.getWordsForItem(((SpelunkeryTableMenu)this.f_97732_).m_38853_(0).m_7993_());
        if (this.prevWordsFile != null) {
            this.generateWords(this.prevWordsFile);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean prev = super.m_6375_(mouseX, mouseY, button);
        if (!prev) {
            // empty if block
        }
        return prev;
    }

    public boolean m_7979_(double width, double height, int button, double x, double y) {
        boolean prev = super.m_7979_(width, height, button, x, y);
        if (prev) {
            this.lastMouseX = (int)width;
            this.lastMouseY = (int)height;
            if (!this.draggingMagnify && (float)this.lastMouseX >= this.magnifyPosX && (float)this.lastMouseX <= this.magnifyPosX + 38.0f && (float)this.lastMouseY >= this.magnifyPosY && (float)this.lastMouseY <= this.magnifyPosY + 38.0f) {
                this.draggingMagnify = true;
                if (this.tutorialStep > 2) {
                    this.hasClickedLens = true;
                }
            }
        }
        return prev;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.draggingMagnify = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.f_97729_, 0x404040, false);
    }

    private ResourceLocation getWordsForItem(ItemStack stack) {
        if (stack.m_41619_() || stack.m_41720_() != ACItemRegistry.CAVE_TABLET.get()) {
            return null;
        }
        String s1 = this.getMinigameStr(stack) + ".txt";
        String lang = Minecraft.m_91087_().m_91102_().m_264236_().toLowerCase();
        ResourceLocation resourceLocation = new ResourceLocation("alexscaves", "minigame/" + lang + "/" + s1);
        try {
            InputStream is = Minecraft.m_91087_().m_91098_().m_215595_(resourceLocation);
            is.close();
        }
        catch (Exception var4) {
            AlexsCaves.LOGGER.warn("Could not find language file for translation, defaulting to english");
            resourceLocation = new ResourceLocation("alexscaves", "minigame/en_us/" + s1);
        }
        return resourceLocation;
    }

    private String getMinigameStr(ItemStack stack) {
        ResourceKey<Biome> biomeResourceKey = CaveInfoItem.getCaveBiome(stack);
        return biomeResourceKey == null ? "magnetic_caves" : biomeResourceKey.m_135782_().m_135815_();
    }

    private void clearWordWidgets() {
        for (SpelunkeryTableWordButton button : this.wordButtons) {
            this.m_169411_((GuiEventListener)button);
        }
        this.wordButtons.clear();
    }

    private void addWordWidget(SpelunkeryTableWordButton button) {
        this.wordButtons.add(button);
        this.m_142416_((GuiEventListener)button);
    }

    private void generateWords(ResourceLocation file) {
        List allWords;
        this.clearWordWidgets();
        try {
            BufferedReader bufferedreader = Minecraft.m_91087_().m_91098_().m_215597_(file);
            allWords = IOUtils.readLines((Reader)bufferedreader);
        }
        catch (IOException e) {
            allWords = new ArrayList();
            this.invalidTablet = true;
            AlexsCaves.LOGGER.error("Could not load in spelunkery minigame file {}", (Object)file);
        }
        int maxWidth = 160;
        int maxLines = 8;
        int wordLineWidth = 0;
        int letterWidth = 6;
        Collections.shuffle(allWords);
        for (int wordLines = 0; wordLines < maxLines && !allWords.isEmpty(); ++wordLines) {
            MutableComponent component = Component.m_237113_((String)((String)allWords.remove(0)));
            int maxWordWidth = component.getString().length() * letterWidth;
            while (wordLineWidth + maxWordWidth + 30 < maxWidth && !allWords.isEmpty()) {
                component = Component.m_237113_((String)((String)allWords.remove(0)).toUpperCase());
                maxWordWidth = component.getString().length() * letterWidth;
                SpelunkeryTableWordButton tableWordButton = new SpelunkeryTableWordButton(this, this.f_96547_, 25 + wordLineWidth, 25 + 12 * wordLines, maxWordWidth, 12, (Component)component.m_130948_(Style.f_131099_));
                this.addWordWidget(tableWordButton);
                wordLineWidth += maxWordWidth;
            }
            wordLineWidth = 0;
        }
        if (!this.wordButtons.isEmpty()) {
            if (Minecraft.m_91087_().f_91073_ != null) {
                this.targetWordButton = this.wordButtons.size() <= 1 ? this.wordButtons.get(0) : this.wordButtons.get(this.random.nextInt(this.wordButtons.size()));
            }
            this.attemptsLeft = 5;
        } else {
            this.targetWordButton = null;
        }
    }

    public int getHighlightColor() {
        return this.highlightColor;
    }

    public void onClickWord(SpelunkeryTableWordButton tableWordButton) {
        if (this.finishedLevel) {
            return;
        }
        if (tableWordButton == this.targetWordButton) {
            ++this.level;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)(this.level >= 3 ? (SoundEvent)ACSoundRegistry.SPELUNKERY_TABLE_SUCCESS_COMPLETE.get() : (SoundEvent)ACSoundRegistry.SPELUNKERY_TABLE_SUCCESS.get()), (float)1.0f));
            this.finishedLevel = true;
        } else {
            if (this.attemptsLeft > 0) {
                --this.attemptsLeft;
            }
            if (this.attemptsLeft <= 1) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ACSoundRegistry.SPELUNKERY_TABLE_CRACK.get()), (float)1.0f));
            } else {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ACSoundRegistry.SPELUNKERY_TABLE_ATTEMPT_FAIL.get()), (float)1.0f));
            }
            if (this.attemptsLeft <= 0) {
                this.finishedLevel = true;
            }
        }
    }

    public float getRevealWordsAmount(float partialTick) {
        if (this.finishedLevel) {
            return Math.min((this.prevPassLevelProgress + (this.passLevelProgress - this.prevPassLevelProgress) * partialTick) * 0.33f, 1.0f);
        }
        return 0.0f;
    }

    public boolean isTargetWord(SpelunkeryTableWordButton tableWordButton) {
        return this.targetWordButton == tableWordButton;
    }

    private boolean hasClickedAnyWord() {
        boolean flag = false;
        for (SpelunkeryTableWordButton button : this.wordButtons) {
            if (button.f_93623_) continue;
            flag = true;
        }
        return flag;
    }

    public void m_7379_() {
        if (this.hasPaper() && this.hasTablet() && this.hasClickedAnyWord() && this.level < 3) {
            AlexsCaves.NETWORK_WRAPPER.sendToServer((Object)new SpelunkeryTableChangeMessage(false));
        }
        super.m_7379_();
    }
}

