/*
 * Decompiled with CFR 0.152.
 */
package net.ravenbird.spartan_ascent.trait;

import com.google.common.collect.ImmutableMultimap;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.ravenbird.spartan_ascent.trait.CritWeaponTrait;
import net.ravenbird.spartan_ascent.util.ModAttributes;

public class PiercingTrait
extends CritWeaponTrait {
    public static final UUID CRIT_MODIFIER = UUID.fromString("988dfe64-fa45-4a0f-a93b-102b7707a598");

    public PiercingTrait() {
        super("piercing", "spartan_ascent", WeaponTrait.TraitQuality.NEUTRAL);
        this.setMelee();
    }

    public String getDescription() {
        return "Critical hits are more common and cause 50% of the damage to directly reduce target's health";
    }

    public void onModifyAttributesMelee(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        builder.put((Object)((Attribute)ModAttributes.CRITICAL_CHANCE.get()), (Object)new AttributeModifier(CRIT_MODIFIER, "Crit chance modifier", 0.15, AttributeModifier.Operation.ADDITION));
    }

    @Override
    public float modifyCritDealt(WeaponMaterial material, float baseDamage, LivingEntity attacker, LivingEntity target) {
        if (!target.m_20147_()) {
            target.m_21153_(target.m_21223_() - baseDamage / 2.0f);
            return baseDamage / 2.0f;
        }
        return baseDamage;
    }
}

