/*
 * Decompiled with CFR 0.152.
 */
package net.ravenbird.spartan_ascent.event;

import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.init.ModDamageTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.ravenbird.spartan_ascent.event.RandomCritEvent;
import net.ravenbird.spartan_ascent.trait.CritWeaponTrait;
import net.ravenbird.spartan_ascent.util.CritCalculator;
import net.ravenbird.spartan_ascent.util.CustomHooks;

@Mod.EventBusSubscriber(modid="spartan_ascent")
public class CritEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCriticalHit(CriticalHitEvent event) {
        event.setResult(Event.Result.DENY);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof LivingEntity) {
            LivingEntity pAttacker = (LivingEntity)attacker;
            if (event.getSource().m_276093_(DamageTypes.f_268464_) || event.getSource().m_276093_(DamageTypes.f_268566_) || event.getSource().m_276093_(ModDamageTypes.KEY_ARMOR_PIERCING_MELEE)) {
                LivingEntity target = event.getEntity();
                boolean rollCrit = CritCalculator.rollCrit(pAttacker);
                if (rollCrit) {
                    float newDamage = CustomHooks.onRandomCrit(pAttacker, target, event.getAmount() * CritCalculator.critMult(pAttacker));
                    event.setAmount(newDamage);
                    target.m_5496_(SoundEvents.f_12313_, 1.7f, 1.0f);
                    CritEventHandler.spawnCritParticles(target);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onCritDealt(RandomCritEvent event) {
        Item item;
        float baseDamage;
        LivingEntity attacker = event.getEntity();
        LivingEntity target = event.getTarget();
        float modifiedDamage = baseDamage = event.getAmount();
        ItemStack attackerWeapon = attacker.m_21205_();
        if (!attackerWeapon.m_41619_() && (item = attackerWeapon.m_41720_()) instanceof IWeaponTraitContainer) {
            IWeaponTraitContainer container = (IWeaponTraitContainer)item;
            for (WeaponTrait trait : container.getAllWeaponTraits()) {
                if (!(trait instanceof CritWeaponTrait)) continue;
                CritWeaponTrait critTrait = (CritWeaponTrait)trait;
                modifiedDamage = critTrait.modifyCritDealt(container.getMaterial(), baseDamage, attacker, target);
            }
        }
        if (baseDamage != modifiedDamage) {
            event.setAmount(modifiedDamage);
        }
    }

    private static void spawnCritParticles(LivingEntity target) {
        Level pLevel = target.m_9236_();
        if (pLevel instanceof ServerLevel) {
            ServerLevel pServerLevel = (ServerLevel)pLevel;
            for (int i = 0; i < 15; ++i) {
                pServerLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, target.m_20208_(1.0), target.m_20187_(), target.m_20262_(1.0), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

