/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.render.entity;

import com.eeeab.animate.client.util.ModelPartUtils;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.eeeabsmobs.client.model.entity.ModelImmortal;
import com.eeeab.eeeabsmobs.client.model.util.EMModelLayer;
import com.eeeab.eeeabsmobs.client.render.EMRenderType;
import com.eeeab.eeeabsmobs.client.render.layer.LayerGlow;
import com.eeeab.eeeabsmobs.client.render.layer.LayerOuter;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortal;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class RenderImmortal
extends MobRenderer<EntityImmortal, ModelImmortal> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("eeeabsmobs", "textures/entity/immortal/immortal_boss/immortal.png");
    private static final ResourceLocation GLOW_LAYER = new ResourceLocation("eeeabsmobs", "textures/entity/immortal/immortal_boss/immortal_eyes.png");
    private static final ResourceLocation CORE_LAYER = new ResourceLocation("eeeabsmobs", "textures/entity/immortal/immortal_boss/immortal_core.png");
    private static final ResourceLocation NETHERWORLD_KATANA = new ResourceLocation("eeeabsmobs", "textures/entity/immortal/immortal_boss/immortal_netherworld_katana.png");
    private static final String[] RIGHT_FIST = new String[]{"upper", "body", "rightArm", "rightArmUnder", "rightFist"};
    private static final String[] LEFT_FIST = new String[]{"upper", "body", "leftArm", "leftArmUnder", "leftFist"};

    public RenderImmortal(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelImmortal(context.m_174023_(EMModelLayer.IMMORTAL)), 2.0f);
        this.m_115326_(new LayerGlow<EntityImmortal, ModelImmortal>((RenderLayerParent)this, GLOW_LAYER, 1.0f, e -> e.isGlow() && !e.m_20145_()){

            @Override
            protected float getBrightness(EntityImmortal entity, float partialTicks) {
                return entity.glowControllerAnimation.getAnimationFraction(partialTicks);
            }

            @Override
            protected RenderType getRenderType(EntityImmortal entity) {
                return RenderType.m_234338_((ResourceLocation)this.location);
            }
        });
        this.m_115326_(new LayerOuter<EntityImmortal, ModelImmortal>((RenderLayerParent)this, CORE_LAYER, true, e -> !e.m_20145_()){

            @Override
            protected void renderLayer(PoseStack stack, VertexConsumer vertexConsumer, int packedLightIn, float partialTicks, EntityImmortal entity, boolean overlayTexture) {
                overlayTexture = entity.getAnimation() != entity.unleashEnergyAnimation && entity.hurtControllerAnimation.isStop();
                super.renderLayer(stack, vertexConsumer, packedLightIn, partialTicks, entity, overlayTexture);
            }

            @Override
            protected float getAlpha(EntityImmortal entity, float partialTicks) {
                return 1.0f - entity.alphaControllerAnimation.getAnimationFraction(partialTicks);
            }
        });
        LayerOuter.OuterPredicate<EntityImmortal> predicate1 = e -> e.isHoldKatana() && !e.m_20145_();
        this.m_115326_(new LayerOuter<EntityImmortal, ModelImmortal>((RenderLayerParent)this, NETHERWORLD_KATANA, true, predicate1){

            @Override
            protected float getAlpha(EntityImmortal entity, float partialTicks) {
                return 1.0f - entity.alphaControllerAnimation.getAnimationFraction(partialTicks);
            }
        });
    }

    protected void scale(EntityImmortal entity, PoseStack matrixStack, float partialTickTime) {
        matrixStack.m_85841_(0.86625f, 0.86625f, 0.86625f);
    }

    protected float getFlipDegrees(EntityImmortal entity) {
        return 0.0f;
    }

    public void render(EntityImmortal entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        if (!entity.alphaControllerAnimation.isStop()) {
            alpha = 1.0f - entity.alphaControllerAnimation.getAnimationFraction(partialTicks);
            this.f_114477_ *= alpha;
            this.f_114478_ *= alpha;
            int packedOverlay = RenderImmortal.m_115338_((LivingEntity)entity, (float)this.m_6931_((LivingEntity)entity, partialTicks));
            this.render(EMRenderType.getGlowingCutOutEffect(this.getTextureLocation(entity), true), entity, partialTicks, alpha, matrixStack, buffer, packedLight, packedOverlay);
        } else if (!entity.hurtControllerAnimation.isStop()) {
            this.f_114478_ = 1.0f;
            this.f_114477_ = 2.0f;
            alpha = 1.0f - entity.hurtControllerAnimation.getAnimationFraction(partialTicks) * 0.85f;
            this.render(EMRenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)), entity, partialTicks, alpha, matrixStack, buffer, packedLight, OverlayTexture.f_118083_);
        } else {
            this.f_114478_ = 1.0f;
            this.f_114477_ = 2.0f;
            super.m_7392_((Mob)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        }
        Animation animation = entity.getAnimation();
        if (animation == entity.shoryukenAnimation || animation == entity.attractAnimation || animation == entity.punchRightAnimation || animation == entity.smashGround1Animation || animation == entity.smashGround2Animation || animation == entity.smashGround3Animation || animation == entity.punchLeftAnimation || animation == entity.pounceSmashAnimation || animation == entity.hardPunchLeftAnimation || animation == entity.hardPunchRightAnimation) {
            entity.hand[0] = ModelPartUtils.getWorldPosition((Entity)entity, entity.f_20883_, ((ModelImmortal)this.f_115290_).root(), LEFT_FIST);
            entity.hand[1] = ModelPartUtils.getWorldPosition((Entity)entity, entity.f_20883_, ((ModelImmortal)this.f_115290_).root(), RIGHT_FIST);
        }
    }

    private void render(RenderType renderType, EntityImmortal entity, float partialTicks, float alpha, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntity)entity, (LivingEntityRenderer)this, partialTicks, matrixStack, buffer, packedLight))) {
            return;
        }
        matrixStack.m_85836_();
        ((ModelImmortal)this.f_115290_).f_102608_ = this.m_115342_((LivingEntity)entity, partialTicks);
        ((ModelImmortal)this.f_115290_).f_102609_ = shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        ((ModelImmortal)this.f_115290_).f_102610_ = entity.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)entity.f_20886_, (float)entity.f_20885_);
        float f2 = f1 - f;
        float f6 = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        float f7 = this.m_6930_((LivingEntity)entity, partialTicks);
        this.m_7523_((LivingEntity)entity, matrixStack, f7, f, partialTicks);
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.scale(entity, matrixStack, partialTicks);
        matrixStack.m_252880_(0.0f, -1.501f, 0.0f);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entity.m_6084_()) {
            f8 = entity.f_267362_.m_267711_(partialTicks);
            f5 = entity.f_267362_.m_267590_(partialTicks);
            if (entity.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((ModelImmortal)this.f_115290_).m_6839_((Entity)entity, f5, f8, partialTicks);
        ((ModelImmortal)this.f_115290_).setupAnim(entity, f5, f8, f7, f2, f6);
        VertexConsumer vertexconsumer = buffer.m_6299_(renderType);
        ((ModelImmortal)this.f_115290_).m_7695_(matrixStack, vertexconsumer, packedLight, packedOverlay, alpha, alpha, alpha, alpha);
        for (RenderLayer renderlayer : this.f_115291_) {
            renderlayer.m_6494_(matrixStack, buffer, packedLight, (Entity)entity, f5, f8, partialTicks, f7, f2, f6);
        }
        matrixStack.m_85849_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)entity, (LivingEntityRenderer)this, partialTicks, matrixStack, buffer, packedLight));
    }

    public Vec3 getRenderOffset(EntityImmortal entity, float partialTicks) {
        RandomSource random = entity.m_217043_();
        if (entity.getAnimation() == entity.teleportAnimation && entity.getAnimationTick() > 10) {
            double d0 = 0.05;
            return new Vec3(random.m_188583_() * d0, 0.0, random.m_188583_() * d0);
        }
        if (!entity.hurtControllerAnimation.isStop()) {
            double d0 = (double)entity.hurtControllerAnimation.getAnimationFraction(partialTicks) * 0.1;
            return new Vec3(random.m_188583_() * d0, 0.0, random.m_188583_() * d0);
        }
        return super.m_7860_((Entity)entity, partialTicks);
    }

    public ResourceLocation getTextureLocation(EntityImmortal immortal) {
        return TEXTURE;
    }

    protected int getBlockLightLevel(EntityImmortal entity, BlockPos pos) {
        return (int)Math.max(15.0f * entity.glowControllerAnimation.getAnimationFraction(), (float)super.m_6086_((Entity)entity, pos));
    }
}

