/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.particle.util;

import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleBase;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleComponent;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleRotation;
import com.eeeab.eeeabsmobs.client.particle.util.RibbonComponent;
import com.eeeab.eeeabsmobs.client.particle.util.RibbonParticleData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class ParticleRibbon
extends AdvancedParticleBase {
    public Vec3[] positions;
    public Vec3[] prevPositions;
    public float texPanOffset;

    protected ParticleRibbon(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, ParticleRotation rotation, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, int length, ParticleComponent[] components, SpriteSet spriteSet) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, motionX, motionY, motionZ, rotation, scale, r, g, b, a, drag, duration, emissive, false, components, spriteSet);
        this.positions = new Vec3[length];
        this.prevPositions = new Vec3[length];
        if (this.positions.length >= 1) {
            this.positions[0] = new Vec3(this.getPosX(), this.getPosY(), this.getPosZ());
        }
        if (this.prevPositions.length >= 1) {
            this.prevPositions[0] = this.getPrevPos();
        }
    }

    @Override
    protected void updatePosition() {
        super.updatePosition();
    }

    @Override
    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        this.alpha = this.prevAlpha + (this.alpha - this.prevAlpha) * partialTicks;
        if ((double)this.alpha < 0.01) {
            this.alpha = 0.01f;
        }
        this.f_107227_ = this.prevRed + (this.red - this.prevRed) * partialTicks;
        this.f_107228_ = this.prevGreen + (this.green - this.prevGreen) * partialTicks;
        this.f_107229_ = this.prevBlue + (this.blue - this.prevBlue) * partialTicks;
        this.particleScale = this.prevScale + (this.scale - this.prevScale) * partialTicks;
        for (ParticleComponent component : this.components) {
            component.preRender(this, partialTicks);
        }
        int j = this.m_6355_(partialTicks);
        float r = this.f_107227_;
        float g = this.f_107228_;
        float b = this.f_107229_;
        float a = this.alpha;
        float scale = this.particleScale;
        float prevR = r;
        float prevG = g;
        float prevB = b;
        float prevA = a;
        float prevScale = scale;
        for (ParticleComponent component : this.components) {
            if (!(component instanceof RibbonComponent.PropertyOverLength)) continue;
            ParticleComponent[] pOverLength = (ParticleComponent[])component;
            float value = pOverLength.evaluate(0.0f);
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE) {
                prevScale *= value;
                continue;
            }
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.RED) {
                prevR *= value;
                continue;
            }
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.GREEN) {
                prevG *= value;
                continue;
            }
            if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.BLUE) {
                prevB *= value;
                continue;
            }
            if (pOverLength.getProperty() != RibbonComponent.PropertyOverLength.EnumRibbonProperty.ALPHA) continue;
            prevA *= value;
        }
        Vec3 offsetDir = new Vec3(0.0, 0.0, 0.0);
        for (int index = 0; index < this.positions.length - 1; ++index) {
            if (this.positions[index] == null || this.positions[index + 1] == null) continue;
            r = this.f_107227_;
            g = this.f_107228_;
            b = this.f_107229_;
            scale = this.particleScale;
            float t = ((float)index + 1.0f) / ((float)this.positions.length - 1.0f);
            float tPrev = (float)index / ((float)this.positions.length - 1.0f);
            for (ParticleComponent component : this.components) {
                if (!(component instanceof RibbonComponent.PropertyOverLength)) continue;
                RibbonComponent.PropertyOverLength pOverLength = (RibbonComponent.PropertyOverLength)component;
                float value = pOverLength.evaluate(t);
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE) {
                    scale *= value;
                    continue;
                }
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.RED) {
                    r *= value;
                    continue;
                }
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.GREEN) {
                    g *= value;
                    continue;
                }
                if (pOverLength.getProperty() == RibbonComponent.PropertyOverLength.EnumRibbonProperty.BLUE) {
                    b *= value;
                    continue;
                }
                if (pOverLength.getProperty() != RibbonComponent.PropertyOverLength.EnumRibbonProperty.ALPHA) continue;
                a *= value;
            }
            Vec3 Vector3d = renderInfo.m_90583_();
            Vec3 p1 = this.prevPositions[index].m_82549_(this.positions[index].m_82546_(this.prevPositions[index]).m_82490_((double)partialTicks)).m_82546_(Vector3d);
            Vec3 p2 = this.prevPositions[index + 1].m_82549_(this.positions[index + 1].m_82546_(this.prevPositions[index + 1]).m_82490_((double)partialTicks)).m_82546_(Vector3d);
            if (index == 0) {
                Vec3 moveDir = p2.m_82546_(p1).m_82541_();
                if (this.rotation instanceof ParticleRotation.FaceCamera) {
                    Vec3 viewVec = new Vec3(renderInfo.m_253058_());
                    offsetDir = moveDir.m_82537_(viewVec).m_82541_();
                } else {
                    offsetDir = moveDir.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
                }
                offsetDir = offsetDir.m_82490_((double)prevScale);
            }
            Vec3[] aVector3d2 = new Vec3[]{offsetDir.m_82490_(-1.0), offsetDir, null, null};
            Vec3 moveDir = p2.m_82546_(p1).m_82541_();
            if (this.rotation instanceof ParticleRotation.FaceCamera) {
                Vec3 viewVec = new Vec3(renderInfo.m_253058_());
                offsetDir = moveDir.m_82537_(viewVec).m_82541_();
            } else {
                offsetDir = moveDir.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            }
            aVector3d2[2] = offsetDir = offsetDir.m_82490_((double)scale);
            aVector3d2[3] = offsetDir.m_82490_(-1.0);
            Vector4f[] vertices2 = new Vector4f[]{new Vector4f((float)aVector3d2[0].f_82479_, (float)aVector3d2[0].f_82480_, (float)aVector3d2[0].f_82481_, 1.0f), new Vector4f((float)aVector3d2[1].f_82479_, (float)aVector3d2[1].f_82480_, (float)aVector3d2[1].f_82481_, 1.0f), new Vector4f((float)aVector3d2[2].f_82479_, (float)aVector3d2[2].f_82480_, (float)aVector3d2[2].f_82481_, 1.0f), new Vector4f((float)aVector3d2[3].f_82479_, (float)aVector3d2[3].f_82480_, (float)aVector3d2[3].f_82481_, 1.0f)};
            Matrix4f boxTranslate = new Matrix4f().translate((float)p1.f_82479_, (float)p1.f_82480_, (float)p1.f_82481_);
            vertices2[0].mul((Matrix4fc)boxTranslate);
            vertices2[1].mul((Matrix4fc)boxTranslate);
            boxTranslate = new Matrix4f().translate((float)p2.f_82479_, (float)p2.f_82480_, (float)p2.f_82481_);
            vertices2[2].mul((Matrix4fc)boxTranslate);
            vertices2[3].mul((Matrix4fc)boxTranslate);
            float halfU = (this.m_5952_() - this.m_5970_()) / 2.0f + this.m_5970_();
            float f = this.m_5970_() + this.texPanOffset;
            float f1 = halfU + this.texPanOffset;
            float f2 = this.m_5951_();
            float f3 = this.m_5950_();
            buffer.m_5483_((double)vertices2[0].x(), (double)vertices2[0].y(), (double)vertices2[0].z()).m_7421_(f1, f3).m_85950_(prevR, prevG, prevB, prevA).m_85969_(j).m_5752_();
            buffer.m_5483_((double)vertices2[1].x(), (double)vertices2[1].y(), (double)vertices2[1].z()).m_7421_(f1, f2).m_85950_(prevR, prevG, prevB, prevA).m_85969_(j).m_5752_();
            buffer.m_5483_((double)vertices2[2].x(), (double)vertices2[2].y(), (double)vertices2[2].z()).m_7421_(f, f2).m_85950_(r, g, b, a).m_85969_(j).m_5752_();
            buffer.m_5483_((double)vertices2[3].x(), (double)vertices2[3].y(), (double)vertices2[3].z()).m_7421_(f, f3).m_85950_(r, g, b, a).m_85969_(j).m_5752_();
            prevR = r;
            prevG = g;
            prevB = b;
            prevA = a;
        }
        for (ParticleComponent component : this.components) {
            component.postRender(this, buffer, renderInfo, partialTicks, j);
        }
    }

    public AABB m_107277_() {
        if (this.positions == null || this.positions.length <= 0 || this.positions[0] == null) {
            return super.m_107277_();
        }
        double minX = this.positions[0].m_7096_() - 0.1;
        double minY = this.positions[0].m_7098_() - 0.1;
        double minZ = this.positions[0].m_7094_() - 0.1;
        double maxX = this.positions[0].m_7096_() + 0.1;
        double maxY = this.positions[0].m_7098_() + 0.1;
        double maxZ = this.positions[0].m_7094_() + 0.1;
        for (Vec3 pos : this.positions) {
            if (pos == null) continue;
            minX = Math.min(minX, pos.m_7096_());
            minY = Math.min(minY, pos.m_7098_());
            minZ = Math.min(minZ, pos.m_7094_());
            maxX = Math.max(maxX, pos.m_7096_());
            maxY = Math.max(maxY, pos.m_7098_());
            maxZ = Math.max(maxZ, pos.m_7094_());
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public float getMinUPublic() {
        return this.m_5970_();
    }

    public float getMaxUPublic() {
        return this.m_5952_();
    }

    public float getMinVPublic() {
        return this.m_5951_();
    }

    public float getMaxVPublic() {
        return this.m_5950_();
    }

    public static void spawnRibbon(Level world, ParticleType<? extends RibbonParticleData> particle, int length, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, boolean isAnimation) {
        ParticleRibbon.spawnRibbon(world, particle, length, x, y, z, motionX, motionY, motionZ, faceCamera, yaw, pitch, roll, scale, r, g, b, a, drag, duration, emissive, new ParticleComponent[0], isAnimation);
    }

    public static void spawnRibbon(Level world, ParticleType<? extends RibbonParticleData> particle, int length, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, ParticleComponent[] components, boolean isAnimation) {
        ParticleRotation rotation = faceCamera ? new ParticleRotation.FaceCamera(0.0f) : new ParticleRotation.EulerAngles((float)yaw, (float)pitch, (float)roll);
        world.m_7106_((ParticleOptions)new RibbonParticleData(particle, rotation, scale, r, g, b, a, drag, duration, emissive, length, components, isAnimation), x, y, z, motionX, motionY, motionZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Factory
    implements ParticleProvider<RibbonParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(RibbonParticleData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleRibbon particle;
            if (typeIn.isAnimation()) {
                particle = new ParticleRibbon(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getRotation(), typeIn.getScale(), typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue(), typeIn.getAlpha(), typeIn.getAirDiffusionSpeed(), typeIn.getDuration(), typeIn.isEmissive(), typeIn.getLength(), typeIn.getComponents(), this.spriteSet);
                particle.m_108339_(this.spriteSet);
            } else {
                particle = new ParticleRibbon(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getRotation(), typeIn.getScale(), typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue(), typeIn.getAlpha(), typeIn.getAirDiffusionSpeed(), typeIn.getDuration(), typeIn.isEmissive(), typeIn.getLength(), typeIn.getComponents(), null);
                particle.m_108335_(this.spriteSet);
            }
            return particle;
        }
    }
}

