/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util.animation;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.LineSegment;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Sphere;
import qouteall.q_misc_util.my_util.WithDim;
import qouteall.q_misc_util.my_util.animation.RenderedLineSegment;
import qouteall.q_misc_util.my_util.animation.RenderedPlane;
import qouteall.q_misc_util.my_util.animation.RenderedPoint;
import qouteall.q_misc_util.my_util.animation.RenderedSphere;

public class Animated<T> {
    public final TypeInfo<T> typeInfo;
    public final TimeSupplier timeSupplier;
    @Nullable
    public T startValue;
    @Nullable
    public T endValue;
    public long startTime = 0L;
    public long duration = 0L;
    private TimingFunction timingFunction;
    public static final TypeInfo<Vec3> VEC3_NULLABLE_TYPE_INFO = new TypeInfo<Vec3>(){

        @Override
        public Vec3 interpolate(Vec3 start, Vec3 end, double progress) {
            return start.m_165921_(end, progress);
        }

        @Override
        public boolean isClose(Vec3 a, Vec3 b) {
            return a.m_82557_(b) < 0.01;
        }
    };
    public static final TypeInfo<Vec3> VEC_3_TYPE_INFO = new TypeInfo<Vec3>(){

        @Override
        public Vec3 interpolate(Vec3 start, Vec3 end, double progress) {
            return start.m_165921_(end, progress);
        }

        @Override
        public boolean isClose(Vec3 a, Vec3 b) {
            return a.m_82557_(b) < 0.01;
        }

        @Override
        public Vec3 getEmpty() {
            return Vec3.f_82478_;
        }
    };
    public static final TypeInfo<Double> DOUBLE_TYPE_INFO = new TypeInfo<Double>(){

        @Override
        public Double interpolate(Double start, Double end, double progress) {
            if (start == null) {
                start = 0.0;
            }
            if (end == null) {
                end = 0.0;
            }
            return start + (end - start) * progress;
        }

        @Override
        public boolean isClose(Double a, Double b) {
            if (a == null) {
                a = 0.0;
            }
            if (b == null) {
                b = 0.0;
            }
            return Math.abs(a - b) < 0.001;
        }

        @Override
        public Double getEmpty() {
            return 0.0;
        }
    };
    public static final TypeInfo<DQuaternion> QUATERNION_TYPE_INFO = new TypeInfo<DQuaternion>(){

        @Override
        public DQuaternion interpolate(DQuaternion start, DQuaternion end, double progress) {
            return DQuaternion.interpolate(start, end, progress);
        }

        @Override
        public boolean isClose(DQuaternion a, DQuaternion b) {
            return DQuaternion.isClose(a, b, 0.01);
        }
    };
    public static final TypeInfo<RenderedPlane> RENDERED_PLANE_TYPE_INFO = new TypeInfo<RenderedPlane>(){

        @Override
        public RenderedPlane interpolate(RenderedPlane start, RenderedPlane end, double progress) {
            Validate.notNull((Object)start);
            Validate.notNull((Object)end);
            if (start.plane() == null && end.plane() == null) {
                return start;
            }
            double destScale = start.scale() + (end.scale() - start.scale()) * progress;
            if (destScale < 0.01) {
                return RenderedPlane.NONE;
            }
            if (start.plane() == null) {
                return new RenderedPlane(end.plane(), destScale);
            }
            if (end.plane() == null) {
                return new RenderedPlane(start.plane(), destScale);
            }
            if (start.plane().dimension() != end.plane().dimension()) {
                return end;
            }
            return new RenderedPlane(new WithDim<Plane>(start.plane().dimension(), Plane.interpolate(start.plane().value(), end.plane().value(), progress)), destScale);
        }

        @Override
        public boolean isClose(RenderedPlane a, RenderedPlane b) {
            if (a.plane() == null && b.plane() == null) {
                return true;
            }
            if (a.plane() == null || b.plane() == null) {
                return false;
            }
            if (a.plane().dimension() != b.plane().dimension()) {
                return false;
            }
            return a.plane().value().pos().m_82557_(b.plane().value().pos()) < 0.01 && a.plane().value().normal().m_82557_(b.plane().value().normal()) < 0.01 && Math.abs(a.scale() - b.scale()) < 0.01;
        }

        @Override
        public RenderedPlane getEmpty() {
            return RenderedPlane.NONE;
        }
    };
    public static final TypeInfo<RenderedSphere> RENDERED_SPHERE_TYPE_INFO = new TypeInfo<RenderedSphere>(){

        @Override
        public RenderedSphere interpolate(RenderedSphere start, RenderedSphere end, double progress) {
            Validate.notNull((Object)start);
            Validate.notNull((Object)end);
            if (start.sphere() == null && end.sphere() == null) {
                return start;
            }
            double destScale = start.scale() + (end.scale() - start.scale()) * progress;
            if (destScale < 0.01) {
                return RenderedSphere.NONE;
            }
            if (start.sphere() == null) {
                return new RenderedSphere(end.sphere(), end.orientation(), destScale);
            }
            if (end.sphere() == null) {
                return new RenderedSphere(start.sphere(), start.orientation(), destScale);
            }
            if (start.sphere().dimension() != end.sphere().dimension()) {
                return end;
            }
            return new RenderedSphere(new WithDim<Sphere>(start.sphere().dimension(), Sphere.interpolate(start.sphere().value(), end.sphere().value(), progress)), DQuaternion.interpolate(start.orientation(), end.orientation(), progress), destScale);
        }

        @Override
        public boolean isClose(RenderedSphere a, RenderedSphere b) {
            if (a.sphere() == null && b.sphere() == null) {
                return true;
            }
            if (a.sphere() == null || b.sphere() == null) {
                return false;
            }
            if (a.sphere().dimension() != b.sphere().dimension()) {
                return false;
            }
            return a.sphere().value().center().m_82557_(b.sphere().value().center()) < 0.01 && Math.abs(a.sphere().value().radius() - b.sphere().value().radius()) < 0.01 && Math.abs(a.scale() - b.scale()) < 0.01;
        }

        @Override
        public RenderedSphere getEmpty() {
            return RenderedSphere.NONE;
        }
    };
    public static final TypeInfo<RenderedPoint> RENDERED_POINT_TYPE_INFO = new TypeInfo<RenderedPoint>(){

        @Override
        public RenderedPoint interpolate(RenderedPoint start, RenderedPoint end, double progress) {
            if (start.pos() == null && end.pos() == null) {
                return start;
            }
            double destScale = start.scale() + (end.scale() - start.scale()) * progress;
            if (destScale < 0.01) {
                return RenderedPoint.EMPTY;
            }
            if (start.pos() == null) {
                return new RenderedPoint(end.pos(), destScale);
            }
            if (end.pos() == null) {
                return new RenderedPoint(start.pos(), destScale);
            }
            if (start.pos().dimension() != end.pos().dimension()) {
                return end;
            }
            return new RenderedPoint(new WithDim<Vec3>(start.pos().dimension(), start.pos().value().m_165921_(end.pos().value(), progress)), destScale);
        }

        @Override
        public boolean isClose(RenderedPoint a, RenderedPoint b) {
            if (a.pos() == null && b.pos() == null) {
                return true;
            }
            if (a.pos() == null || b.pos() == null) {
                return false;
            }
            if (a.pos().dimension() != b.pos().dimension()) {
                return false;
            }
            return a.pos().value().m_82557_(b.pos().value()) < 0.01 && Math.abs(a.scale() - b.scale()) < 0.01;
        }

        @Override
        public RenderedPoint getEmpty() {
            return RenderedPoint.EMPTY;
        }
    };
    public static final TypeInfo<RenderedLineSegment> RENDERED_LINE_SEGMENT_TYPE_INFO = new TypeInfo<RenderedLineSegment>(){

        @Override
        public RenderedLineSegment interpolate(RenderedLineSegment start, RenderedLineSegment end, double progress) {
            if (start.lineSegment() == null && end.lineSegment() == null) {
                return start;
            }
            double destScale = start.scale() + (end.scale() - start.scale()) * progress;
            if (destScale < 0.01) {
                return RenderedLineSegment.EMPTY;
            }
            if (start.lineSegment() == null) {
                return new RenderedLineSegment(end.lineSegment(), destScale);
            }
            if (end.lineSegment() == null) {
                return new RenderedLineSegment(start.lineSegment(), destScale);
            }
            if (start.lineSegment().dimension() != end.lineSegment().dimension()) {
                return end;
            }
            return new RenderedLineSegment(new WithDim<LineSegment>(start.lineSegment().dimension(), start.lineSegment().value().interpolate(start.lineSegment().value(), end.lineSegment().value(), progress)), destScale);
        }

        @Override
        public boolean isClose(RenderedLineSegment a, RenderedLineSegment b) {
            if (a.lineSegment() == null && b.lineSegment() == null) {
                return true;
            }
            if (a.lineSegment() == null || b.lineSegment() == null) {
                return false;
            }
            if (a.lineSegment().dimension() != b.lineSegment().dimension()) {
                return false;
            }
            return a.lineSegment().value().isClose(b.lineSegment().value(), 0.01) && Math.abs(a.scale() - b.scale()) < 0.01;
        }

        @Override
        public RenderedLineSegment getEmpty() {
            return RenderedLineSegment.EMPTY;
        }
    };

    public Animated(TypeInfo<T> typeInfo, TimeSupplier timeSupplier, TimingFunction timingFunction, @Nullable T initialValue) {
        this.typeInfo = typeInfo;
        this.timeSupplier = timeSupplier;
        this.timingFunction = timingFunction;
        this.startValue = initialValue;
        this.endValue = initialValue;
    }

    public void setTarget(@Nullable T value, long newDuration) {
        if (this.endValue != null && value != null && this.typeInfo.isClose(this.endValue, value)) {
            this.endValue = value;
            return;
        }
        if (value == null) {
            this.startValue = null;
            this.endValue = null;
            this.startTime = 0L;
        } else {
            long time = this.timeSupplier.getTime();
            if (this.startValue == null) {
                this.startValue = value;
                this.endValue = value;
                this.startTime = time;
            } else {
                this.startValue = this.getCurrent();
                this.endValue = value;
                this.startTime = time;
            }
            this.duration = newDuration;
        }
    }

    public void clearTarget() {
        this.setTarget(this.typeInfo.getEmpty(), this.duration);
    }

    @Nullable
    public T getTarget() {
        return this.endValue;
    }

    @Nullable
    public T getCurrent() {
        if (this.startValue == null || this.endValue == null) {
            return null;
        }
        if (this.startTime == 0L) {
            return this.startValue;
        }
        if (this.duration == 0L) {
            return this.endValue;
        }
        double progress = Mth.m_14008_((double)((double)(this.timeSupplier.getTime() - this.startTime) / (double)this.duration), (double)0.0, (double)1.0);
        if (progress >= 0.999) {
            return this.endValue;
        }
        return this.typeInfo.interpolate(this.startValue, this.endValue, this.timingFunction.apply(progress));
    }

    public void setTimingFunction(TimingFunction timingFunction) {
        this.setTarget(this.getTarget(), this.duration);
        this.timingFunction = timingFunction;
    }

    public static interface TypeInfo<T> {
        public T interpolate(T var1, T var2, double var3);

        public boolean isClose(T var1, T var2);

        default public T getEmpty() {
            return null;
        }
    }

    public static interface TimeSupplier {
        public long getTime();
    }

    public static interface TimingFunction {
        public double apply(double var1);
    }
}

