/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.GeometryUtil;
import qouteall.q_misc_util.my_util.QuadTree;
import qouteall.q_misc_util.my_util.Range;
import qouteall.q_misc_util.my_util.Vec2d;

public class Mesh2D {
    public static final int gridCountForOneSide = 0x40000000;
    public final Long2IntOpenHashMap gridToPointIndex = new Long2IntOpenHashMap();
    public final DoubleArrayList pointCoords = new DoubleArrayList();
    public final IntArrayList trianglePointIndexes = new IntArrayList();
    public final ObjectArrayList<IntArrayList> pointToTriangles = new ObjectArrayList();
    @Nullable
    public QuadTree<IntArrayList> triangleLookup;

    public static long encodeToGrid(double x, double y) {
        int gridX = (int)Math.round(x * 1.073741824E9);
        int gridY = (int)Math.round(y * 1.073741824E9);
        int gridXClamped = Mth.m_14045_((int)gridX, (int)-1073741824, (int)0x40000000);
        int gridYClamped = Mth.m_14045_((int)gridY, (int)-1073741824, (int)0x40000000);
        return ((long)gridXClamped & 0xFFFFFFFFL) << 32 | (long)gridYClamped & 0xFFFFFFFFL;
    }

    public int addTriangle(double x1, double y1, double x2, double y2, double x3, double y3) {
        int pointIndex1 = this.indexPoint(x1, y1);
        int pointIndex2 = this.indexPoint(x2, y2);
        int pointIndex3 = this.indexPoint(x3, y3);
        return this.addTriangle(pointIndex1, pointIndex2, pointIndex3);
    }

    public int addTriangle(int pointIndex0, int pointIndex1, int pointIndex2) {
        double p2y;
        double p2x;
        double p1y;
        if (pointIndex0 == pointIndex1 || pointIndex1 == pointIndex2 || pointIndex2 == pointIndex0) {
            return -1;
        }
        double p0x = this.pointCoords.getDouble(pointIndex0 * 2);
        double p0y = this.pointCoords.getDouble(pointIndex0 * 2 + 1);
        double p1x = this.pointCoords.getDouble(pointIndex1 * 2);
        double cross = Helper.crossProduct2D(p1x - p0x, (p1y = this.pointCoords.getDouble(pointIndex1 * 2 + 1)) - p0y, (p2x = this.pointCoords.getDouble(pointIndex2 * 2)) - p0x, (p2y = this.pointCoords.getDouble(pointIndex2 * 2 + 1)) - p0y);
        if (Math.abs(cross) < 1.0E-9) {
            return -1;
        }
        int triangleIndex = this.getStoredTriangleNum();
        this.trianglePointIndexes.add(pointIndex0);
        if (cross > 0.0) {
            this.trianglePointIndexes.add(pointIndex1);
            this.trianglePointIndexes.add(pointIndex2);
        } else {
            this.trianglePointIndexes.add(pointIndex2);
            this.trianglePointIndexes.add(pointIndex1);
        }
        ((IntArrayList)this.pointToTriangles.get(pointIndex0)).add(triangleIndex);
        ((IntArrayList)this.pointToTriangles.get(pointIndex1)).add(triangleIndex);
        ((IntArrayList)this.pointToTriangles.get(pointIndex2)).add(triangleIndex);
        Validate.isTrue((boolean)this.isTriangleValid(triangleIndex));
        this.notifyTriangleAddedForQuadTree(triangleIndex);
        return triangleIndex;
    }

    public int indexPoint(double x, double y) {
        long grid = Mesh2D.encodeToGrid(x = Mth.m_14008_((double)x, (double)-1.0, (double)1.0), y = Mth.m_14008_((double)y, (double)-1.0, (double)1.0));
        int pointIndex = this.gridToPointIndex.getOrDefault(grid, -1);
        if (pointIndex == -1) {
            pointIndex = this.pointCoords.size() / 2;
            this.pointCoords.add(x);
            this.pointCoords.add(y);
            this.gridToPointIndex.put(grid, pointIndex);
            this.pointToTriangles.add((Object)new IntArrayList());
        }
        return pointIndex;
    }

    public double getAngleFromOneCorner(int pointIndex, int triangleIndex) {
        int otherP2Index;
        int otherP1Index;
        int p1Index = this.trianglePointIndexes.getInt(triangleIndex * 3);
        int p2Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
        int p3Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
        if (pointIndex == p1Index) {
            otherP1Index = p2Index;
            otherP2Index = p3Index;
        } else if (pointIndex == p2Index) {
            otherP1Index = p1Index;
            otherP2Index = p3Index;
        } else if (pointIndex == p3Index) {
            otherP1Index = p1Index;
            otherP2Index = p2Index;
        } else {
            throw new IllegalArgumentException();
        }
        double x1 = this.pointCoords.getDouble(pointIndex * 2);
        double y1 = this.pointCoords.getDouble(pointIndex * 2 + 1);
        double x2 = this.pointCoords.getDouble(otherP1Index * 2);
        double y2 = this.pointCoords.getDouble(otherP1Index * 2 + 1);
        double x3 = this.pointCoords.getDouble(otherP2Index * 2);
        double y3 = this.pointCoords.getDouble(otherP2Index * 2 + 1);
        double dx1 = x2 - x1;
        double dy1 = y2 - y1;
        double dx2 = x3 - x1;
        double dy2 = y3 - y1;
        return GeometryUtil.getAngle(dx1, dy1, dx2, dy2);
    }

    public double getExposingAngle(int pointIndex) {
        IntArrayList triangles = (IntArrayList)this.pointToTriangles.get(pointIndex);
        if (triangles.size() == 0) {
            return 0.0;
        }
        double sumAngle = 0.0;
        IntIterator iter = triangles.intIterator();
        while (iter.hasNext()) {
            int triangleIndex = iter.nextInt();
            sumAngle += this.getAngleFromOneCorner(pointIndex, triangleIndex);
        }
        return sumAngle;
    }

    public boolean isPointInsideMesh(int pointIndex) {
        return Math.abs(this.getExposingAngle(pointIndex) - Math.PI * 2) < 1.0E-5;
    }

    public void removeTriangle(int triangleIndex) {
        this.notifyTriangleRemovedForQuadTree(triangleIndex);
        int p1Index = this.trianglePointIndexes.getInt(triangleIndex * 3);
        int p2Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
        int p3Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
        ((IntArrayList)this.pointToTriangles.get(p1Index)).rem(triangleIndex);
        ((IntArrayList)this.pointToTriangles.get(p2Index)).rem(triangleIndex);
        ((IntArrayList)this.pointToTriangles.get(p3Index)).rem(triangleIndex);
        this.trianglePointIndexes.set(triangleIndex * 3, -1);
        this.trianglePointIndexes.set(triangleIndex * 3 + 1, -1);
        this.trianglePointIndexes.set(triangleIndex * 3 + 2, -1);
    }

    public boolean isTriangleValid(int triangleIndex) {
        if (triangleIndex == -1) {
            return false;
        }
        return this.trianglePointIndexes.getInt(triangleIndex * 3) != -1;
    }

    public boolean isPointUsed(int pointIndex) {
        Validate.isTrue((pointIndex != -1 ? 1 : 0) != 0);
        return !((IntArrayList)this.pointToTriangles.get(pointIndex)).isEmpty();
    }

    public int getStoredPointNum() {
        return this.pointCoords.size() / 2;
    }

    public int getStoredTriangleNum() {
        return this.trianglePointIndexes.size() / 3;
    }

    public int getTrianglePointIndex(int triangleIndex, int indexInTriangle) {
        return this.trianglePointIndexes.getInt(triangleIndex * 3 + indexInTriangle);
    }

    public void updateTrianglePoint(int triangleIndex, int pointIndexInTriangle, int newPointIndex) {
        this.notifyTriangleRemovedForQuadTree(triangleIndex);
        int oldPointIndex = this.trianglePointIndexes.getInt(triangleIndex * 3 + pointIndexInTriangle);
        ((IntArrayList)this.pointToTriangles.get(oldPointIndex)).rem(triangleIndex);
        ((IntArrayList)this.pointToTriangles.get(newPointIndex)).add(triangleIndex);
        this.trianglePointIndexes.set(triangleIndex * 3 + pointIndexInTriangle, newPointIndex);
        this.turnTriangleToCounterClockwise(triangleIndex);
        this.notifyTriangleAddedForQuadTree(triangleIndex);
    }

    public boolean turnTriangleToCounterClockwise(int triangleIndex) {
        Validate.isTrue((boolean)this.isTriangleValid(triangleIndex));
        int p0Index = this.getTrianglePointIndex(triangleIndex, 0);
        int p1Index = this.getTrianglePointIndex(triangleIndex, 1);
        int p2Index = this.getTrianglePointIndex(triangleIndex, 2);
        double p0x = this.pointCoords.getDouble(p0Index * 2);
        double p0y = this.pointCoords.getDouble(p0Index * 2 + 1);
        double p1x = this.pointCoords.getDouble(p1Index * 2);
        double p1y = this.pointCoords.getDouble(p1Index * 2 + 1);
        double p2x = this.pointCoords.getDouble(p2Index * 2);
        double p2y = this.pointCoords.getDouble(p2Index * 2 + 1);
        double cross = Helper.crossProduct2D(p1x - p0x, p1y - p0y, p2x - p0x, p2y - p0y);
        if (cross < 0.0) {
            this.trianglePointIndexes.set(triangleIndex * 3 + 1, p2Index);
            this.trianglePointIndexes.set(triangleIndex * 3 + 2, p1Index);
            return true;
        }
        return false;
    }

    public boolean canCollapseEdge(int destPointIndex, int movingPointIndex) {
        IntArrayList trianglesMoving = (IntArrayList)this.pointToTriangles.get(movingPointIndex);
        IntIterator iter = trianglesMoving.intIterator();
        while (iter.hasNext()) {
            double np2y;
            double np2x;
            double np1y;
            int triangleIndex = iter.nextInt();
            int p0IndexInTriangle = this.trianglePointIndexes.getInt(triangleIndex * 3);
            int p1IndexInTriangle = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
            int p2IndexInTriangle = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
            if (p0IndexInTriangle == movingPointIndex) {
                p0IndexInTriangle = destPointIndex;
            }
            if (p1IndexInTriangle == movingPointIndex) {
                p1IndexInTriangle = destPointIndex;
            }
            if (p2IndexInTriangle == movingPointIndex) {
                p2IndexInTriangle = destPointIndex;
            }
            if (p0IndexInTriangle == p1IndexInTriangle || p0IndexInTriangle == p2IndexInTriangle || p1IndexInTriangle == p2IndexInTriangle) continue;
            double np0x = this.pointCoords.getDouble(p0IndexInTriangle * 2);
            double np0y = this.pointCoords.getDouble(p0IndexInTriangle * 2 + 1);
            double np1x = this.pointCoords.getDouble(p1IndexInTriangle * 2);
            double cross = Helper.crossProduct2D(np1x - np0x, (np1y = this.pointCoords.getDouble(p1IndexInTriangle * 2 + 1)) - np0y, (np2x = this.pointCoords.getDouble(p2IndexInTriangle * 2)) - np0x, (np2y = this.pointCoords.getDouble(p2IndexInTriangle * 2 + 1)) - np0y);
            if (!(cross < 0.0)) continue;
            return false;
        }
        return true;
    }

    public void collapseEdge(int destPointIndex, int movingPointIndex) {
        IntArrayList relevantTriangles = new IntArrayList((IntList)this.pointToTriangles.get(movingPointIndex));
        IntIterator iter = relevantTriangles.intIterator();
        while (iter.hasNext()) {
            int triangleIndex = iter.nextInt();
            int p0IndexInTriangle = this.trianglePointIndexes.getInt(triangleIndex * 3);
            int p1IndexInTriangle = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
            int p2IndexInTriangle = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
            if (p0IndexInTriangle == movingPointIndex) {
                this.updateTrianglePoint(triangleIndex, 0, destPointIndex);
                p0IndexInTriangle = destPointIndex;
            }
            if (p1IndexInTriangle == movingPointIndex) {
                this.updateTrianglePoint(triangleIndex, 1, destPointIndex);
                p1IndexInTriangle = destPointIndex;
            }
            if (p2IndexInTriangle == movingPointIndex) {
                this.updateTrianglePoint(triangleIndex, 2, destPointIndex);
                p2IndexInTriangle = destPointIndex;
            }
            if (p0IndexInTriangle != p1IndexInTriangle && p0IndexInTriangle != p2IndexInTriangle && p1IndexInTriangle != p2IndexInTriangle) continue;
            this.removeTriangle(triangleIndex);
        }
    }

    private int tryToCollapseInnerEdge(int startPointIndex) {
        for (int i = startPointIndex; i < this.pointCoords.size() / 2; ++i) {
            if (!this.isPointUsed(i) || !this.isPointInsideMesh(i)) continue;
            IntArrayList triangles = (IntArrayList)this.pointToTriangles.get(i);
            IntIterator iter = triangles.intIterator();
            while (iter.hasNext()) {
                int triangleIndex = iter.nextInt();
                int p0Index = this.trianglePointIndexes.getInt(triangleIndex * 3);
                int p1Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
                int p2Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
                if (p1Index == i && this.canCollapseEdge(p0Index, p1Index)) {
                    this.collapseEdge(p0Index, p1Index);
                    return i;
                }
                if (p2Index == i && this.canCollapseEdge(p1Index, p2Index)) {
                    this.collapseEdge(p1Index, p2Index);
                    return i;
                }
                if (p0Index != i || !this.canCollapseEdge(p2Index, p0Index)) continue;
                this.collapseEdge(p2Index, p0Index);
                return i;
            }
        }
        return -1;
    }

    private int tryToCollapseOuterEdgeAndTooShortEdges(int startPointIndex) {
        for (int i = 0; i < this.pointCoords.size() / 2; ++i) {
            if (!this.isPointUsed(i)) continue;
            double x = this.pointCoords.getDouble(i * 2);
            double y = this.pointCoords.getDouble(i * 2 + 1);
            IntOpenHashSet adjacentVertices = this.adjacentVerticesFrom(i);
            double exposingAngle = this.getExposingAngle(i);
            boolean isOnOuterEdgeStraightLine = Math.abs(exposingAngle - Math.PI) < 1.0E-4;
            IntIterator iter1 = adjacentVertices.intIterator();
            while (iter1.hasNext()) {
                int p1 = iter1.nextInt();
                IntIterator iter2 = adjacentVertices.intIterator();
                while (iter2.hasNext()) {
                    int p2 = iter2.nextInt();
                    if (p1 >= p2) continue;
                    double p1x = this.pointCoords.getDouble(p1 * 2);
                    double p1y = this.pointCoords.getDouble(p1 * 2 + 1);
                    double p2x = this.pointCoords.getDouble(p2 * 2);
                    double p2y = this.pointCoords.getDouble(p2 * 2 + 1);
                    boolean collinear = GeometryUtil.isOppositeVec(p1x - x, p1y - y, p2x - x, p2y - y);
                    double lenSq = (p1x - p2x) * (p1x - p2x) + (p1y - p2y) * (p1y - p2y);
                    if ((!isOnOuterEdgeStraightLine || !collinear) && !(lenSq < 1.0E-8) || !this.canCollapseEdge(p1, i)) continue;
                    this.collapseEdge(p1, i);
                    return i;
                }
            }
        }
        return -1;
    }

    public void simplify() {
        this.simplifySteps(this.getStoredTriangleNum());
    }

    public int simplifySteps(int countLimit) {
        this.fixEdgeCrossingPoint();
        int count = 0;
        int innerEdgeCollapsePointIndex = 0;
        int outerEdgeCollapsePointIndex = 0;
        while (count < countLimit) {
            if (innerEdgeCollapsePointIndex != -1) {
                if ((innerEdgeCollapsePointIndex = this.tryToCollapseInnerEdge(innerEdgeCollapsePointIndex)) == -1) continue;
                ++count;
                continue;
            }
            if (outerEdgeCollapsePointIndex == -1) break;
            if ((outerEdgeCollapsePointIndex = this.tryToCollapseOuterEdgeAndTooShortEdges(outerEdgeCollapsePointIndex)) == -1) continue;
            ++count;
        }
        return count;
    }

    public static double select(int index, double n1, double n2, double n3) {
        return switch (index) {
            case 0 -> n1;
            case 1 -> n2;
            case 2 -> n3;
            default -> throw new IllegalArgumentException();
        };
    }

    public void subtractTriangleFromMesh(double tp0x, double tp0y, double tp1x, double tp1y, double tp2x, double tp2y) {
        this.enableTriangleLookup();
        double cuttingBbMinX = Math.min(Math.min(tp0x, tp1x), tp2x);
        double cuttingBbMinY = Math.min(Math.min(tp0y, tp1y), tp2y);
        double cuttingBbMaxX = Math.max(Math.max(tp0x, tp1x), tp2x);
        double cuttingBbMaxY = Math.max(Math.max(tp0y, tp1y), tp2y);
        IntArrayList relevantTriangles = new IntArrayList();
        this.traverseTrianglesByBB(cuttingBbMinX, cuttingBbMinY, cuttingBbMaxX, cuttingBbMaxY, ti -> {
            relevantTriangles.add(ti);
            return null;
        });
        relevantTriangles.intStream().forEach(ti -> this.subtractTriangleForOneTriangle(ti, tp0x, tp0y, tp1x, tp1y, tp2x, tp2y));
    }

    @Nullable
    private IntArrayList subtractTriangleForOneTriangle(int targetTriangleIndex, double tp0x, double tp0y, double tp1x, double tp1y, double tp2x, double tp2y) {
        GeometryUtil.Line2D[] lines;
        if (!this.triangleIntersects(targetTriangleIndex, tp0x, tp0y, tp1x, tp1y, tp2x, tp2y)) {
            return null;
        }
        IntArrayList relevantTriangles = new IntArrayList();
        relevantTriangles.add(targetTriangleIndex);
        IntArrayList tempTriangles = new IntArrayList();
        GeometryUtil.Line2D line01 = GeometryUtil.Line2D.fromTwoPoints(tp0x, tp0y, tp1x, tp1y);
        GeometryUtil.Line2D line12 = GeometryUtil.Line2D.fromTwoPoints(tp1x, tp1y, tp2x, tp2y);
        GeometryUtil.Line2D line20 = GeometryUtil.Line2D.fromTwoPoints(tp2x, tp2y, tp0x, tp0y);
        for (GeometryUtil.Line2D line : lines = new GeometryUtil.Line2D[]{line01, line12, line20}) {
            IntIterator iter = relevantTriangles.intIterator();
            while (iter.hasNext()) {
                int triangleIndex2 = iter.nextInt();
                IntArrayList r = this.dissectTriangleByLine(triangleIndex2, line);
                if (r == null) {
                    tempTriangles.add(triangleIndex2);
                    continue;
                }
                tempTriangles.addAll((IntList)r);
            }
            relevantTriangles.clear();
            IntArrayList swappingTemp = relevantTriangles;
            relevantTriangles = tempTriangles;
            tempTriangles = swappingTemp;
        }
        relevantTriangles.removeIf(triangleIndex -> {
            boolean shouldRemove;
            Validate.isTrue((triangleIndex != -1 ? 1 : 0) != 0);
            int p1Index = this.trianglePointIndexes.getInt(triangleIndex * 3);
            int p2Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
            int p3Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
            double p0x = this.pointCoords.getDouble(p1Index * 2);
            double p0y = this.pointCoords.getDouble(p1Index * 2 + 1);
            double p1x = this.pointCoords.getDouble(p2Index * 2);
            double p1y = this.pointCoords.getDouble(p2Index * 2 + 1);
            double p2x = this.pointCoords.getDouble(p3Index * 2);
            double p2y = this.pointCoords.getDouble(p3Index * 2 + 1);
            double centerX = (p0x + p1x + p2x) / 3.0;
            double centerY = (p0y + p1y + p2y) / 3.0;
            boolean bl = shouldRemove = line01.testSideBool(centerX, centerY) && line12.testSideBool(centerX, centerY) && line20.testSideBool(centerX, centerY);
            if (shouldRemove) {
                this.removeTriangle(triangleIndex);
            }
            return shouldRemove;
        });
        return relevantTriangles;
    }

    @Nullable
    public IntArrayList dissectTriangleByLine(int triangleIndex, GeometryUtil.Line2D line) {
        int p1Index = this.trianglePointIndexes.getInt(triangleIndex * 3);
        int p2Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
        int p3Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
        double p0x = this.pointCoords.getDouble(p1Index * 2);
        double p0y = this.pointCoords.getDouble(p1Index * 2 + 1);
        double p1x = this.pointCoords.getDouble(p2Index * 2);
        double p1y = this.pointCoords.getDouble(p2Index * 2 + 1);
        double p2x = this.pointCoords.getDouble(p3Index * 2);
        double p2y = this.pointCoords.getDouble(p3Index * 2 + 1);
        boolean side0 = line.testSideBool(p0x, p0y);
        boolean side1 = line.testSideBool(p1x, p1y);
        boolean side2 = line.testSideBool(p2x, p2y);
        if (side0 == side1 && side1 == side2) {
            return null;
        }
        if (side0 == side1) {
            return this.dissectTriangleByEdgesFromVertex(triangleIndex, line, 2);
        }
        if (side1 == side2) {
            return this.dissectTriangleByEdgesFromVertex(triangleIndex, line, 0);
        }
        if (side2 == side0) {
            return this.dissectTriangleByEdgesFromVertex(triangleIndex, line, 1);
        }
        throw new IllegalStateException();
    }

    @Nullable
    private IntArrayList dissectTriangleByEdgesFromVertex(int triangleIndex, GeometryUtil.Line2D line, int v0) {
        double iy;
        double ix;
        double iy2;
        double ix2;
        int v1 = (v0 + 1) % 3;
        int v2 = (v0 + 2) % 3;
        int p0Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + v0);
        int p1Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + v1);
        int p2Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + v2);
        double p0x = this.pointCoords.getDouble(p0Index * 2);
        double p0y = this.pointCoords.getDouble(p0Index * 2 + 1);
        double p1x = this.pointCoords.getDouble(p1Index * 2);
        double p1y = this.pointCoords.getDouble(p1Index * 2 + 1);
        double p2x = this.pointCoords.getDouble(p2Index * 2);
        double p2y = this.pointCoords.getDouble(p2Index * 2 + 1);
        GeometryUtil.Line2D line01 = GeometryUtil.Line2D.fromTwoPoints(p0x, p0y, p1x, p1y);
        GeometryUtil.Line2D line02 = GeometryUtil.Line2D.fromTwoPoints(p0x, p0y, p2x, p2y);
        double t01 = line01.getIntersectionWithLine(line);
        double t02 = line02.getIntersectionWithLine(line);
        int intersectionPoint01 = -1;
        if (!Double.isNaN(t01) && t01 >= 0.0 && t01 <= 1.0 && ((intersectionPoint01 = this.indexPoint(ix2 = line01.linePX() + t01 * line01.dirX(), iy2 = line01.linePY() + t01 * line01.dirY())) == p0Index || intersectionPoint01 == p1Index)) {
            intersectionPoint01 = -1;
        }
        int intersectionPoint02 = -1;
        if (!Double.isNaN(t02) && t02 >= 0.0 && t02 <= 1.0 && ((intersectionPoint02 = this.indexPoint(ix = line02.linePX() + t02 * line02.dirX(), iy = line02.linePY() + t02 * line02.dirY())) == p0Index || intersectionPoint02 == p2Index)) {
            intersectionPoint02 = -1;
        }
        if (intersectionPoint01 == -1 && intersectionPoint02 == -1) {
            return null;
        }
        if (intersectionPoint01 != -1 && intersectionPoint02 != -1) {
            int t3;
            int t2;
            this.removeTriangle(triangleIndex);
            int t1 = this.addTriangle(p0Index, intersectionPoint01, intersectionPoint02);
            int quadP0Index = p1Index;
            int quadP1Index = p2Index;
            int quadP2Index = intersectionPoint02;
            int quadP3Index = intersectionPoint01;
            if (this.getDistanceSq(quadP0Index, quadP2Index) < this.getDistanceSq(quadP1Index, quadP3Index)) {
                t2 = this.addTriangle(quadP0Index, quadP1Index, quadP2Index);
                t3 = this.addTriangle(quadP0Index, quadP2Index, quadP3Index);
            } else {
                t2 = this.addTriangle(quadP0Index, quadP1Index, quadP3Index);
                t3 = this.addTriangle(quadP1Index, quadP2Index, quadP3Index);
            }
            IntArrayList result = new IntArrayList();
            if (t1 != -1) {
                result.add(t1);
            }
            if (t2 != -1) {
                result.add(t2);
            }
            if (t3 != -1) {
                result.add(t3);
            }
            return result;
        }
        if (intersectionPoint01 != -1) {
            this.removeTriangle(triangleIndex);
            int t1 = this.addTriangle(p1Index, p2Index, intersectionPoint01);
            int t2 = this.addTriangle(p2Index, p0Index, intersectionPoint01);
            IntArrayList result = new IntArrayList();
            if (t1 != -1) {
                result.add(t1);
            }
            if (t2 != -1) {
                result.add(t2);
            }
            return result;
        }
        if (intersectionPoint02 != -1) {
            this.removeTriangle(triangleIndex);
            int t1 = this.addTriangle(p0Index, p1Index, intersectionPoint02);
            int t2 = this.addTriangle(p1Index, p2Index, intersectionPoint02);
            IntArrayList result = new IntArrayList();
            if (t1 != -1) {
                result.add(t1);
            }
            if (t2 != -1) {
                result.add(t2);
            }
            return result;
        }
        throw new IllegalStateException();
    }

    public IntOpenHashSet adjacentVerticesFrom(int pointIndex) {
        IntOpenHashSet result = new IntOpenHashSet();
        IntArrayList triangleIds = (IntArrayList)this.pointToTriangles.get(pointIndex);
        IntIterator iter = triangleIds.intIterator();
        while (iter.hasNext()) {
            int ti = iter.nextInt();
            int p0Index = this.trianglePointIndexes.getInt(ti * 3);
            int p1Index = this.trianglePointIndexes.getInt(ti * 3 + 1);
            int p2Index = this.trianglePointIndexes.getInt(ti * 3 + 2);
            if (p0Index == pointIndex) {
                result.add(p1Index);
                result.add(p2Index);
                continue;
            }
            if (p1Index == pointIndex) {
                result.add(p0Index);
                result.add(p2Index);
                continue;
            }
            if (p2Index != pointIndex) continue;
            result.add(p0Index);
            result.add(p1Index);
        }
        return result;
    }

    private double getDistance(int p1Index, int p2Index) {
        return Math.sqrt(this.getDistanceSq(p1Index, p2Index));
    }

    private double getDistanceSq(int p1Index, int p2Index) {
        double p1x = this.pointCoords.getDouble(p1Index * 2);
        double p1y = this.pointCoords.getDouble(p1Index * 2 + 1);
        double p2x = this.pointCoords.getDouble(p2Index * 2);
        double p2y = this.pointCoords.getDouble(p2Index * 2 + 1);
        return (p1x - p2x) * (p1x - p2x) + (p1y - p2y) * (p1y - p2y);
    }

    public void compactTriangleStorage() {
        int newSize = Helper.compactArrayStorage(this.getStoredTriangleNum(), i -> this.isTriangleValid(i), (valid, invalid) -> this.moveTriangle(valid, invalid));
        this.trianglePointIndexes.removeElements(newSize * 3, this.trianglePointIndexes.size());
    }

    public void compactPointStorage() {
        for (int i2 = 0; i2 < this.getStoredPointNum(); ++i2) {
            if (this.isPointUsed(i2)) continue;
            double x = this.pointCoords.getDouble(i2 * 2);
            double y = this.pointCoords.getDouble(i2 * 2 + 1);
            long encodedGridIndex = Mesh2D.encodeToGrid(x, y);
            this.gridToPointIndex.remove(encodedGridIndex);
        }
        int newSize = Helper.compactArrayStorage(this.getStoredPointNum(), i -> this.isPointUsed(i), (valid, invalid) -> this.movePoint(valid, invalid));
        this.pointCoords.removeElements(newSize * 2, this.pointCoords.size());
        this.pointToTriangles.removeElements(newSize, this.pointToTriangles.size());
        Validate.isTrue((this.pointToTriangles.size() * 2 == this.pointCoords.size() ? 1 : 0) != 0);
    }

    public void compact() {
        this.compactTriangleStorage();
        this.compactPointStorage();
    }

    public void moveTriangle(int triangleIndex, int destTriangleIndex) {
        Validate.isTrue((!this.isTriangleValid(destTriangleIndex) ? 1 : 0) != 0);
        this.notifyTriangleRemovedForQuadTree(triangleIndex);
        int p0Index = this.trianglePointIndexes.getInt(triangleIndex * 3);
        int p1Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
        int p2Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
        ((IntArrayList)this.pointToTriangles.get(p0Index)).rem(triangleIndex);
        ((IntArrayList)this.pointToTriangles.get(p1Index)).rem(triangleIndex);
        ((IntArrayList)this.pointToTriangles.get(p2Index)).rem(triangleIndex);
        ((IntArrayList)this.pointToTriangles.get(p0Index)).add(destTriangleIndex);
        ((IntArrayList)this.pointToTriangles.get(p1Index)).add(destTriangleIndex);
        ((IntArrayList)this.pointToTriangles.get(p2Index)).add(destTriangleIndex);
        this.trianglePointIndexes.set(destTriangleIndex * 3, p0Index);
        this.trianglePointIndexes.set(destTriangleIndex * 3 + 1, p1Index);
        this.trianglePointIndexes.set(destTriangleIndex * 3 + 2, p2Index);
        this.trianglePointIndexes.set(triangleIndex * 3, -1);
        this.trianglePointIndexes.set(triangleIndex * 3 + 1, -1);
        this.trianglePointIndexes.set(triangleIndex * 3 + 2, -1);
        this.notifyTriangleAddedForQuadTree(destTriangleIndex);
    }

    public void movePoint(int pointIndex, int destPointIndex) {
        Validate.isTrue((!this.isPointUsed(destPointIndex) ? 1 : 0) != 0);
        double x = this.pointCoords.getDouble(pointIndex * 2);
        double y = this.pointCoords.getDouble(pointIndex * 2 + 1);
        long gridCoord = Mesh2D.encodeToGrid(x, y);
        int removedPointIndex = this.gridToPointIndex.remove(gridCoord);
        Validate.isTrue((removedPointIndex == pointIndex ? 1 : 0) != 0);
        this.gridToPointIndex.put(gridCoord, destPointIndex);
        this.pointCoords.set(destPointIndex * 2, x);
        this.pointCoords.set(destPointIndex * 2 + 1, y);
        IntArrayList triangles = (IntArrayList)this.pointToTriangles.get(pointIndex);
        this.pointToTriangles.set(destPointIndex, (Object)triangles);
        this.pointToTriangles.set(pointIndex, null);
        IntIterator iter = triangles.intIterator();
        while (iter.hasNext()) {
            int triangleIndex = iter.nextInt();
            int p0IndexInTriangle = this.trianglePointIndexes.getInt(triangleIndex * 3);
            int p1IndexInTriangle = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
            int p2IndexInTriangle = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
            if (p0IndexInTriangle == pointIndex) {
                this.trianglePointIndexes.set(triangleIndex * 3, destPointIndex);
                p0IndexInTriangle = destPointIndex;
            }
            if (p1IndexInTriangle == pointIndex) {
                this.trianglePointIndexes.set(triangleIndex * 3 + 1, destPointIndex);
                p1IndexInTriangle = destPointIndex;
            }
            if (p2IndexInTriangle != pointIndex) continue;
            this.trianglePointIndexes.set(triangleIndex * 3 + 2, destPointIndex);
            p2IndexInTriangle = destPointIndex;
        }
    }

    public void enableTriangleLookup() {
        if (this.triangleLookup != null) {
            return;
        }
        this.triangleLookup = new QuadTree<IntArrayList>(() -> new IntArrayList(1));
        for (int ti = 0; ti < this.getStoredTriangleNum(); ++ti) {
            if (!this.isTriangleValid(ti)) continue;
            this.getTriangleIdListInTriangleLookup(ti).add(ti);
        }
    }

    private IntArrayList getTriangleIdListInTriangleLookup(int ti) {
        Validate.notNull(this.triangleLookup);
        int p0Index = this.trianglePointIndexes.getInt(ti * 3);
        int p1Index = this.trianglePointIndexes.getInt(ti * 3 + 1);
        int p2Index = this.trianglePointIndexes.getInt(ti * 3 + 2);
        double p0x = this.pointCoords.getDouble(p0Index * 2);
        double p0y = this.pointCoords.getDouble(p0Index * 2 + 1);
        double p1x = this.pointCoords.getDouble(p1Index * 2);
        double p1y = this.pointCoords.getDouble(p1Index * 2 + 1);
        double p2x = this.pointCoords.getDouble(p2Index * 2);
        double p2y = this.pointCoords.getDouble(p2Index * 2 + 1);
        double minX = Math.min(p0x, Math.min(p1x, p2x));
        double minY = Math.min(p0y, Math.min(p1y, p2y));
        double maxX = Math.max(p0x, Math.max(p1x, p2x));
        double maxY = Math.max(p0y, Math.max(p1y, p2y));
        return this.triangleLookup.acquireElementForBoundingBox(minX, minY, maxX, maxY);
    }

    @Nullable
    private <U> U traverseNearbyTriangles(int triangleIndex, Int2ObjectFunction<U> func) {
        Validate.notNull(this.triangleLookup);
        int p0Index = this.trianglePointIndexes.getInt(triangleIndex * 3);
        int p1Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
        int p2Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
        double p0x = this.pointCoords.getDouble(p0Index * 2);
        double p0y = this.pointCoords.getDouble(p0Index * 2 + 1);
        double p1x = this.pointCoords.getDouble(p1Index * 2);
        double p1y = this.pointCoords.getDouble(p1Index * 2 + 1);
        double p2x = this.pointCoords.getDouble(p2Index * 2);
        double p2y = this.pointCoords.getDouble(p2Index * 2 + 1);
        double minX = Math.min(p0x, Math.min(p1x, p2x));
        double minY = Math.min(p0y, Math.min(p1y, p2y));
        double maxX = Math.max(p0x, Math.max(p1x, p2x));
        double maxY = Math.max(p0y, Math.max(p1y, p2y));
        return this.traverseTrianglesByBB(minX, minY, maxX, maxY, ti -> {
            if (ti != triangleIndex) {
                return func.apply(ti);
            }
            return null;
        });
    }

    public boolean boundingBoxIntersects(int triangleIndex, double minX, double minY, double maxX, double maxY) {
        int p0Index = this.trianglePointIndexes.getInt(triangleIndex * 3);
        int p1Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
        int p2Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
        double p0x = this.pointCoords.getDouble(p0Index * 2);
        double p0y = this.pointCoords.getDouble(p0Index * 2 + 1);
        double p1x = this.pointCoords.getDouble(p1Index * 2);
        double p1y = this.pointCoords.getDouble(p1Index * 2 + 1);
        double p2x = this.pointCoords.getDouble(p2Index * 2);
        double p2y = this.pointCoords.getDouble(p2Index * 2 + 1);
        double triMinX = Math.min(p0x, Math.min(p1x, p2x));
        double triMinY = Math.min(p0y, Math.min(p1y, p2y));
        double triMaxX = Math.max(p0x, Math.max(p1x, p2x));
        double triMaxY = Math.max(p0y, Math.max(p1y, p2y));
        return Range.rangeIntersects(minX, maxX, triMinX, triMaxX) && Range.rangeIntersects(minY, maxY, triMinY, triMaxY);
    }

    @Nullable
    private <U> U traverseTrianglesByBB(double minX, double minY, double maxX, double maxY, Int2ObjectFunction<U> func) {
        Validate.notNull(this.triangleLookup);
        return (U)this.triangleLookup.traverse(minX, minY, maxX, maxY, triangleIndexList -> {
            IntIterator iterator = triangleIndexList.intIterator();
            while (iterator.hasNext()) {
                Object result;
                int ti = iterator.nextInt();
                if (!this.boundingBoxIntersects(ti, minX, minY, maxX, maxY) || (result = func.apply(ti)) == null) continue;
                return result;
            }
            return null;
        });
    }

    public void notifyTriangleAddedForQuadTree(int triangleIndex) {
        if (this.triangleLookup == null) {
            return;
        }
        this.getTriangleIdListInTriangleLookup(triangleIndex).add(triangleIndex);
    }

    public void notifyTriangleRemovedForQuadTree(int triangleIndex) {
        if (this.triangleLookup == null) {
            return;
        }
        boolean removed = this.getTriangleIdListInTriangleLookup(triangleIndex).rem(triangleIndex);
        Validate.isTrue((boolean)removed, (String)"triangle %d not found in quad tree", (long)triangleIndex);
    }

    public void checkStorageIntegrity() {
        Validate.isTrue((this.pointCoords.size() % 2 == 0 ? 1 : 0) != 0);
        Validate.isTrue((this.pointCoords.size() / 2 == this.pointToTriangles.size() ? 1 : 0) != 0);
        Validate.isTrue((this.trianglePointIndexes.size() % 3 == 0 ? 1 : 0) != 0);
        for (int triangleIndex2 = 0; triangleIndex2 < this.getStoredTriangleNum(); ++triangleIndex2) {
            double p2y;
            double p2x;
            double p1y;
            if (!this.isTriangleValid(triangleIndex2)) continue;
            int p0Index = this.trianglePointIndexes.getInt(triangleIndex2 * 3);
            int p1Index = this.trianglePointIndexes.getInt(triangleIndex2 * 3 + 1);
            int p2Index = this.trianglePointIndexes.getInt(triangleIndex2 * 3 + 2);
            Validate.isTrue((boolean)((IntArrayList)this.pointToTriangles.get(p0Index)).contains(triangleIndex2));
            Validate.isTrue((boolean)((IntArrayList)this.pointToTriangles.get(p1Index)).contains(triangleIndex2));
            Validate.isTrue((boolean)((IntArrayList)this.pointToTriangles.get(p2Index)).contains(triangleIndex2));
            if (this.triangleLookup != null) {
                Validate.isTrue((boolean)this.getTriangleIdListInTriangleLookup(triangleIndex2).contains(triangleIndex2));
            }
            double p0x = this.pointCoords.getDouble(p0Index * 2);
            double p0y = this.pointCoords.getDouble(p0Index * 2 + 1);
            double p1x = this.pointCoords.getDouble(p1Index * 2);
            double w = Helper.crossProduct2D(p1x - p0x, (p1y = this.pointCoords.getDouble(p1Index * 2 + 1)) - p0y, (p2x = this.pointCoords.getDouble(p2Index * 2)) - p0x, (p2y = this.pointCoords.getDouble(p2Index * 2 + 1)) - p0y);
            Validate.isTrue((w > 0.0 ? 1 : 0) != 0, (String)"%f", (double)w);
        }
        for (IntArrayList triangleIds : this.pointToTriangles) {
            triangleIds.intStream().forEach(triangleIndex -> Validate.isTrue((boolean)this.isTriangleValid(triangleIndex)));
        }
        if (this.triangleLookup != null) {
            this.triangleLookup.traverse(-1.0, -1.0, 1.0, 1.0, triangleList -> {
                triangleList.intStream().forEach(triangleIndex -> Validate.isTrue((boolean)this.isTriangleValid(triangleIndex)));
                return null;
            });
        }
    }

    public boolean triangleIntersects(int ti1, int ti2) {
        int t1p0Index = this.trianglePointIndexes.getInt(ti1 * 3);
        int t1p1Index = this.trianglePointIndexes.getInt(ti1 * 3 + 1);
        int t1p2Index = this.trianglePointIndexes.getInt(ti1 * 3 + 2);
        double t1p0x = this.pointCoords.getDouble(t1p0Index * 2);
        double t1p0y = this.pointCoords.getDouble(t1p0Index * 2 + 1);
        double t1p1x = this.pointCoords.getDouble(t1p1Index * 2);
        double t1p1y = this.pointCoords.getDouble(t1p1Index * 2 + 1);
        double t1p2x = this.pointCoords.getDouble(t1p2Index * 2);
        double t1p2y = this.pointCoords.getDouble(t1p2Index * 2 + 1);
        return this.triangleIntersects(ti2, t1p0x, t1p0y, t1p1x, t1p1y, t1p2x, t1p2y);
    }

    public boolean triangleIntersects(int ti, double t1p0x, double t1p0y, double t1p1x, double t1p1y, double t1p2x, double t1p2y) {
        int t2p0Index = this.trianglePointIndexes.getInt(ti * 3);
        int t2p1Index = this.trianglePointIndexes.getInt(ti * 3 + 1);
        int t2p2Index = this.trianglePointIndexes.getInt(ti * 3 + 2);
        double t2p0x = this.pointCoords.getDouble(t2p0Index * 2);
        double t2p0y = this.pointCoords.getDouble(t2p0Index * 2 + 1);
        double t2p1x = this.pointCoords.getDouble(t2p1Index * 2);
        double t2p1y = this.pointCoords.getDouble(t2p1Index * 2 + 1);
        double t2p2x = this.pointCoords.getDouble(t2p2Index * 2);
        double t2p2y = this.pointCoords.getDouble(t2p2Index * 2 + 1);
        return GeometryUtil.triangleIntersects(t1p0x, t1p0y, t1p1x, t1p1y, t1p2x, t1p2y, t2p0x, t2p0y, t2p1x, t2p1y, t2p2x, t2p2y);
    }

    public void fixIntersectedTriangle() {
        int maxOperationNum = this.getStoredTriangleNum();
        int startTriangleIndex = 0;
        for (int operationNum = 0; operationNum < maxOperationNum && startTriangleIndex < this.getStoredTriangleNum(); ++operationNum) {
            startTriangleIndex = this.tryFixIntersectedTriangle(startTriangleIndex);
        }
    }

    private int tryFixIntersectedTriangle(int startTriangleIndex) {
        this.enableTriangleLookup();
        assert (this.triangleLookup != null);
        int storedTriangleNum = this.getStoredTriangleNum();
        for (int ti = startTriangleIndex; ti < storedTriangleNum; ++ti) {
            double p2y;
            double p2x;
            double p1y;
            double p1x;
            double p0y;
            if (!this.isTriangleValid(ti)) continue;
            int p0Index = this.trianglePointIndexes.getInt(ti * 3);
            int p1Index = this.trianglePointIndexes.getInt(ti * 3 + 1);
            int p2Index = this.trianglePointIndexes.getInt(ti * 3 + 2);
            int ti_ = ti;
            double p0x = this.pointCoords.getDouble(p0Index * 2);
            @Nullable Unit unit = (Unit)this.traverseNearbyTriangles(ti, arg_0 -> this.lambda$tryFixIntersectedTriangle$13(ti_, p0x, p0y = this.pointCoords.getDouble(p0Index * 2 + 1), p1x = this.pointCoords.getDouble(p1Index * 2), p1y = this.pointCoords.getDouble(p1Index * 2 + 1), p2x = this.pointCoords.getDouble(p2Index * 2), p2y = this.pointCoords.getDouble(p2Index * 2 + 1), arg_0));
            if (unit == null) continue;
            return ti;
        }
        return storedTriangleNum;
    }

    public int fixEdgeCrossingPoint() {
        this.enableTriangleLookup();
        int operationCount = 0;
        int i = 0;
        while (i < this.getStoredPointNum()) {
            double tiny;
            Unit result;
            if (!this.isPointUsed(i)) {
                ++i;
                continue;
            }
            double x = this.pointCoords.getDouble(i * 2);
            double y = this.pointCoords.getDouble(i * 2 + 1);
            int i_ = i;
            while ((result = (Unit)this.traverseTrianglesByBB(x - (tiny = 1.0E-5), y - tiny, x + tiny, y + tiny, triangleIndex -> {
                for (int v = 0; v < 3; ++v) {
                    if (this.getTrianglePointIndex(triangleIndex, v) != i_) continue;
                    return null;
                }
                for (int edgeIndex = 0; edgeIndex < 3; ++edgeIndex) {
                    int p0Index = this.getTrianglePointIndex(triangleIndex, edgeIndex);
                    int p1Index = this.getTrianglePointIndex(triangleIndex, (edgeIndex + 1) % 3);
                    int p2Index = this.getTrianglePointIndex(triangleIndex, (edgeIndex + 2) % 3);
                    if (!this.isOnLineSegment(p0Index, i_, p1Index)) continue;
                    this.removeTriangle(triangleIndex);
                    this.addTriangle(p0Index, i_, p2Index);
                    this.addTriangle(i_, p1Index, p2Index);
                    return Unit.INSTANCE;
                }
                return null;
            })) != null) {
                ++operationCount;
            }
            ++i;
        }
        return operationCount;
    }

    public boolean isOnLineSegment(int p1Index, int p2Index, int p3Index) {
        double p1x = this.pointCoords.getDouble(p1Index * 2);
        double p1y = this.pointCoords.getDouble(p1Index * 2 + 1);
        double p2x = this.pointCoords.getDouble(p2Index * 2);
        double p2y = this.pointCoords.getDouble(p2Index * 2 + 1);
        double p3x = this.pointCoords.getDouble(p3Index * 2);
        double p3y = this.pointCoords.getDouble(p3Index * 2 + 1);
        return GeometryUtil.isOppositeVec(p1x - p2x, p1y - p2y, p3x - p2x, p3y - p2y);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int triangleIndex = 0; triangleIndex < this.getStoredTriangleNum(); ++triangleIndex) {
            if (!this.isTriangleValid(triangleIndex)) continue;
            int p0Index = this.trianglePointIndexes.getInt(triangleIndex * 3);
            int p1Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 1);
            int p2Index = this.trianglePointIndexes.getInt(triangleIndex * 3 + 2);
            double p0x = this.pointCoords.getDouble(p0Index * 2);
            double p0y = this.pointCoords.getDouble(p0Index * 2 + 1);
            double p1x = this.pointCoords.getDouble(p1Index * 2);
            double p1y = this.pointCoords.getDouble(p1Index * 2 + 1);
            double p2x = this.pointCoords.getDouble(p2Index * 2);
            double p2y = this.pointCoords.getDouble(p2Index * 2 + 1);
            sb.append(String.format("%d: (%.3f, %.3f) (%.3f, %.3f) (%.3f, %.3f)\n", triangleIndex, p0x, p0y, p1x, p1y, p2x, p2y));
        }
        return sb.toString();
    }

    public JsonObject toJson() {
        int i;
        JsonObject json = new JsonObject();
        JsonArray points = new JsonArray();
        JsonArray triangles = new JsonArray();
        for (i = 0; i < this.getStoredPointNum(); ++i) {
            if (!this.isPointUsed(i)) {
                points.add((JsonElement)null);
                continue;
            }
            double x = this.pointCoords.getDouble(i * 2);
            double y = this.pointCoords.getDouble(i * 2 + 1);
            JsonArray point = new JsonArray();
            point.add((Number)x);
            point.add((Number)y);
            points.add((JsonElement)point);
        }
        for (i = 0; i < this.getStoredTriangleNum(); ++i) {
            if (!this.isTriangleValid(i)) continue;
            int p0Index = this.trianglePointIndexes.getInt(i * 3);
            int p1Index = this.trianglePointIndexes.getInt(i * 3 + 1);
            int p2Index = this.trianglePointIndexes.getInt(i * 3 + 2);
            JsonArray triangle = new JsonArray();
            triangle.add((Number)p0Index);
            triangle.add((Number)p1Index);
            triangle.add((Number)p2Index);
            triangles.add((JsonElement)triangle);
        }
        json.add("points", (JsonElement)points);
        json.add("triangles", (JsonElement)triangles);
        return json;
    }

    public Vec2d getBarycenter() {
        double sumX = 0.0;
        double sumY = 0.0;
        double sumWeight = 0.0;
        for (int i = 0; i < this.getStoredTriangleNum(); ++i) {
            if (!this.isTriangleValid(i)) continue;
            int p0Index = this.trianglePointIndexes.getInt(i * 3);
            int p1Index = this.trianglePointIndexes.getInt(i * 3 + 1);
            int p2Index = this.trianglePointIndexes.getInt(i * 3 + 2);
            double p0x = this.pointCoords.getDouble(p0Index * 2);
            double p0y = this.pointCoords.getDouble(p0Index * 2 + 1);
            double p1x = this.pointCoords.getDouble(p1Index * 2);
            double p1y = this.pointCoords.getDouble(p1Index * 2 + 1);
            double p2x = this.pointCoords.getDouble(p2Index * 2);
            double p2y = this.pointCoords.getDouble(p2Index * 2 + 1);
            double weight = Helper.crossProduct2D(p1x - p0x, p1y - p0y, p2x - p0x, p2y - p0y);
            sumX += (p0x + p1x + p2x) * weight;
            sumY += (p0y + p1y + p2y) * weight;
            sumWeight += weight;
        }
        if (sumWeight == 0.0) {
            return new Vec2d(0.0, 0.0);
        }
        return new Vec2d(sumX / sumWeight / 3.0, sumY / sumWeight / 3.0);
    }

    public Rect getBoundingBox() {
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        boolean firstPoint = true;
        for (int i = 0; i < this.getStoredPointNum(); ++i) {
            if (!this.isPointUsed(i)) continue;
            double x = this.pointCoords.getDouble(i * 2);
            double y = this.pointCoords.getDouble(i * 2 + 1);
            if (firstPoint) {
                minX = x;
                minY = y;
                maxX = x;
                maxY = y;
                firstPoint = false;
                continue;
            }
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
        }
        return new Rect(minX, minY, maxX, maxY);
    }

    public double getArea() {
        double sumAreaDoubled = 0.0;
        for (int i = 0; i < this.getStoredTriangleNum(); ++i) {
            if (!this.isTriangleValid(i)) continue;
            int p0Index = this.trianglePointIndexes.getInt(i * 3);
            int p1Index = this.trianglePointIndexes.getInt(i * 3 + 1);
            int p2Index = this.trianglePointIndexes.getInt(i * 3 + 2);
            double p0x = this.pointCoords.getDouble(p0Index * 2);
            double p0y = this.pointCoords.getDouble(p0Index * 2 + 1);
            double p1x = this.pointCoords.getDouble(p1Index * 2);
            double p1y = this.pointCoords.getDouble(p1Index * 2 + 1);
            double p2x = this.pointCoords.getDouble(p2Index * 2);
            double p2y = this.pointCoords.getDouble(p2Index * 2 + 1);
            double triangleAreaDoubled = Helper.crossProduct2D(p1x - p0x, p1y - p0y, p2x - p0x, p2y - p0y);
            sumAreaDoubled += triangleAreaDoubled;
        }
        return sumAreaDoubled / 2.0;
    }

    public void subtractPolygon(ObjectArrayList<Vec2d> polygonVertexes) {
        for (int i = 1; i < polygonVertexes.size() - 1; ++i) {
            int p0Index = 0;
            int p1Index = i;
            int p2Index = i + 1;
            this.subtractTriangleFromMesh(((Vec2d)polygonVertexes.get(p0Index)).x(), ((Vec2d)polygonVertexes.get(p0Index)).y(), ((Vec2d)polygonVertexes.get(p1Index)).x(), ((Vec2d)polygonVertexes.get(p1Index)).y(), ((Vec2d)polygonVertexes.get(p2Index)).x(), ((Vec2d)polygonVertexes.get(p2Index)).y());
        }
    }

    public void transformPoints(Function<Vec2d, Vec2d> transform) {
        this.gridToPointIndex.clear();
        for (int i = 0; i < this.getStoredPointNum(); ++i) {
            double x = this.pointCoords.getDouble(i * 2);
            double y = this.pointCoords.getDouble(i * 2 + 1);
            Vec2d transformed = transform.apply(new Vec2d(x, y));
            double transformedX = transformed.x();
            double transformedY = transformed.y();
            this.pointCoords.set(i * 2, transformedX);
            this.pointCoords.set(i * 2 + 1, transformedY);
            long newGridIndex = Mesh2D.encodeToGrid(transformedX, transformedY);
            this.gridToPointIndex.put(newGridIndex, i);
        }
    }

    public void debugVisualize() {
        JsonObject jsonObject = this.toJson();
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.setPrettyPrinting().create();
        File file = new File("./misc/mesh_to_visualize.json");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.append(gson.toJson((JsonElement)jsonObject));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Process e = Runtime.getRuntime().exec("python ./misc/visualize_mesh.py");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ Unit lambda$tryFixIntersectedTriangle$13(int ti_, double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, int anotherTi) {
        if (ti_ < anotherTi && this.triangleIntersects(ti_, anotherTi)) {
            this.subtractTriangleForOneTriangle(anotherTi, p0x, p0y, p1x, p1y, p2x, p2y);
            return Unit.INSTANCE;
        }
        return null;
    }

    public record Rect(double minX, double minY, double maxX, double maxY) {
    }
}

