/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntMatrix3;

public enum AARotation {
    SOUTH_ROT0(Direction.SOUTH, Direction.EAST),
    SOUTH_ROT90(Direction.SOUTH, Direction.UP),
    SOUTH_ROT180(Direction.SOUTH, Direction.WEST),
    SOUTH_ROT270(Direction.SOUTH, Direction.DOWN),
    NORTH_ROT0(Direction.NORTH, Direction.WEST),
    NORTH_ROT90(Direction.NORTH, Direction.UP),
    NORTH_ROT180(Direction.NORTH, Direction.EAST),
    NORTH_ROT270(Direction.NORTH, Direction.DOWN),
    EAST_ROT0(Direction.EAST, Direction.NORTH),
    EAST_ROT90(Direction.EAST, Direction.UP),
    EAST_ROT180(Direction.EAST, Direction.SOUTH),
    EAST_ROT270(Direction.EAST, Direction.DOWN),
    WEST_ROT0(Direction.WEST, Direction.SOUTH),
    WEST_ROT90(Direction.WEST, Direction.UP),
    WEST_ROT180(Direction.WEST, Direction.NORTH),
    WEST_ROT270(Direction.WEST, Direction.DOWN),
    UP_ROT0(Direction.UP, Direction.NORTH),
    UP_ROT90(Direction.UP, Direction.WEST),
    UP_ROT180(Direction.UP, Direction.SOUTH),
    UP_ROT270(Direction.UP, Direction.EAST),
    DOWN_ROT0(Direction.DOWN, Direction.SOUTH),
    DOWN_ROT90(Direction.DOWN, Direction.WEST),
    DOWN_ROT180(Direction.DOWN, Direction.NORTH),
    DOWN_ROT270(Direction.DOWN, Direction.EAST);

    public static final AARotation IDENTITY;
    public final Direction transformedX;
    public final Direction transformedY;
    public final Direction transformedZ;
    public final IntMatrix3 matrix;
    public final DQuaternion quaternion;
    private static final AARotation[][] multiplicationCache;
    private static final AARotation[] inverseCache;
    public static final ImmutableList<AARotation> rotationsSortedByAngle;

    private AARotation(Direction transformedZ, Direction transformedX) {
        this.transformedZ = transformedZ;
        this.transformedX = transformedX;
        this.transformedY = AARotation.dirCrossProduct(transformedZ, transformedX);
        this.matrix = new IntMatrix3(this.transformedX.m_122436_(), this.transformedY.m_122436_(), this.transformedZ.m_122436_());
        this.quaternion = this.matrix.toQuaternion();
    }

    public BlockPos transform(Vec3i vec) {
        return this.matrix.transform(vec);
    }

    public Direction transformDirection(Direction direction) {
        BlockPos transformedVec = this.transform(direction.m_122436_());
        return Direction.m_122378_((int)transformedVec.m_123341_(), (int)transformedVec.m_123342_(), (int)transformedVec.m_123343_());
    }

    @NotNull
    public static Direction dirCrossProduct(Direction a, Direction b) {
        Validate.isTrue((a.m_122434_() != b.m_122434_() ? 1 : 0) != 0);
        Direction result = Direction.m_122378_((int)(a.m_122430_() * b.m_122431_() - a.m_122431_() * b.m_122430_()), (int)(a.m_122431_() * b.m_122429_() - a.m_122429_() * b.m_122431_()), (int)(a.m_122429_() * b.m_122430_() - a.m_122430_() * b.m_122429_()));
        Validate.notNull((Object)result);
        return result;
    }

    public static Direction rotateDir90DegreesAlong(Direction direction, Direction axis) {
        if (direction.m_122434_() == axis.m_122434_()) {
            return direction;
        }
        return AARotation.dirCrossProduct(axis, direction);
    }

    public AARotation multiply(AARotation other) {
        return multiplicationCache[this.ordinal()][other.ordinal()];
    }

    private AARotation rawMultiply(AARotation other) {
        return AARotation.getAARotationFromZX(this.transformDirection(other.transformedZ), this.transformDirection(other.transformedX));
    }

    public static AARotation getAARotationFromZX(Direction transformedZ, Direction transformedX) {
        for (AARotation value : AARotation.values()) {
            if (value.transformedZ != transformedZ || value.transformedX != transformedX) continue;
            return value;
        }
        throw new IllegalArgumentException();
    }

    public static AARotation getAARotationFromYZ(Direction transformedY, Direction transformedZ) {
        for (AARotation value : AARotation.values()) {
            if (value.transformedY != transformedY || value.transformedZ != transformedZ) continue;
            return value;
        }
        throw new IllegalArgumentException();
    }

    public static AARotation getAARotationFromXY(Direction transformedX, Direction transformedY) {
        for (AARotation value : AARotation.values()) {
            if (value.transformedX != transformedX || value.transformedY != transformedY) continue;
            return value;
        }
        throw new IllegalArgumentException();
    }

    public AARotation getInverse() {
        return inverseCache[this.ordinal()];
    }

    public static AARotation get90DegreesRotationAlong(Direction direction) {
        Direction defaultX = Direction.EAST;
        Direction defaultY = Direction.UP;
        Direction newX = AARotation.rotateDir90DegreesAlong(defaultX, direction);
        Direction newY = AARotation.rotateDir90DegreesAlong(defaultY, direction);
        return AARotation.getAARotationFromXY(newX, newY);
    }

    static {
        IDENTITY = SOUTH_ROT0;
        multiplicationCache = new AARotation[24][24];
        for (AARotation a : AARotation.values()) {
            for (AARotation b2 : AARotation.values()) {
                AARotation.multiplicationCache[a.ordinal()][b2.ordinal()] = a.rawMultiply(b2);
            }
        }
        inverseCache = new AARotation[24];
        AARotation[] values = AARotation.values();
        for (int i = 0; i < values.length; ++i) {
            AARotation inverse;
            AARotation rot = values[i];
            AARotation.inverseCache[i] = inverse = Arrays.stream(AARotation.values()).filter(b -> rot.multiply((AARotation)((Object)b)) == IDENTITY).findFirst().orElseThrow();
        }
        AARotation[] array = Arrays.copyOf(AARotation.values(), 24);
        Arrays.sort(array, Comparator.comparingDouble(r -> r.quaternion.getRotatingAngleDegrees()));
        rotationsSortedByAngle = ImmutableList.copyOf((Object[])array);
    }
}

