/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldOptions;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.DimensionAPI;

public class ExtraDimensionStorage {
    public static void init() {
        DimensionAPI.serverDimensionsLoadEvent.register(ExtraDimensionStorage::loadExtraDimensions);
    }

    private static void loadExtraDimensions(WorldOptions worldOptions, RegistryAccess registryAccess) {
        MinecraftServer server = MiscHelper.getServer();
        if (server != null && server.m_130010_()) {
            RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
            Registry dimensionRegistry = registryAccess.m_175515_(Registries.f_256862_);
            Path extraStorageFolderPath = ExtraDimensionStorage.getExtraStorageFolderPath();
            File[] subFiles = extraStorageFolderPath.toFile().listFiles();
            if (subFiles != null) {
                for (File nameSpace : subFiles) {
                    if (!nameSpace.isDirectory()) continue;
                    for (File file : nameSpace.listFiles()) {
                        ResourceLocation id = new ResourceLocation(nameSpace.getName(), FilenameUtils.getBaseName((String)file.getName()));
                        ExtraDimensionStorage.readFile((RegistryOps<JsonElement>)ops, (Registry<LevelStem>)dimensionRegistry, file, id);
                    }
                }
            }
        }
    }

    private static void readFile(RegistryOps<JsonElement> ops, Registry<LevelStem> dimensionRegistry, File file, ResourceLocation id) {
        try {
            JsonElement jsonElement;
            try (FileReader fileReader = new FileReader(file);){
                jsonElement = JsonParser.parseReader((Reader)fileReader);
            }
            DataResult r = LevelStem.f_63970_.decode(ops, (Object)jsonElement);
            Either either = r.get();
            if (either.left().isPresent()) {
                LevelStem levelStem = (LevelStem)((Pair)either.left().get()).getFirst();
                DimensionAPI.addDimension(dimensionRegistry, id, (Holder<DimensionType>)levelStem.f_63975_(), levelStem.f_63976_());
            } else {
                Helper.err("Cannot deserialize extra dimension");
                Helper.err(either.right());
            }
        }
        catch (Throwable e) {
            Helper.err("Error loading extra dimension " + id);
            e.printStackTrace();
        }
    }

    private static Path getExtraStorageFolderPath() {
        Path savingDirectory = MiscHelper.getWorldSavingDirectory();
        return savingDirectory.resolve("q_dimension_configs");
    }

    private static File getExtraStorageFile(ResourceLocation location) {
        Path filePath = ExtraDimensionStorage.getExtraStorageFolderPath().resolve(location.m_135827_()).resolve(location.m_135815_() + ".json");
        return filePath.toFile();
    }

    public static void saveDimensionIntoExtraStorage(ResourceKey<Level> dimension) {
        MinecraftServer server = MiscHelper.getServer();
        RegistryAccess.Frozen registryAccess = server.m_206579_();
        ServerLevel world = server.m_129880_(dimension);
        Validate.notNull((Object)world);
        LevelStem levelStem = new LevelStem(world.m_204156_(), world.m_7726_().m_8481_());
        File file = ExtraDimensionStorage.getExtraStorageFile(dimension.m_135782_());
        try {
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            try (FileWriter fileWriter = new FileWriter(file);){
                RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
                DataResult r = LevelStem.f_63970_.encode((Object)levelStem, (DynamicOps)ops, (Object)new JsonObject());
                Either either = r.get();
                JsonElement result = either.left().orElse(null);
                if (result != null) {
                    Helper.gson.toJson(result, (Appendable)fileWriter);
                } else {
                    Helper.err("Cannot serialize extra dimension");
                    Helper.err(either.right().map(DataResult.PartialResult::toString).orElse(""));
                }
            }
        }
        catch (IOException e) {
            Helper.err("Cannot save extra dimension");
            e.printStackTrace();
        }
    }

    public static boolean removeDimensionFromExtraStorage(ResourceKey<Level> dimension) {
        File file = ExtraDimensionStorage.getExtraStorageFile(dimension.m_135782_());
        if (file.exists()) {
            file.delete();
            return true;
        }
        return false;
    }
}

