/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.dimension.DimId;

public class DimsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"dims").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"clone_dimension").then(Commands.m_82129_((String)"templateDimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"newDimensionID", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerLevel templateDimension = DimensionArgument.m_88808_((CommandContext)context, (String)"templateDimension");
            String newDimensionId = StringArgumentType.getString((CommandContext)context, (String)"newDimensionID");
            ResourceLocation newDimId = new ResourceLocation(newDimensionId);
            if (newDimId.m_135827_().equals("minecraft")) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Invalid namespace"));
                return 0;
            }
            DimsCommand.cloneDimension(templateDimension, newDimId);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Dynamically added dimension %s".formatted(newDimensionId)), true);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Warning: In the current version, dynamic dimension feature is still experimental and not yet stable."), false);
            return 0;
        }))));
        builder.then(Commands.m_82127_((String)"remove_dimension").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> {
            ServerLevel dimension = DimensionArgument.m_88808_((CommandContext)context, (String)"dimension");
            DimensionAPI.removeDimensionDynamically(dimension);
            DimensionAPI.deleteDimensionConfiguration((ResourceKey<Level>)dimension.m_46472_());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Dynamically removed dimension %s . Its world file is not yet deleted.".formatted(dimension.m_46472_().m_135782_())), true);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Warning: In the current version, dynamic dimension feature is still experimental and not yet stable."), false);
            return 0;
        })));
        dispatcher.register(builder);
    }

    private static void cloneDimension(ServerLevel templateDimension, ResourceLocation newDimId) {
        ChunkGenerator generator = templateDimension.m_7726_().m_8481_();
        DimensionAPI.addDimensionDynamically(newDimId, new LevelStem(templateDimension.m_204156_(), generator));
        DimensionAPI.saveDimensionConfiguration(DimId.idToKey(newDimId));
    }
}

