/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.google.common.collect.Streams;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class DimensionTypeSync {
    public static CompoundTag createTagFromServerWorldInfo() {
        RegistryAccess.Frozen registryManager = MiscHelper.getServer().m_206579_();
        Registry dimensionTypes = registryManager.m_175515_(Registries.f_256787_);
        return DimensionTypeSync.typeMapToTag(Streams.stream((Iterable)MiscHelper.getServer().m_129785_()).collect(Collectors.toMap(Level::m_46472_, w -> {
            DimensionType dimensionType = w.m_6042_();
            ResourceLocation id = dimensionTypes.m_7981_((Object)dimensionType);
            if (id == null) {
                Helper.err("Missing dim type id for " + w.m_46472_());
                Helper.err("Registered dimension types " + Helper.myToString(dimensionTypes.m_6566_().stream()));
                return BuiltinDimensionTypes.f_223538_;
            }
            return DimensionTypeSync.idToDimType(id);
        })));
    }

    public static ResourceKey<DimensionType> idToDimType(ResourceLocation id) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)id);
    }

    private static CompoundTag typeMapToTag(Map<ResourceKey<Level>, ResourceKey<DimensionType>> data) {
        CompoundTag tag = new CompoundTag();
        data.forEach((worldKey, typeKey) -> tag.m_128365_(worldKey.m_135782_().toString(), (Tag)StringTag.m_129297_((String)typeKey.m_135782_().toString())));
        return tag;
    }
}

