/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.api;

import com.mojang.serialization.Lifecycle;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldOptions;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.q_misc_util.dimension.DynamicDimensionsImpl;
import qouteall.q_misc_util.dimension.ExtraDimensionStorage;
import qouteall.q_misc_util.mixin.dimension.IELayeredRegistryAccess;
import qouteall.q_misc_util.mixin.dimension.IEMappedRegistry;

public class DimensionAPI {
    private static final Logger logger = LogManager.getLogger();
    public static final Event<ServerDimensionsLoadCallback> serverDimensionsLoadEvent = EventFactory.createArrayBacked(ServerDimensionsLoadCallback.class, listeners -> (worldOptions, registryManager) -> {
        Registry levelStems = registryManager.m_175515_(Registries.f_256862_);
        for (ServerDimensionsLoadCallback listener : listeners) {
            try {
                listener.run(worldOptions, registryManager);
            }
            catch (Exception e) {
                logger.error("Error registering custom dimension", (Throwable)e);
            }
        }
    });
    public static final Event<DynamicUpdateListener> serverDimensionDynamicUpdateEvent = EventFactory.createArrayBacked(DynamicUpdateListener.class, arr -> set -> {
        for (DynamicUpdateListener runnable : arr) {
            runnable.run(set);
        }
    });
    public static final Event<DynamicUpdateListener> clientDimensionUpdateEvent = EventFactory.createArrayBacked(DynamicUpdateListener.class, arr -> set -> {
        for (DynamicUpdateListener runnable : arr) {
            runnable.run(set);
        }
    });

    public static void addDimension(Registry<LevelStem> levelStemRegistry, ResourceLocation dimensionId, Holder<DimensionType> dimensionTypeHolder, ChunkGenerator chunkGenerator) {
        DimensionAPI.addDimension(levelStemRegistry, dimensionId, new LevelStem(dimensionTypeHolder, chunkGenerator));
    }

    private static void addDimension(Registry<LevelStem> levelStemRegistry, ResourceLocation dimensionId, LevelStem levelStem) {
        if (!(levelStemRegistry instanceof MappedRegistry)) {
            throw new RuntimeException("Failed to register the dimension");
        }
        MappedRegistry mapped = (MappedRegistry)levelStemRegistry;
        if (!mapped.m_6566_().contains(dimensionId)) {
            boolean oldIsFrozen = ((IEMappedRegistry)mapped).ip_getIsFrozen();
            ((IEMappedRegistry)mapped).ip_setIsFrozen(false);
            mapped.m_255290_(ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)dimensionId), (Object)levelStem, Lifecycle.stable());
            ((IEMappedRegistry)mapped).ip_setIsFrozen(oldIsFrozen);
        }
    }

    public static void addDimensionDynamically(ResourceLocation dimensionId, LevelStem levelStem) {
        DynamicDimensionsImpl.addDimensionDynamically(dimensionId, levelStem);
    }

    public static void removeDimensionDynamically(ServerLevel world) {
        DynamicDimensionsImpl.removeDimensionDynamically(world);
    }

    public static void saveDimensionConfiguration(ResourceKey<Level> dimension) {
        Validate.isTrue((!dimension.m_135782_().m_135827_().equals("minecraft") ? 1 : 0) != 0, (String)"cannot save a vanilla dimension", (Object[])new Object[0]);
        ExtraDimensionStorage.saveDimensionIntoExtraStorage(dimension);
    }

    public static boolean deleteDimensionConfiguration(ResourceKey<Level> dimension) {
        return ExtraDimensionStorage.removeDimensionFromExtraStorage(dimension);
    }

    public static MappedRegistry<LevelStem> collectCustomDimensions(RegistryAccess.Frozen worldGenLoadContext, WorldOptions options) {
        MappedRegistry subDimensionRegistry = new MappedRegistry(Registries.f_256862_, Lifecycle.stable());
        RegistryAccess.Frozen subRegistryAccess = new RegistryAccess.ImmutableRegistryAccess(List.of(subDimensionRegistry)).m_203557_();
        LayeredRegistryAccess<Integer> wrappedLayeredRegistryAccess = IELayeredRegistryAccess.ip_init(List.of(Integer.valueOf(1), Integer.valueOf(2)), List.of(worldGenLoadContext, subRegistryAccess));
        RegistryAccess.Frozen wrappedRegistryAccess = wrappedLayeredRegistryAccess.m_247579_();
        ((ServerDimensionsLoadCallback)serverDimensionsLoadEvent.invoker()).run(options, (RegistryAccess)wrappedRegistryAccess);
        return subDimensionRegistry;
    }

    public static interface ServerDimensionsLoadCallback {
        public void run(WorldOptions var1, RegistryAccess var2);
    }

    public static interface DynamicUpdateListener {
        public void run(Set<ResourceKey<Level>> var1);
    }
}

