/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.lang3.Validate;
import qouteall.q_misc_util.ImplRemoteProcedureCall;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimensionIdRecord;
import qouteall.q_misc_util.dimension.DimensionTypeSync;

public class MiscNetworking {
    public static final ResourceLocation id_stcRemote = new ResourceLocation("imm_ptl", "remote_stc");
    public static final ResourceLocation id_ctsRemote = new ResourceLocation("imm_ptl", "remote_cts");
    public static final ResourceLocation id_stcDimSync = new ResourceLocation("imm_ptl", "dim_sync");

    public static boolean handleMiscUtilPacketClientSide(ResourceLocation id, Supplier<FriendlyByteBuf> buf, ClientGamePacketListener networkHandler) {
        if (id.equals((Object)id_stcRemote)) {
            MiscHelper.executeOnRenderThread((Runnable)ImplRemoteProcedureCall.clientReadPacketAndGetHandler((FriendlyByteBuf)buf.get()));
            return true;
        }
        if (id.equals((Object)id_stcDimSync)) {
            MiscNetworking.processDimSync((FriendlyByteBuf)buf.get(), (ClientGamePacketListener)networkHandler);
            return true;
        }
        return false;
    }

    public static boolean handleMiscUtilPacketServerSide(ResourceLocation id, ServerPlayer player, FriendlyByteBuf buf) {
        if (id.equals((Object)id_ctsRemote)) {
            MiscHelper.executeOnServerThread(ImplRemoteProcedureCall.serverReadPacketAndGetHandler(player, buf));
            return true;
        }
        return false;
    }

    public static void init() {
    }

    public static Packet createDimSyncPacket() {
        Validate.notNull((Object)DimensionIdRecord.serverRecord);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag idMapTag = DimensionIdRecord.recordToTag(DimensionIdRecord.serverRecord, dim -> MiscHelper.getServer().m_129880_(dim) != null);
        buf.m_130079_(idMapTag);
        CompoundTag typeMapTag = DimensionTypeSync.createTagFromServerWorldInfo();
        buf.m_130079_(typeMapTag);
        return new ClientboundCustomPayloadPacket(id_stcDimSync, buf);
    }
}

