/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.MiscNetworking;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class ImplRemoteProcedureCall {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LimitedLogger LIMITED_LOGGER = new LimitedLogger(100);
    public static final Gson gson = MiscHelper.gson;
    private static final ConcurrentHashMap<String, Method> methodCache = new ConcurrentHashMap();
    private static final ImmutableMap<Class, BiConsumer<FriendlyByteBuf, Object>> serializerMap;
    private static final ImmutableMap<Type, Function<FriendlyByteBuf, Object>> deserializerMap;
    private static final JsonParser jsonParser;

    private static Object deserializeByCodec(FriendlyByteBuf buf, Codec codec) {
        String jsonString = buf.m_130277_();
        JsonElement jsonElement = jsonParser.parse(jsonString);
        return codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(false, e -> {
            throw new RuntimeException(e.toString());
        });
    }

    private static Object deserializeArgument(FriendlyByteBuf buf, Type type) {
        Function deserializer = (Function)deserializerMap.get((Object)type);
        if (deserializer == null) {
            String json = buf.m_130277_();
            return gson.fromJson(json, type);
        }
        return deserializer.apply(buf);
    }

    private static void serializeArgument(FriendlyByteBuf buf, Object object) {
        BiConsumer serializer = (BiConsumer)serializerMap.get(object.getClass());
        if (serializer == null) {
            serializer = serializerMap.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(object.getClass())).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        if (serializer == null) {
            String json = gson.toJson(object);
            buf.m_130070_(json);
            return;
        }
        serializer.accept(buf, object);
    }

    private static void serializeByCodec(FriendlyByteBuf buf, Codec codec, Object object) {
        JsonElement result = (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(false, e -> {
            throw new RuntimeException(e.toString());
        });
        String jsonString = gson.toJson(result);
        buf.m_130070_(jsonString);
    }

    public static ClientboundCustomPayloadPacket createS2CPacket(String methodPath, Object ... arguments) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        ImplRemoteProcedureCall.serializeStringWithArguments(methodPath, arguments, buf);
        return new ClientboundCustomPayloadPacket(MiscNetworking.id_stcRemote, buf);
    }

    public static Runnable serverReadPacketAndGetHandler(ServerPlayer player, FriendlyByteBuf buf) {
        String methodPath = null;
        try {
            methodPath = buf.m_130277_();
            Method method = ImplRemoteProcedureCall.getMethodByPath(methodPath);
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Object[] arguments = new Object[genericParameterTypes.length];
            arguments[0] = player;
            for (int i = 1; i < genericParameterTypes.length; ++i) {
                Object obj;
                Type parameterType = genericParameterTypes[i];
                arguments[i] = obj = ImplRemoteProcedureCall.deserializeArgument(buf, parameterType);
            }
            return () -> {
                try {
                    method.invoke(null, arguments);
                }
                catch (Exception e) {
                    LIMITED_LOGGER.invoke(() -> {
                        LOGGER.error("Processing remote procedure call {}", (Object)player, (Object)e);
                        ImplRemoteProcedureCall.serverTellFailure(player);
                    });
                }
            };
        }
        catch (Exception e) {
            String methodPath_ = methodPath;
            LIMITED_LOGGER.invoke(() -> {
                LOGGER.error("Failed to parse remote procedure call {}", (Object)methodPath_, (Object)e);
                ImplRemoteProcedureCall.serverTellFailure(player);
            });
            return () -> {};
        }
    }

    private static void serverTellFailure(ServerPlayer player) {
        player.m_213846_((Component)Component.m_237113_((String)"The server failed to process a packet sent from client.").m_130940_(ChatFormatting.RED));
    }

    private static void serializeStringWithArguments(String methodPath, Object[] arguments, FriendlyByteBuf buf) {
        buf.m_130070_(methodPath);
        for (Object argument : arguments) {
            ImplRemoteProcedureCall.serializeArgument(buf, argument);
        }
    }

    private static Method getMethodByPath(String methodPath) {
        Method result = methodCache.get(methodPath);
        if (result != null) {
            return result;
        }
        Method method = ImplRemoteProcedureCall.findMethodByPath(methodPath);
        Validate.notNull((Object)method);
        methodCache.put(methodPath, method);
        return method;
    }

    private static Method findMethodByPath(String methodPath) {
        Class<?> aClass;
        int lastDotIndex = methodPath.lastIndexOf(46);
        Validate.isTrue((lastDotIndex != -1 ? 1 : 0) != 0);
        String classPath = methodPath.substring(0, lastDotIndex);
        String methodName = methodPath.substring(lastDotIndex + 1);
        if (!classPath.contains("RemoteCallable")) {
            throw new RuntimeException("The class path must contain \"RemoteCallable\"");
        }
        try {
            aClass = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            int dotIndex = classPath.lastIndexOf(46);
            if (dotIndex != -1) {
                String newClassPath = classPath.substring(0, dotIndex) + "$" + classPath.substring(dotIndex + 1);
                try {
                    aClass = Class.forName(newClassPath);
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException("Cannot find class " + classPath, e);
                }
            }
            throw new RuntimeException("Cannot find class " + classPath, e);
        }
        Method method = Arrays.stream(aClass.getMethods()).filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find method " + methodPath + " . If it's a private method, make it public."));
        return method;
    }

    static {
        jsonParser = new JsonParser();
        serializerMap = ImmutableMap.builder().put(ResourceLocation.class, (buf, o) -> buf.m_130085_((ResourceLocation)o)).put(ResourceKey.class, (buf, o) -> buf.m_130085_(((ResourceKey)o).m_135782_())).put(BlockPos.class, (buf, o) -> buf.m_130064_((BlockPos)o)).put(Vec3.class, (buf, o) -> {
            Vec3 vec = (Vec3)o;
            buf.writeDouble(vec.f_82479_);
            buf.writeDouble(vec.f_82480_);
            buf.writeDouble(vec.f_82481_);
        }).put(UUID.class, (buf, o) -> buf.m_130077_((UUID)o)).put(Block.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, BuiltInRegistries.f_256975_.m_194605_(), o)).put(Item.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, BuiltInRegistries.f_257033_.m_194605_(), o)).put(BlockState.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, BlockState.f_61039_, o)).put(ItemStack.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec(buf, ItemStack.f_41582_, o)).put(CompoundTag.class, (buf, o) -> buf.m_130079_((CompoundTag)o)).put(Component.class, (buf, o) -> buf.m_130083_((Component)o)).put(DQuaternion.class, (buf, o) -> {
            DQuaternion dQuaternion = (DQuaternion)o;
            buf.writeDouble(dQuaternion.x);
            buf.writeDouble(dQuaternion.y);
            buf.writeDouble(dQuaternion.z);
            buf.writeDouble(dQuaternion.w);
        }).put(byte[].class, (buf, o) -> buf.m_130087_((byte[])o)).build();
        deserializerMap = ImmutableMap.builder().put(ResourceLocation.class, buf -> buf.m_130281_()).put((Object)new TypeToken<ResourceKey<Level>>(){}.getType(), buf -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buf.m_130281_())).put((Object)new TypeToken<ResourceKey<Biome>>(){}.getType(), buf -> ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)buf.m_130281_())).put(BlockPos.class, buf -> buf.m_130135_()).put(Vec3.class, buf -> new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble())).put(UUID.class, buf -> buf.m_130259_()).put(Block.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, BuiltInRegistries.f_256975_.m_194605_())).put(Item.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, BuiltInRegistries.f_257033_.m_194605_())).put(BlockState.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, BlockState.f_61039_)).put(ItemStack.class, buf -> ImplRemoteProcedureCall.deserializeByCodec(buf, ItemStack.f_41582_)).put(CompoundTag.class, buf -> buf.m_130260_()).put(Component.class, buf -> buf.m_130238_()).put(DQuaternion.class, buf -> new DQuaternion(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble())).put(byte[].class, buf -> buf.m_130052_()).build();
    }
}

