```json
{
  "title": "Vault",
  "icon": "minecraft:vault",
  "categories": [
    "minecraft:blocks",
    "minecraft:group.functional_blocks"
  ],
  "associated_items": [
    "minecraft:vault"
  ]
}
```

&spotlight(minecraft:vault)
A **vault** is a block found in [trial chambers](^minecraft:trial_chambers). It dispenses loot when unlocked using a [trial key](^minecraft:trial_key). Each vault can be looted by an unlimited number of players, but each player can unlock a specific vault only once.

;;;;;

&title(Obtaining)

Vaults cannot be obtained in [Survival](https://minecraft.wiki/w/Survival), even with [Silk Touch](https://minecraft.wiki/w/Silk_Touch), and can not be moved with a [piston](https://minecraft.wiki/w/Piston).

;;;;;

&title(Breaking)
A Vault can be broken but it does not drop itself as an item and takes a long time to break. It can only be obtained via the [Creative inventory](https://minecraft.wiki/w/Creative_inventory), the */[give](https://minecraft.wiki/w/Commands/give)* command, or by using [pick block](https://minecraft.wiki/w/Pick_block).

Due to their high blast resistance, vaults are immune to [explosions](https://minecraft.wiki/w/Explosion), but can still be destroyed by the [wither](https://minecraft.wiki/w/Wither)'s block-breaking attack and blue wither skulls.

;;;;;

&title(Natural generation)
In [trial chambers](^minecraft:trial_chambers), vaults can generate naturally in all rooms that also contain [trial spawners](^minecraft:trial_spawner), as well as the entrance room. They are found generated on small pedestals made of waxed [cut copper blocks](https://minecraft.wiki/w/Cut_copper_block) and [cut copper slabs](https://minecraft.wiki/w/Cut_copper_slab).

;;;;;

&title(Activation)
When a player is within 4.0 blocks of a vault, it becomes active and begins emitting flame [particles](https://minecraft.wiki/w/Particles) inside of it. If the player has not unlocked the vault before (i.e. if the player is not in its list of players), a stream of orange particles flows from the player to the vault's keyhole when the player is within 4.5 blocks. 

;;;;;

The vault becomes inactive if there are no players within 4.5 blocks who have not unlocked the vault. 

When active, a vault idly cycles between items once every second, visually displaying the current item inside the block. Each time the vault cycles to a new item, the item is randomly chosen from the loot table. Small orange particles also appear in front of the vault as if they were being sucked into the keyhole.

;;;;;

&title(Unlocking)
When a trial key is used (<keybind;key.use>) on a vault, it ejects items. Items are ejected one stack at a time with a burst of particles for each stack.
The visual display is not actually connected to what the player will get when opening the vault. Timing the loot is not possible.
When the vault is done ejecting items, it becomes inactive until another player approaches it.

;;;;;

Each vault can be unlocked only once per player. The vault is intended to reward each player for completing each trial chamber one time. This gives every player in a [world](https://minecraft.wiki/w/World) the opportunity to find their own loot without having to travel substantial distances to find undiscovered loot at a fresh structure.

;;;;;

&title(Unlocking)
Each vault keeps track of up to 128 unique players that have opened it. If the list of players is full and another opens the vault, the new player is added to the end of the list while the first known player is forgotten and becomes able to open the vault again. Because of this, any item dropped by vaults is functionally [renewable](https://minecraft.wiki/w/Renewable) with enough players.

;;;;;

![Vault](minecraft:textures/gui/image/vault.png,fit)
A vault in the process of ejecting loot.

;;;;;

&title(Loot)
The vault ejects 2 to 5 stacks of loot, which can sometimes include a few unstackable items.
