```json
{
  "title": "Copper Bulb",
  "icon_sprite": "minecraft:icon/all_copper_bulbs",
  "categories": [
    "minecraft:blocks",
    "minecraft:oxidizable_blocks",
    "minecraft:group.building_blocks"
  ],
  "associated_items": [
    "minecraft:copper_bulb",
    "minecraft:exposed_copper_bulb",
    "minecraft:weathered_copper_bulb",
    "minecraft:oxidized_copper_bulb",
    "minecraft:waxed_copper_bulb",
    "minecraft:waxed_exposed_copper_bulb",
    "minecraft:waxed_weathered_copper_bulb",
    "minecraft:waxed_oxidized_copper_bulb"
  ]
}
```

&spotlight(minecraft:copper_bulb)
A **copper bulb** is a light-emitting block. It toggles on or off when it receives a redstone pulse, and does not need continuous power to emit light. Its light level depends on its state of [oxidation](^minecraft:oxidation).

;;;;;

&title(Crafting)
<recipe;minecraft:copper_bulb>
<recipe;minecraft:waxed_copper_bulb_from_honeycomb>

;;;;;

&title(Natural Generation)
Lit, waxed copper bulbs in random states of [oxidation](^minecraft:oxidation) are generated in [trial chambers](^minecraft:trial_chambers).

;;;;;

![Scraping Copper Bulb](minecraft:textures/gui/image/scraping_copper_bulb.png,fit)

[Brandon Pearce](https://minecraft.wiki/w/Brandon_Pearce) scraping a copper bulb.

;;;;;

&title(Light)
Copper bulbs can be activated to emit light, with the light level emitted decreasing for each stage of [oxidation](^minecraft:oxidation). When the copper bulb receives a redstone pulse, it immediately toggles between its lit and unlit states.

;;;;;

&title(Redstone)
A comparator can read the state of a copper bulb, and it emits a signal strength of 15 if the bulb is lit, regardless of [oxidation](^minecraft:oxidation). If the bulb is unlit, the comparator does not emit any power, allowing this comparator and copper bulb combination to act as a compact T flip-flop.

;;;;;

&title(Red Signal)
While the copper bulb is receiving redstone power (either to toggle the bulb on or off) a red dot appears in the center of the block. An observer can detect this, and emits a signal when a copper bulb becomes powered or unpowered.