```json
{
  "title": "Suspicious Gravel",
  "icon": "minecraft:suspicious_gravel",
  "categories": [
    "minecraft:blocks",
    "minecraft:suspicious_blocks",
    "minecraft:group.functional_blocks"
  ],
  "associated_items": [
    "minecraft:suspicious_gravel"
  ]
}
```

&spotlight(minecraft:suspicious_gravel)
**Suspicious gravel** is a fragile gravity-affected [suspicious block](^minecraft:suspicious_blocks) found in various Overworld structures. They can be [brushed](^minecraft:brush) to extract structure-dependent loot, and are a source of [pottery sherds](^minecraft:tag.decorated_pot_sherds) alongside [suspicious sand](^suspicious_sand) and [trial chambers](^minecraft:trial_chambers).

;;;;;

![Gravel and Suspicious Gravel](minecraft:textures/gui/image/gravel_and_suspicious_gravel.png,fit)

Suspicious gravel next to normal gravel.

;;;;;

&title(Breaking)
Suspicious gravel is unobtainable by [mining](^minecraft:breaking), even using a tool enchanted with [Silk Touch](^minecraft:silk_touch). They are much softer than normal gravel, and can be instantly broken with merely an unenchanted diamond shovel.

;;;;;

&title(Falling)
They are affected by gravity, but they always break with no drops after falling. They break immediately if pushed by a piston or sticky piston, and cannot be pulled by sticky pistons or slime blocks. They also break immediately without dropping when affected by explosions.

;;;;;

&title(Natural Generation)
Suspicious gravel generates naturally in cold [ocean ruins](^minecraft:ocean_ruins). Additionally, some of the gravel within [trail ruins](^minecraft:trail_ruins) is replaced with suspicious gravel upon generation.

;;;;;

&title(Brushing)
When a [brush](^minecraft:brush) is used (<keybind;key.use>) on suspicious gravel, cracks start to appear on all sides of the block as the dusted block state of the block starts to increase. If the suspicious gravel being brushed is naturally generated, an item gradually emerges from the side where the player starts brushing.

;;;;;

&title(Interrupted Brushing)
After 96 (6+20+30+40 per stage) game ticks (4.8 seconds), the item is extracted, and the suspicious gravel is converted into gravel.


If the player stops brushing a suspicious gravel, the block remains in its half-excavated state for a few seconds, before gradually returning to its unexcavated state one stage at a time.

;;;;;

&title(Loot)
The item obtained and the loot table of suspicious gravel is dependent on which [structure](^minecraft:structures) it has generated in. Items can be extracted only from naturally generated suspicious gravel. When placed by the player, nothing is produced after brushing.