```json
{
  "title": "Camel",
  "icon_sprite": "minecraft:icon/camel",
  "categories": [
    "minecraft:mobs",
    "minecraft:passive_mobs",
    "minecraft:group.spawn_eggs"
  ],
  "associated_items": [
    "minecraft:camel_spawn_egg"
  ]
}
```

A **camel** is a [passive mob](^minecraft:passive_mobs) found in desert villages that can be saddled and ridden by up to two players at once. It is tall enough so its riders cannot be attacked from the ground by melee-attacking [hostile mobs](^minecraft:hostile_mobs) that don't attack camels.
<entity;minecraft:camel>

;;;;;

![Camel Village](minecraft:textures/gui/image/camel_village.png,fit)

A camel sitting in a desert village.

;;;;;

&title(Spawning)
One camel spawns in the center of each desert village during world generation. 

;;;;;

&title(Behavior)
A camel wanders aimlessly, avoiding hazards and obstacles, or it sits for two to seven seconds before standing up again. Camels immediately flee after being harmed, even when sitting. A sitting camel cannot be pushed by players or mobs.Sitting camels do not stand up if there are solid blocks above them, because doing so would inflict suffocation damage.

;;;;;

&title(Falling)
Camels can safely fall 6 blocks before they begin to accumulate fall damage, unlike most mobs, which can only safely fall 3 blocks. Camels also take half of the normal fall damage (rounded up) that most other mobs take. If an entity is riding a camel, they receive the same fall damage as the camel.

;;;;;

&title(Riding)
Camels are always [tamed](^minecraft:taming) and can be ridden by players. Up to two players can ride one camel. While riding, the player in the back seat cannot hurt the player driving or the camel itself.

;;;;;

&title(Saddle Slot)
Camels have one slot in their inventory, to hold a saddle. A saddle can be placed on a camel by holding it and then using (<keybind;key.use>) it on the camel, or by accessing its inventory. A camel's inventory can be accessed by mounting the camel and using inventory control (<keybind;key.inventory>).

;;;;;

&title(Mount Controls)
Once a camel is saddled, the player can control it with standard directional controls, jump (<keybind;key.jump>), and the mouse. The player dismounts using the dismount control (<keybind;key.sneak>).

;;;;;

&title(Eating)
Camels are healed by 2 health points each time they are fed a cactus. Camels also heal slowly on their own over time.


A camel follows the player who holds a cactus but stops following the player if it is separated from the player by at least 10 blocks. Sitting camels do not follow the player. 

;;;;;

&title(Breeding)
Adult camels enter love mode and [breed](^minecraft:breeding) to create baby camels after they are each given a cactus. The parents have a cooldown of five minutes before they can breed again. The growth time that baby camels take to be an adult camel can be reduced by giving the baby camel cactus.