```json
{
  "title": "Calibrated Sculk Sensor",
  "icon": "minecraft:calibrated_sculk_sensor",
  "categories": [
    "minecraft:blocks",
    "minecraft:group.redstone_blocks"
  ],
  "associated_items": [
    "minecraft:calibrated_sculk_sensor"
  ]
}
```

&spotlight(minecraft:calibrated_sculk_sensor)
A **calibrated sculk sensor** is a [craftable](^minecraft:crafting) variant of the [sculk sensor](^minecraft:sculk_sensor). Like its counterpart, it detects vibrations, but it has twice the range and can detect multiple vibrations in quicker succession.

;;;;;

&title(Crafting)
<recipe;calibrated_sculk_sensor>

;;;;;

&title(Usage)
The calibrated sculk sensor is different from the basic [sculk sensor](^minecraft:sculk_sensor) in multiple ways:

- can detect vibrations within a distance of 16 blocks, instead of 8.

- is activated for 10 game ticks after detecting a vibration instead of 30 game ticks

;;;;;

- can be filtered to react only to some sounds.

- emits redstone signals on three sides. The side with the amethyst stripe displayed does not emit a signal.

;;;;;

&title(Detection)
When a calibrated sculk sensor detects a vibration, it is activated for 10 game ticks, then has a 10 game tick cooldown before it can detect another vibration. This means that a calibrated sculk sensor can detect a vibration once per second, as opposed to once every two seconds for a regular sculk sensor.

;;;;;

&title(Filtering)
When a redstone signal powers a calibrated sculk sensor on its crystalized side, the sensor is filtered to respond only to vibrations that match the strength of that signal. Every vibration in the game has a frequency associated with it, and every vibration frequency directly matches a specific redstone signal strength. 

;;;;;

&title(Simultaneous Sounds)
Some events can create multiple vibrations simultaneously. For example, eating most food items creates vibrations of frequency 3 (item interaction) and 8 (entity eats). Using a redstone signal, the sensor can be filtered to detect either frequency. If no redstone signal is provided, the sensor detects the highest frequency.
