```json
{
  "title": "Mangrove Swamp",
  "icon_sprite": "minecraft:icon/mangrove_swamp",
  "categories": [
    "minecraft:tag.is_overworld",
    "minecraft:tag.has_structure.trial_chambers",
    "minecraft:tag.spawns_warm_variant_frogs",
    "minecraft:biomes"
  ]
}
```

The **mangrove swamp** is a wetland [biome](^minecraft:biomes) populated with [mud](^minecraft:mud) and [mangroves](^minecraft:mangrove_tree) where slimes, [frogs](^minecraft:frog), and [bogged](^minecraft:bogged) can spawn.

;;;;;

![Mangrove Swamp Inside](minecraft:textures/gui/image/mangrove_swamp_inside.png,fit)

The interior of a mangrove swamp.

;;;;;

&title(Appearance)
![Mangrove Swamp](minecraft:textures/gui/image/mangrove_swamp.png,fit)

;;;;;

&title(Description)
Mangrove swamp biomes are a variant of the swamp biome featuring dense [mangrove trees](^minecraft:mangrove_tree) which vary in height. The floor is mainly composed of mud blocks with occasional grass block or dirt disks. Seagrass litters the bottom of flooded areas, and lily pads dot the water's surface. 

;;;;;

&title(Features)
Mangrove swamp biomes, alongside deserts and regular swamps, can generate fossils underground. However, swamp huts do not generate here.

;;;;;

&title(Location)
Mangrove swamp biomes are usually found in flat terrain near sea level in regions with very high erosion values, and they also replace rivers in these areas. Mangrove swamps never directly border the ocean. However, their water bodies are often connected to the ocean. 

;;;;;

&title(Underwater)
Underwater fog is thick here, making visibility lower underwater.

;;;;;

&title(Slimes)
Slimes may spawn in swamps during the night, exclusively between Y=50 and Y=70, making swamps and mangrove swamps the only places where slimes can be found above ground. Their spawn rate is affected by the moon phase, spawning most often during full moon and not spawning at all during new moon.

;;;;;

![Mangrove Frog](minecraft:textures/gui/image/mangrove_frog.png,fit)

A warm [frog](^minecraft:frog) in a mangrove swamp.

;;;;;

&title(Bogged)
[Bogged](^minecraft:bogged) add an additional threat to the night, as their poison arrows can increase the danger of hostile mobs.

;;;;;

&title(Villagers)
Villagers that spawn in mangrove swamps get a unique swamp-themed look. While villagers have swamp-specific types, no village featuring exclusively these villagers can be generated. The only way for these villagers to spawn is either by a villager being bred in the swamp or mangrove swamp biomes, or for a zombie villager that spawned in a swamp to be cured.
