```json
{
  "title": "Allay",
  "icon_sprite": "minecraft:icon/allay",
  "categories": [
    "minecraft:mobs",
    "minecraft:passive_mobs",
    "minecraft:group.spawn_eggs"
  ],
  "associated_items": [
    "minecraft:allay_spawn_egg"
  ]
}
```

An **allay** (🔊 uh-ʟᴀʏ) is a flying [passive mob](^minecraft:passive_mobs) that collects and delivers items for any player that gives it something or any [note block](^minecraft:note_block) it hears recently playing. It looks similar to its hostile counterpart, the [vex](^minecraft:vex).

<entity;minecraft:allay>

;;;;;

&title(Spawning)
Allays spawn only during world generation, but they can also duplicate themselves.


Allays have a 50% chance of spawning in dark oak cages near [pillager outposts](^minecraft:pillager_outpost) in groups of 1-3. Allays also have a 50% chance to spawn inside jail cells within [woodland mansions](^minecraft:woodland_mansion) in groups of 1-3.


;;;;;

&title(Behavior)
The allay is small, peaceful and flies aimlessly until a player gives it an item with their <keybind;key.use> key. The allay starts following the player and seeks out dropped versions of the same item to deliver them to its player. The allay returns to wandering around if any player takes its item back by using (<keybind;key.use>) an empty hand on it.

;;;;;

The allay locks onto the player that last gave it an item. This allay follows the player from up to a 64-block cubic area away and seeks items up to a 32-block cubic area away from the player. After delivering items, the allay has a delay of three seconds until it can seek items again. An allay has a single inventory slot to hold a stack of items (usually 64 items) in addition to the item it got from the player.

;;;;;

&title(Note Block)
If the allay hears a [note block](^minecraft:note_block) play within 16 blocks of its location while delivering items, it instead delivers its items to the note block and then spend 30 seconds around that particular note block, seeking items around it and returning them to it instead of its player. The allay returns to targeting its player after 30 seconds. 

;;;;;

A vibration particle emanates from the note block and reaches the allay to indicate the allay has locked on to the note block. While an allay is focused on a note block, it responds only to sound from that note block, which resets the time until the allay loses interest. This in principle allows allays to focus on a single note block while other note blocks are playing in the vicinity, thus allowing many allays to work in parallel with different note blocks.

;;;;;

&title(Allay Duplication)
If an [amethyst shard](^minecraft:amethyst_shard) is used on an allay dancing next to a playing [jukebox](^minecraft:jukebox), the allay consumes the amethyst shard, emits heart particles, and duplicates into two allays. Both allays have a 5-minute cooldown before they can be duplicated again.

