/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.lootables.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.lootables.Lootables;
import me.fzzyhmstrs.lootables.api.IdKey;
import me.fzzyhmstrs.lootables.data.LootablesData;
import me.fzzyhmstrs.lootables.loot.LootableTable;
import me.fzzyhmstrs.lootables.loot.custom.CustomLootableEntry;
import me.fzzyhmstrs.lootables.loot.custom.CustomLootableEntryDisplay;
import me.fzzyhmstrs.lootables.network.ChoicesS2CCustomPayload;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\nH\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J;\u0010 \u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fJq\u0010'\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00170!2\u0014\b\u0002\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00170!2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010$\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b%\u0010&R \u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R \u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010*\u00a8\u0006,"}, d2={"Lme/fzzyhmstrs/lootables/impl/LootablesApiImpl;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "id", "Lme/fzzyhmstrs/lootables/loot/custom/CustomLootableEntry;", "getCustomEntry$lootables", "(Lnet/minecraft/class_2960;)Lme/fzzyhmstrs/lootables/loot/custom/CustomLootableEntry;", "getCustomEntry", "Lme/fzzyhmstrs/lootables/loot/custom/CustomLootableEntryDisplay;", "getCustomEntryDisplay$lootables", "(Lnet/minecraft/class_2960;)Lme/fzzyhmstrs/lootables/loot/custom/CustomLootableEntryDisplay;", "getCustomEntryDisplay", "entry", "entryDisplay", "", "registerCustomEntry$lootables", "(Lnet/minecraft/class_2960;Lme/fzzyhmstrs/lootables/loot/custom/CustomLootableEntry;Lme/fzzyhmstrs/lootables/loot/custom/CustomLootableEntryDisplay;)V", "registerCustomEntry", "tableId", "Lnet/minecraft/class_3222;", "playerEntity", "Lnet/minecraft/class_243;", "origin", "Lme/fzzyhmstrs/lootables/api/IdKey;", "key", "", "rolls", "", "supplyLootRandomly$lootables", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_3222;Lnet/minecraft/class_243;Lme/fzzyhmstrs/lootables/api/IdKey;I)Z", "supplyLootRandomly", "Ljava/util/function/BiConsumer;", "onSuccess", "onAbort", "choices", "supplyLootWithChoices$lootables", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_3222;Lnet/minecraft/class_243;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;Lme/fzzyhmstrs/lootables/api/IdKey;II)Z", "supplyLootWithChoices", "", "customEntries", "Ljava/util/Map;", "customEntryDisplays", "lootables"})
public final class LootablesApiImpl {
    @NotNull
    public static final LootablesApiImpl INSTANCE = new LootablesApiImpl();
    @NotNull
    private static final Map<class_2960, CustomLootableEntry> customEntries = new LinkedHashMap();
    @NotNull
    private static final Map<class_2960, CustomLootableEntryDisplay> customEntryDisplays = new LinkedHashMap();

    private LootablesApiImpl() {
    }

    public final boolean supplyLootWithChoices$lootables(@NotNull class_2960 tableId, @NotNull class_3222 playerEntity, @NotNull class_243 origin, @NotNull BiConsumer<class_3222, class_243> onSuccess, @NotNull BiConsumer<class_3222, class_243> onAbort, @Nullable IdKey key, int rolls, int choices) {
        List<class_2960> poolChoices;
        LootableTable table;
        Intrinsics.checkNotNullParameter((Object)tableId, (String)"tableId");
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onAbort, (String)"onAbort");
        if (choices > rolls) {
            throw new IllegalArgumentException("Number of choices (" + choices + ") greater than number of rolls (" + rolls + ")");
        }
        if (rolls < 1) {
            throw new IllegalArgumentException("Number of rolls can't be less than 1");
        }
        if (key != null) {
            UUID uUID = playerEntity.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
            if (!LootablesData.INSTANCE.keyAvailable(key, uUID)) {
                return false;
            }
        }
        if ((table = LootablesData.INSTANCE.getTable(tableId)) == null) {
            Lootables.INSTANCE.getLOGGER().error("Choices roll: Lootable table doesn't exist for ID " + tableId);
            return false;
        }
        String string = tableId.toString() + playerEntity.method_5667() + key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        UUID choiceKey = UUID.nameUUIDFromBytes(byArray);
        Intrinsics.checkNotNull((Object)choiceKey);
        List<class_2960> pendingPoolChoices = LootablesData.INSTANCE.getPendingPools(choiceKey);
        if (pendingPoolChoices != null) {
            v2 = pendingPoolChoices;
        } else {
            List<class_2960> storedPoolChoices = LootablesData.INSTANCE.getStoredPools(choiceKey);
            if (storedPoolChoices != null) {
                LootablesData.INSTANCE.setPending(choiceKey, playerEntity, origin, storedPoolChoices, key, onSuccess, onAbort);
                v2 = storedPoolChoices;
            } else {
                class_8567.class_8568 params = new class_8567.class_8568(playerEntity.method_51469()).method_51874(class_181.field_1226, (Object)playerEntity).method_51874(class_181.field_24424, (Object)origin);
                class_47 context = new class_47.class_48(params.method_51875(class_173.field_1179)).method_309(Optional.empty());
                Intrinsics.checkNotNull((Object)context);
                List<class_2960> newPoolChoices = table.supplyPoolsById(context, rolls);
                LootablesData.INSTANCE.setPending(choiceKey, playerEntity, origin, newPoolChoices, key, onSuccess, onAbort);
                v2 = poolChoices = newPoolChoices;
            }
        }
        if (key != null) {
            UUID uUID = playerEntity.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
            LootablesData.INSTANCE.applyKey(key, uUID);
        }
        ChoicesS2CCustomPayload payload = new ChoicesS2CCustomPayload(tableId, choiceKey, poolChoices, choices);
        ConfigApi.INSTANCE.network().send((class_8710)payload, (class_1657)playerEntity);
        return true;
    }

    public static /* synthetic */ boolean supplyLootWithChoices$lootables$default(LootablesApiImpl lootablesApiImpl, class_2960 class_29602, class_3222 class_32222, class_243 class_2432, BiConsumer biConsumer, BiConsumer biConsumer2, IdKey idKey, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            biConsumer = LootablesApiImpl::supplyLootWithChoices$lambda$0;
        }
        if ((n3 & 0x10) != 0) {
            biConsumer2 = LootablesApiImpl::supplyLootWithChoices$lambda$1;
        }
        if ((n3 & 0x40) != 0) {
            n = 3;
        }
        if ((n3 & 0x80) != 0) {
            n2 = 1;
        }
        return lootablesApiImpl.supplyLootWithChoices$lootables(class_29602, class_32222, class_2432, biConsumer, biConsumer2, idKey, n, n2);
    }

    public final boolean supplyLootRandomly$lootables(@NotNull class_2960 tableId, @NotNull class_3222 playerEntity, @NotNull class_243 origin, @Nullable IdKey key, int rolls) {
        LootableTable table;
        Intrinsics.checkNotNullParameter((Object)tableId, (String)"tableId");
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        if (rolls < 1) {
            throw new IllegalArgumentException("Number of rolls can't be less than 1");
        }
        if (key != null) {
            UUID uUID = playerEntity.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
            if (!LootablesData.INSTANCE.keyAvailable(key, uUID)) {
                return false;
            }
        }
        if ((table = LootablesData.INSTANCE.getTable(tableId)) == null) {
            Lootables.INSTANCE.getLOGGER().error("Random roll: Lootable table doesn't exist for ID " + tableId);
            return false;
        }
        class_8567.class_8568 params = new class_8567.class_8568(playerEntity.method_51469()).method_51874(class_181.field_1226, (Object)playerEntity).method_51874(class_181.field_24424, (Object)origin);
        class_47 context = new class_47.class_48(params.method_51875(class_173.field_1179)).method_309(Optional.empty());
        if (key != null) {
            UUID uUID = playerEntity.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
            LootablesData.INSTANCE.applyKey(key, uUID);
        }
        Intrinsics.checkNotNull((Object)context);
        table.applyPoolsRandomly(context, rolls);
        return true;
    }

    public static /* synthetic */ boolean supplyLootRandomly$lootables$default(LootablesApiImpl lootablesApiImpl, class_2960 class_29602, class_3222 class_32222, class_243 class_2432, IdKey idKey, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 1;
        }
        return lootablesApiImpl.supplyLootRandomly$lootables(class_29602, class_32222, class_2432, idKey, n);
    }

    public final void registerCustomEntry$lootables(@NotNull class_2960 id, @NotNull CustomLootableEntry entry, @NotNull CustomLootableEntryDisplay entryDisplay) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)entryDisplay, (String)"entryDisplay");
        if (customEntries.containsKey(id)) {
            throw new IllegalStateException("Custom lootable pool entry already registered at id: " + id);
        }
        customEntries.put(id, entry);
        customEntryDisplays.put(id, entryDisplay);
    }

    @Nullable
    public final CustomLootableEntry getCustomEntry$lootables(@NotNull class_2960 id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return customEntries.get(id);
    }

    @Nullable
    public final CustomLootableEntryDisplay getCustomEntryDisplay$lootables(@NotNull class_2960 id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return customEntryDisplays.get(id);
    }

    private static final void supplyLootWithChoices$lambda$0(class_3222 class_32222, class_243 class_2432) {
        Intrinsics.checkNotNullParameter((Object)class_32222, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)class_2432, (String)"<anonymous parameter 1>");
    }

    private static final void supplyLootWithChoices$lambda$1(class_3222 class_32222, class_243 class_2432) {
        Intrinsics.checkNotNullParameter((Object)class_32222, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)class_2432, (String)"<anonymous parameter 1>");
    }
}

