/*
 * Decompiled with CFR 0.152.
 */
package com.darcosse.scoremons.fabric.stats;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.pokemon.FossilRevivedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokedexDataChangedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.pokedex.CaughtCount;
import com.cobblemon.mod.common.api.pokedex.PokedexValueCalculator;
import com.darcosse.scoremons.fabric.config.ConfigManager;
import java.util.UUID;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class ScoreboardStats {
    public static final class_2960 POKEMON_CAUGHT = class_2960.method_12829((String)"pokemon_caught");
    public static final class_2960 SHINY_POKEMON_CAUGHT = class_2960.method_12829((String)"shiny_pokemon_caught");
    public static final class_2960 BATTLE_WON = class_2960.method_12829((String)"battle_won");
    public static final class_2960 POKEMON_REGISTERED = class_2960.method_12829((String)"pokemon_registered");

    public static void registerStats() {
        class_2378.method_10230((class_2378)class_7923.field_41183, (class_2960)POKEMON_CAUGHT, (Object)POKEMON_CAUGHT);
        class_3468.field_15419.method_14956((Object)POKEMON_CAUGHT);
        class_2378.method_10230((class_2378)class_7923.field_41183, (class_2960)SHINY_POKEMON_CAUGHT, (Object)SHINY_POKEMON_CAUGHT);
        class_3468.field_15419.method_14956((Object)SHINY_POKEMON_CAUGHT);
        class_2378.method_10230((class_2378)class_7923.field_41183, (class_2960)BATTLE_WON, (Object)BATTLE_WON);
        class_3468.field_15419.method_14956((Object)BATTLE_WON);
        class_2378.method_10230((class_2378)class_7923.field_41183, (class_2960)POKEMON_REGISTERED, (Object)POKEMON_REGISTERED);
        class_3468.field_15419.method_14956((Object)POKEMON_REGISTERED);
    }

    public static Function1<? super PokemonCapturedEvent, Unit> registerCapturedPokemon() {
        return event -> {
            class_3222 player = event.getPlayer();
            if (player instanceof class_3222) {
                class_3222 serverPlayer = player;
                player.method_7259(class_3468.field_15419.method_14956((Object)POKEMON_CAUGHT));
                if (ConfigManager.shouldBroadcastLegendaryCaught() && (event.getPokemon().isLegendary() || event.getPokemon().isMythical() || event.getPokemon().isUltraBeast())) {
                    for (class_1657 p : player.method_5682().method_3760().method_14571()) {
                        p.method_43496((class_2561)class_2561.method_43469((String)"scoremons.message.legendary_caught", (Object[])new Object[]{player.method_5477().getString(), class_2561.method_43471((String)("pokemon.species." + event.getPokemon().getSpecies().showdownId()))}).method_27696(class_2583.field_24360.method_36139(8336040)));
                    }
                }
            }
            return Unit.INSTANCE;
        };
    }

    public static Function1<? super PokemonCapturedEvent, Unit> registerCapturedShinyPokemon() {
        return event -> {
            class_3222 player = event.getPlayer();
            if (event.getPokemon().getShiny() && player instanceof class_3222) {
                class_3222 serverPlayer = player;
                player.method_7259(class_3468.field_15419.method_14956((Object)SHINY_POKEMON_CAUGHT));
                if (ConfigManager.shouldBroadcastShinyCaught()) {
                    for (class_1657 p : player.method_5682().method_3760().method_14571()) {
                        p.method_43496((class_2561)class_2561.method_43469((String)"scoremons.message.shiny_caught", (Object[])new Object[]{player.method_5477().getString(), class_2561.method_43471((String)("pokemon.species." + event.getPokemon().getSpecies().showdownId()))}).method_27696(class_2583.field_24360.method_36139(12885555)));
                    }
                }
            }
            return Unit.INSTANCE;
        };
    }

    public static Function1<? super BattleVictoryEvent, Unit> battleVictory() {
        return event -> {
            class_1657 player1;
            class_3222 player;
            if (event.getBattle().isPvP() && (player = (player1 = (class_1657)event.getBattle().getPlayers().getFirst()).method_5682().method_3760().method_14602(((BattleActor)event.getWinners().getFirst()).getUuid())) instanceof class_3222) {
                class_3222 serverPlayer = player;
                class_3222 p = serverPlayer.field_13995.method_3760().method_14602(((BattleActor)event.getWinners().getFirst()).getUuid());
                p.method_7259(class_3468.field_15419.method_14956((Object)BATTLE_WON));
            }
            return Unit.INSTANCE;
        };
    }

    public static Function1<? super FossilRevivedEvent, Unit> revivedFossil() {
        return event -> {
            class_3222 player = event.getPlayer();
            if (event.getPokemon().getShiny() && player instanceof class_3222) {
                class_3222 serverPlayer = player;
                player.method_7259(class_3468.field_15419.method_14956((Object)SHINY_POKEMON_CAUGHT));
                player.method_7259(class_3468.field_15419.method_14956((Object)POKEMON_CAUGHT));
                if (ConfigManager.shouldBroadcastShinyFossilRevived()) {
                    for (class_1657 p : player.method_5682().method_3760().method_14571()) {
                        p.method_43496((class_2561)class_2561.method_43469((String)"scoremons.message.shiny_fossil_revived", (Object[])new Object[]{player.method_5477().getString(), class_2561.method_43471((String)("pokemon.species." + event.getPokemon().getSpecies().getName()))}).method_27696(class_2583.field_24360.method_36139(12885555)));
                    }
                }
            }
            return Unit.INSTANCE;
        };
    }

    public static Function1<? super PokedexDataChangedEvent, Unit> registerCaughtCount() {
        return event -> {
            MinecraftServer server;
            UUID playerUUID = event.getPlayerUUID();
            MinecraftServer minecraftServer = server = FabricLoader.getInstance().getGameInstance() instanceof MinecraftServer ? (MinecraftServer)FabricLoader.getInstance().getGameInstance() : null;
            if (server != null) {
                class_3222 player = server.method_3760().method_14602(playerUUID);
                if (player != null) {
                    ScoreboardStats.updateCaughtCount(player);
                }
            } else {
                ScoreboardStats.updateCaughtCountLocal(playerUUID);
            }
            return Unit.INSTANCE;
        };
    }

    private static void updateCaughtCount(class_3222 player) {
        int count = (Integer)Cobblemon.playerDataManager.getPokedexData(player.method_5667()).getDexCalculatedValue(class_2960.method_12829((String)"cobblemon:national"), (PokedexValueCalculator)CaughtCount.INSTANCE);
        int currentCount = player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)POKEMON_REGISTERED));
        int toUpdate = count - currentCount;
        for (int i = 0; i < toUpdate; ++i) {
            player.method_7259(class_3468.field_15419.method_14956((Object)POKEMON_REGISTERED));
        }
    }

    private static void updateCaughtCountLocal(UUID playerUUID) {
        int count = (Integer)Cobblemon.playerDataManager.getPokedexData(playerUUID).getDexCalculatedValue(class_2960.method_12829((String)"cobblemon:national"), (PokedexValueCalculator)CaughtCount.INSTANCE);
    }
}

