/*
 * Decompiled with CFR 0.152.
 */
package com.darcosse.scoremons.fabric.config;

import com.darcosse.scoremons.fabric.config.ScoremonsConfig;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final String CONFIG_FILE = "scoremons_config.json";
    private static ScoremonsConfig config;
    private static final Gson GSON;

    public static void loadConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), CONFIG_FILE);
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (ScoremonsConfig)GSON.fromJson((Reader)reader, ScoremonsConfig.class);
            }
            catch (IOException e) {
                config = new ScoremonsConfig();
                ConfigManager.saveConfig();
            }
        } else {
            config = new ScoremonsConfig();
            ConfigManager.saveConfig();
        }
    }

    public static void saveConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), CONFIG_FILE);
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ScoremonsConfig getConfig() {
        if (config == null) {
            ConfigManager.loadConfig();
        }
        return config;
    }

    public static void reloadConfig() {
        config = null;
        ConfigManager.loadConfig();
    }

    public static boolean shouldBroadcastShinyCaught() {
        return ConfigManager.getConfig().broadcastShinyCaught;
    }

    public static boolean shouldBroadcastLegendaryCaught() {
        return ConfigManager.getConfig().broadcastLegendaryCaught;
    }

    public static boolean shouldBroadcastShinyFossilRevived() {
        return ConfigManager.getConfig().broadcastShinyFossilRevived;
    }

    static {
        GSON = new Gson();
    }
}

