/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.item;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageBoat;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class StorageBoatItem
extends MovingStorageItem {
    private static final Predicate<class_1297> ENTITY_PREDICATE = class_1301.field_6155.and(class_1297::method_5863);
    private static final String RAFT_DESCRIPTION_ID = "item.sophisticatedstorageinmotion.storage_raft";
    public static final Map<class_1690.class_1692, Supplier<class_1792>> SUPPORTED_BOAT_TYPES = Map.of(class_1690.class_1692.field_7725, () -> class_1802.field_8094, class_1690.class_1692.field_40161, () -> class_1802.field_40224, class_1690.class_1692.field_7729, () -> class_1802.field_8442, class_1690.class_1692.field_42681, () -> class_1802.field_42706, class_1690.class_1692.field_7723, () -> class_1802.field_8138, class_1690.class_1692.field_7730, () -> class_1802.field_8730, class_1690.class_1692.field_37506, () -> class_1802.field_37531, class_1690.class_1692.field_7727, () -> class_1802.field_8533, class_1690.class_1692.field_7728, () -> class_1802.field_8486);
    public static final class_2347 DISPENSE_ITEM_BEHAVIOR = new class_2347(){
        private final class_2347 defaultDispenseItemBehavior = new class_2347();

        public class_1799 method_10135(class_2342 source, class_1799 stack) {
            double yOffset;
            class_2350 direction = (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918);
            class_3218 level = source.comp_1967();
            double halfWidth = 0.5625 + (double)class_1299.field_6121.method_17685() / 2.0;
            class_243 center = source.method_53906();
            double x = center.method_10216() + (double)direction.method_10148() * halfWidth;
            double y = center.method_10214() + (double)direction.method_10164() * 1.125;
            double z = center.method_10215() + (double)direction.method_10165() * halfWidth;
            class_2338 blockpos = source.comp_1968().method_10093(direction);
            class_1690 boat = StorageBoatItem.createBoat((class_1937)level, null, stack, x, y, z);
            boat.method_36456(direction.method_10144());
            if (level.method_8316(blockpos).method_15767(class_3486.field_15517)) {
                yOffset = 1.0;
            } else {
                if (!level.method_8320(blockpos).method_26215() || !level.method_8316(blockpos.method_10074()).method_15767(class_3486.field_15517)) {
                    return this.defaultDispenseItemBehavior.dispense(source, stack);
                }
                yOffset = 0.0;
            }
            boat.method_5814(x, y + yOffset, z);
            level.method_8649((class_1297)boat);
            stack.method_7934(1);
            return stack;
        }

        protected void method_10136(class_2342 source) {
            source.comp_1967().method_20290(1000, source.comp_1968(), 0);
        }
    };

    public StorageBoatItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    @Override
    public class_1799 getUncraftRemainingItem(class_1799 input) {
        return new class_1799((class_1935)SUPPORTED_BOAT_TYPES.getOrDefault(StorageBoatItem.getBoatType(input), () -> class_1802.field_8533).get());
    }

    @Override
    public List<class_1799> getBaseMovingStorageItems() {
        return SUPPORTED_BOAT_TYPES.keySet().stream().map(type -> StorageBoatItem.setBoatType(new class_1799((class_1935)this), type)).toList();
    }

    public static class_1690.class_1692 getBoatType(class_1799 boatStack) {
        return (class_1690.class_1692)boatStack.method_57825(ModDataComponents.BOAT_TYPE.get(), (Object)class_1690.class_1692.field_7727);
    }

    public static class_1799 setBoatType(class_1799 boatStack, class_1690.class_1692 type) {
        boatStack.method_57379(ModDataComponents.BOAT_TYPE.get(), (Object)type);
        return boatStack;
    }

    @Override
    public class_2561 method_7864(class_1799 stack) {
        SimpleItemContent storageItemContent = (SimpleItemContent)stack.sophisticatedCore_get(ModDataComponents.STORAGE_ITEM);
        class_1690.class_1692 boatType = StorageBoatItem.getBoatType(stack);
        String descriptionId = boatType == class_1690.class_1692.field_40161 ? RAFT_DESCRIPTION_ID : this.method_7876();
        return class_2561.method_43469((String)descriptionId, (Object[])new Object[]{this.getWoodName(boatType), storageItemContent != null ? storageItemContent.copy().method_7964() : ""});
    }

    private class_2561 getWoodName(class_1690.class_1692 type) {
        return class_2561.method_43471((String)("wood_name.sophisticatedstorage." + type.name().toLowerCase(Locale.ROOT)));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        class_3965 hitresult = StorageBoatItem.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1347);
        if (hitresult.method_17783() == class_239.class_240.field_1333) {
            return class_1271.method_22430((Object)itemstack);
        }
        class_243 playerViewVector = player.method_5828(1.0f);
        List list = level.method_8333((class_1297)player, player.method_5829().method_18804(playerViewVector.method_1021(5.0)).method_1014(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            class_243 eyePosition = player.method_33571();
            for (class_1297 entity : list) {
                class_238 aabb = entity.method_5829().method_1014((double)entity.method_5871());
                if (!aabb.method_1006(eyePosition)) continue;
                return class_1271.method_22430((Object)itemstack);
            }
        }
        if (hitresult.method_17783() == class_239.class_240.field_1332) {
            class_243 location = hitresult.method_17784();
            class_1690 boat = StorageBoatItem.createBoat(level, player, itemstack, location.field_1352, location.field_1351, location.field_1350);
            if (!level.method_8587((class_1297)boat, boat.method_5829())) {
                return class_1271.method_22431((Object)itemstack);
            }
            if (!level.field_9236) {
                level.method_8649((class_1297)boat);
                level.method_43275((class_1297)player, (class_6880)class_5712.field_28738, hitresult.method_17784());
                itemstack.method_57008(1, (class_1309)player);
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_29237((Object)itemstack, (boolean)level.method_8608());
        }
        return class_1271.method_22430((Object)itemstack);
    }

    private static class_1690 createBoat(class_1937 level, @Nullable class_1657 player, class_1799 stack, double x, double y, double z) {
        StorageBoat boat = new StorageBoat(level, x, y, z);
        EntityStorageHolder<?> storageHolder = boat.getStorageHolder();
        storageHolder.setStorageItemFrom(stack, true);
        storageHolder.onPlace();
        boat.method_47884(StorageBoatItem.getBoatType(stack));
        if (player != null) {
            boat.method_36456(player.method_36454());
        }
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            class_1299.method_48009((class_3218)serverLevel, (class_1799)stack, (class_1657)player).accept(boat);
        }
        return boat;
    }
}

