/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.item;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4719;
import net.minecraft.class_481;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_7225;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.extensions.component.SophisticatedDataComponentHolder;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.DecorationTableBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItemClient;

public abstract class MovingStorageItem
extends ItemBase
implements IStashStorageItem {
    public MovingStorageItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static void setStorageItem(class_1799 movingStorageItem, class_1799 storageItem) {
        movingStorageItem.sophisticatedCore_set(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.copyOf((class_1799)storageItem));
    }

    public static Optional<class_1792> getStorageItemType(class_1799 stack) {
        SimpleItemContent storageItemContents = (SimpleItemContent)stack.sophisticatedCore_get(ModDataComponents.STORAGE_ITEM);
        return storageItemContents == null ? Optional.empty() : Optional.of(storageItemContents.getItem());
    }

    public static Optional<class_4719> getStorageItemWoodType(class_1799 stack) {
        SimpleItemContent storageItemContents = (SimpleItemContent)stack.sophisticatedCore_get(ModDataComponents.STORAGE_ITEM);
        return storageItemContents == null ? Optional.empty() : WoodStorageBlockItem.getWoodType((SophisticatedDataComponentHolder)storageItemContents);
    }

    public static Optional<Integer> getStorageItemMainColor(class_1799 stack) {
        SimpleItemContent storageItemContents = (SimpleItemContent)stack.sophisticatedCore_get(ModDataComponents.STORAGE_ITEM);
        return storageItemContents == null ? Optional.empty() : StorageBlockItem.getMainColorFromComponentHolder((SophisticatedDataComponentHolder)storageItemContents);
    }

    public static Optional<Integer> getStorageItemAccentColor(class_1799 stack) {
        SimpleItemContent storageItemContents = (SimpleItemContent)stack.sophisticatedCore_get(ModDataComponents.STORAGE_ITEM);
        return storageItemContents == null ? Optional.empty() : StorageBlockItem.getAccentColorFromComponentHolder((SophisticatedDataComponentHolder)storageItemContents);
    }

    public static boolean isStorageItemFlatTopBarrel(class_1799 stack) {
        SimpleItemContent storageItemContents = (SimpleItemContent)stack.sophisticatedCore_get(ModDataComponents.STORAGE_ITEM);
        return storageItemContents != null && BarrelBlockItem.isFlatTop((SophisticatedDataComponentHolder)storageItemContents);
    }

    public static class_1799 getStorageItem(class_1799 stack) {
        return ((SimpleItemContent)stack.sophisticatedCore_getOrDefault(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.EMPTY)).copy();
    }

    public abstract class_1799 getUncraftRemainingItem(class_1799 var1);

    public void addCreativeTabItems(Consumer<class_1799> itemConsumer) {
        if (Config.COMMON.enabledItems.isItemEnabled((class_1792)this)) {
            List<class_1799> movingStorages = this.getBaseMovingStorageItems();
            movingStorages.forEach(movingStorage -> {
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.method_7972(), WoodStorageBlockItem.setWoodType((class_1799)new class_1799((class_1935)ModBlocks.BARREL_ITEM.get()), (class_4719)class_4719.field_21677)));
                class_1799 limitedIStack = new class_1799((class_1935)ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get());
                class_1792 patt0$temp = limitedIStack.method_7909();
                if (patt0$temp instanceof ITintableBlockItem) {
                    ITintableBlockItem tintableBlockItem = (ITintableBlockItem)patt0$temp;
                    tintableBlockItem.setMainColor(limitedIStack, class_1767.field_7947.method_7787());
                    tintableBlockItem.setAccentColor(limitedIStack, class_1767.field_7961.method_7787());
                }
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.method_7972(), limitedIStack));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.method_7972(), WoodStorageBlockItem.setWoodType((class_1799)new class_1799((class_1935)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (class_4719)class_4719.field_21678)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.method_7972(), WoodStorageBlockItem.setWoodType((class_1799)new class_1799((class_1935)ModBlocks.LIMITED_IRON_BARREL_3.get()), (class_4719)class_4719.field_21679)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.method_7972(), WoodStorageBlockItem.setWoodType((class_1799)new class_1799((class_1935)ModBlocks.LIMITED_DIAMOND_BARREL_4.get()), (class_4719)class_4719.field_22183)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.method_7972(), WoodStorageBlockItem.setWoodType((class_1799)new class_1799((class_1935)ModBlocks.NETHERITE_CHEST_ITEM.get()), (class_4719)class_4719.field_40350)));
                itemConsumer.accept(MovingStorageItem.createWithStorage(movingStorage.method_7972(), new class_1799((class_1935)ModBlocks.IRON_SHULKER_BOX_ITEM.get())));
            });
        }
    }

    public List<class_1799> getBaseMovingStorageItems() {
        return List.of(new class_1799((class_1935)this));
    }

    public static class_1799 createWithStorage(class_1799 movingStorage, class_1799 storageStack) {
        MovingStorageItem.setStorageItem(movingStorage, storageStack);
        return movingStorage;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 tooltipFlag) {
        class_7225.class_7874 registries;
        super.method_7851(stack, context, tooltip, tooltipFlag);
        if (tooltipFlag.method_8035() && (registries = context.method_59527()) != null) {
            MovingStorageItem.getMovingStorageWrapper(stack).getContentsUuid().ifPresent(uuid -> tooltip.add((class_2561)class_2561.method_43470((String)("UUID: " + String.valueOf(uuid))).method_27692(class_124.field_1063)));
        }
        if (!class_437.method_25442() && MovingStorageItem.getMovingStorageWrapper(stack).getContentsUuid().isPresent()) {
            tooltip.add((class_2561)class_2561.method_43469((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{class_2561.method_43471((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).method_27692(class_124.field_1075)}).method_27692(class_124.field_1080));
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        SimpleItemContent storageItemContent = (SimpleItemContent)stack.sophisticatedCore_get(ModDataComponents.STORAGE_ITEM);
        return storageItemContent != null ? class_2561.method_43469((String)this.method_7876(), (Object[])new Object[]{storageItemContent.copy().method_7964()}) : super.method_7864(stack);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return Optional.ofNullable(MovingStorageItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    public Optional<class_5632> getInventoryTooltip(class_1799 stack) {
        return Optional.of(new MovingStorageContentsTooltip(stack));
    }

    public IStashStorageItem.StashResult getItemStashable(class_7225.class_7874 registries, class_1799 storageStack, class_1799 stack) {
        if (MovingStorageItem.getStorageItemType(storageStack).map(item -> item instanceof ShulkerBoxItem).orElse(false).booleanValue()) {
            MovingStorageWrapper wrapper = MovingStorageItem.getMovingStorageWrapper(storageStack);
            if (wrapper.getInventoryForUpgradeProcessing().insertItem(stack, true).method_7947() == stack.method_7947()) {
                return IStashStorageItem.StashResult.NO_SPACE;
            }
            if (wrapper.getInventoryHandler().getSlotTracker().getItems().contains(stack.method_7909()) || ((MemorySettingsCategory)wrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).matchesFilter(stack)) {
                return IStashStorageItem.StashResult.MATCH_AND_SPACE;
            }
            return IStashStorageItem.StashResult.SPACE;
        }
        return IStashStorageItem.StashResult.NO_SPACE;
    }

    public static MovingStorageWrapper getMovingStorageWrapper(class_1799 movingStorageStack) {
        class_1799 storageItem = MovingStorageItem.getStorageItem(movingStorageStack);
        MovingStorageWrapper wrapper = MovingStorageWrapper.fromStack(storageItem, () -> {}, () -> movingStorageStack.sophisticatedCore_set(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.copyOf((class_1799)storageItem)));
        return wrapper;
    }

    public class_1799 stash(class_1799 movingStorageStack, class_1799 stack, boolean simulate) {
        MovingStorageWrapper wrapper = MovingStorageItem.getMovingStorageWrapper(movingStorageStack);
        if (wrapper.getContentsUuid().isEmpty()) {
            wrapper.setContentsUuid(UUID.randomUUID());
        }
        return wrapper.getInventoryForUpgradeProcessing().insertItem(stack, simulate);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player) {
        if (this.hasCreativeScreenContainerOpen(player) || stack.method_7947() > 1 || !slot.method_7674(player) || slot.method_7677().method_7960() || action != class_5536.field_27014 || !this.isShulkerBoxMovingStorage(stack)) {
            return super.method_31565(stack, slot, action, player);
        }
        class_1799 stackToStash = slot.method_7677();
        class_1799 stashResult = this.stash(stack, stackToStash, true);
        if (stashResult.method_7947() != stackToStash.method_7947()) {
            int countToTake = stackToStash.method_7947() - stashResult.method_7947();
            class_1799 takeResult = slot.method_32753(countToTake, countToTake, player);
            this.stash(stack, takeResult, false);
            return true;
        }
        return super.method_31565(stack, slot, action, player);
    }

    private boolean isShulkerBoxMovingStorage(class_1799 movingStorageStack) {
        return MovingStorageItem.getStorageItemType(movingStorageStack).map(item -> item instanceof ShulkerBoxItem).orElse(false);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 action, class_1657 player, class_5630 carriedAccess) {
        if (this.hasCreativeScreenContainerOpen(player) || stack.method_7947() > 1 || !slot.method_7680(stack) || action != class_5536.field_27014 || !this.isShulkerBoxMovingStorage(stack)) {
            return super.method_31566(stack, otherStack, slot, action, player, carriedAccess);
        }
        class_1799 result = this.stash(stack, otherStack, false);
        if (result.method_7947() != otherStack.method_7947()) {
            carriedAccess.method_32332(result);
            slot.method_7673(stack);
            return true;
        }
        return super.method_31566(stack, otherStack, slot, action, player, carriedAccess);
    }

    private boolean hasCreativeScreenContainerOpen(class_1657 player) {
        return player.method_37908().method_8608() && player.field_7512 instanceof class_481.class_483;
    }

    static {
        DecorationTableBlockEntity.registerItemDecorator(stack -> stack.method_7909() instanceof MovingStorageItem, (DecorationTableBlockEntity.IItemDecorator)new DecorationTableBlockEntity.IItemDecorator(){

            public boolean supportsMaterials(class_1799 input) {
                class_1799 storageItem = MovingStorageItem.getStorageItem(input);
                return DecorationTableBlockEntity.STORAGE_DECORATOR.supportsMaterials(storageItem);
            }

            public boolean supportsTints(class_1799 input) {
                class_1799 storageItem = MovingStorageItem.getStorageItem(input);
                return DecorationTableBlockEntity.STORAGE_DECORATOR.supportsTints(storageItem);
            }

            public boolean supportsTopInnerTrim(class_1799 input) {
                class_1799 storageItem = MovingStorageItem.getStorageItem(input);
                return DecorationTableBlockEntity.STORAGE_DECORATOR.supportsTopInnerTrim(storageItem);
            }

            public class_1799 decorateWithMaterials(class_1799 input, Map<BarrelMaterial, class_2960> materialsToApply) {
                class_1799 storageItem = MovingStorageItem.getStorageItem(input);
                class_1799 storageResult = DecorationTableBlockEntity.STORAGE_DECORATOR.decorateWithMaterials(storageItem, materialsToApply);
                if (storageResult.method_7960()) {
                    return class_1799.field_8037;
                }
                class_1799 result = input.method_7972();
                MovingStorageItem.setStorageItem(result, storageResult);
                return result;
            }

            public DecorationTableBlockEntity.TintDecorationResult decorateWithTints(class_1799 input, int mainColorToSet, int accentColorToSet) {
                class_1799 storageItem = MovingStorageItem.getStorageItem(input);
                DecorationTableBlockEntity.TintDecorationResult tintResult = DecorationTableBlockEntity.STORAGE_DECORATOR.decorateWithTints(storageItem, mainColorToSet, accentColorToSet);
                if (tintResult.result().method_7960()) {
                    return DecorationTableBlockEntity.TintDecorationResult.EMPTY;
                }
                class_1799 result = input.method_7972();
                MovingStorageItem.setStorageItem(result, tintResult.result());
                return new DecorationTableBlockEntity.TintDecorationResult(result, tintResult.requiredDyeParts());
            }
        });
    }

    public record MovingStorageContentsTooltip(class_1799 movingStorage) implements class_5632
    {
        public class_1799 getMovingStorage() {
            return this.movingStorage;
        }
    }
}

