/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.extensions.component.SophisticatedDataComponentHolder;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.inventory.StorageWrapperRepository;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ContentsFilteredItemHandler;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.settings.StorageSettingsHandler;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import org.jetbrains.annotations.NotNull;

public class MovingStorageWrapper
implements IStorageWrapper {
    public static final String SETTINGS_TAG = "settings";
    private final Runnable stackChangeHandler;
    private final class_1799 storageStack;
    private final Runnable contentsChangeHandler;
    @Nullable
    private InventoryHandler inventoryHandler = null;
    @Nullable
    private ContentsFilteredItemHandler contentsFilteredItemHandler = null;
    @Nullable
    private InventoryIOHandler inventoryIOHandler = null;
    @Nullable
    private UpgradeHandler upgradeHandler = null;
    @Nullable
    private SettingsHandler settingsHandler;
    private final RenderInfo renderInfo;
    private final Map<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>> upgradeDefaultsHandlers = new HashMap<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>>();

    private MovingStorageWrapper(class_1799 storageStack, Runnable onContentsChanged, Runnable onStackChanged) {
        this.storageStack = storageStack;
        this.contentsChangeHandler = onContentsChanged;
        this.stackChangeHandler = onStackChanged;
        this.renderInfo = new MovingStorageRenderInfo(storageStack);
        if (EntityStorageHolder.isLimitedBarrel(storageStack)) {
            this.registerUpgradeDefaultsHandler(VoidUpgradeWrapper.class, LimitedBarrelBlockEntity.VOID_UPGRADE_VOIDING_OVERFLOW_OF_EVERYTHING_BY_DEFAULT);
        }
    }

    private static int getNumberOfDisplayItems(class_1799 stack) {
        return stack.method_7909() instanceof BarrelBlockItem ? 4 : 1;
    }

    public static MovingStorageWrapper fromStack(class_1799 stack, Runnable onContentsChanged, Runnable onStackChanged) {
        MovingStorageWrapper movingStorageWrapper = (MovingStorageWrapper)StorageWrapperRepository.getStorageWrapper((class_1799)stack, MovingStorageWrapper.class, s -> new MovingStorageWrapper((class_1799)s, onContentsChanged, onStackChanged));
        UUID uuid = (UUID)stack.sophisticatedCore_get(ModCoreDataComponents.STORAGE_UUID);
        if (uuid != null) {
            movingStorageWrapper.setContentsUuid(uuid);
        }
        return movingStorageWrapper;
    }

    private UUID getNewUuid() {
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        return newUuid;
    }

    public void setContentsChangeHandler(Runnable contentsChangeHandler) {
    }

    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    public ITrackedContentsItemHandler getInventoryForUpgradeProcessing() {
        return this.getInventoryHandler();
    }

    public InventoryHandler getInventoryHandler() {
        if (this.inventoryHandler == null) {
            this.initInventoryHandler();
        }
        return this.inventoryHandler;
    }

    private void initInventoryHandler() {
        this.inventoryHandler = new InventoryHandler(this.getNumberOfInventorySlots(), this, this.getContentsNbt(), this.contentsChangeHandler, StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this), Config.SERVER.stackUpgrade){

            protected boolean isAllowed(class_1799 stack) {
                return MovingStorageWrapper.this.isAllowedInStorage(stack);
            }
        };
        this.inventoryHandler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
        this.inventoryHandler.setShouldInsertIntoEmpty(this::emptyInventorySlotsAcceptItems);
        this.inventoryHandler.onInit();
    }

    private boolean emptyInventorySlotsAcceptItems() {
        return !EntityStorageHolder.isLocked(this.storageStack) || this.allowsEmptySlotsMatchingItemInsertsWhenLocked();
    }

    private boolean allowsEmptySlotsMatchingItemInsertsWhenLocked() {
        return !EntityStorageHolder.isLimitedBarrel(this.storageStack);
    }

    public int getNumberOfInventorySlots() {
        Integer numberOfInventorySlots = (Integer)this.storageStack.sophisticatedCore_get(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS);
        if (numberOfInventorySlots != null) {
            return numberOfInventorySlots;
        }
        numberOfInventorySlots = MovingStorageWrapper.getDefaultNumberOfInventorySlots(this.storageStack);
        this.storageStack.sophisticatedCore_set(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)numberOfInventorySlots);
        this.stackChangeHandler.run();
        return numberOfInventorySlots;
    }

    public ITrackedContentsItemHandler getInventoryForInputOutput() {
        if (EntityStorageHolder.isLocked(this.storageStack) && this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
            if (this.contentsFilteredItemHandler == null) {
                this.contentsFilteredItemHandler = new ContentsFilteredItemHandler(this::getInventoryIOHandler, () -> this.getInventoryHandler().getSlotTracker(), () -> (MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
            }
            return this.contentsFilteredItemHandler;
        }
        return this.getInventoryIOHandler();
    }

    @NotNull
    private ITrackedContentsItemHandler getInventoryIOHandler() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler((IStorageWrapper)this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    public SettingsHandler getSettingsHandler() {
        if (this.settingsHandler == null) {
            this.settingsHandler = this.getContentsUuid().isPresent() ? new StorageSettingsHandler(this.getSettingsNbt(), this.contentsChangeHandler, this::getInventoryHandler, () -> this.renderInfo){

                protected int getNumberOfDisplayItems() {
                    return MovingStorageWrapper.getNumberOfDisplayItems(MovingStorageWrapper.this.storageStack);
                }

                protected void saveCategoryNbt(class_2487 settingsNbt, String categoryName, class_2487 tag) {
                    super.saveCategoryNbt(settingsNbt, categoryName, tag);
                    MovingStorageWrapper.this.contentsChangeHandler.run();
                    if (categoryName.equals("item_display")) {
                        MovingStorageWrapper.this.stackChangeHandler.run();
                    }
                }
            } : NoopStorageWrapper.INSTANCE.getSettingsHandler();
        }
        return this.settingsHandler;
    }

    public UpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = new UpgradeHandler(this, this.getNumberOfUpgradeSlots(), this, this.getContentsNbt(), this.contentsChangeHandler, () -> {
                if (this.inventoryHandler != null) {
                    this.inventoryHandler.clearListeners();
                    this.inventoryHandler.setBaseSlotLimit(StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
                }
                this.getInventoryHandler().addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
                this.inventoryIOHandler = null;
            }){

                public boolean isItemValid(int slot, class_1799 stack) {
                    return super.isItemValid(slot, stack) && (stack.method_7960() || stack.method_31573(ModItems.STORAGE_UPGRADE_TAG));
                }
            };
            this.upgradeDefaultsHandlers.forEach(this::registerUpgradeDefaultsHandlerInUpgradeHandler);
        }
        return this.upgradeHandler;
    }

    private <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandlerInUpgradeHandler(Class<T> wrapperClass, Consumer<? extends IUpgradeWrapper> defaultsHandler) {
        this.upgradeHandler.registerUpgradeDefaultsHandler(wrapperClass, defaultsHandler);
    }

    public int getNumberOfUpgradeSlots() {
        Integer numberOfUpgradeSlots = (Integer)this.storageStack.sophisticatedCore_get(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS);
        if (numberOfUpgradeSlots != null) {
            return numberOfUpgradeSlots;
        }
        numberOfUpgradeSlots = MovingStorageWrapper.getDefaultNumberOfUpgradeSlots(this.storageStack);
        this.storageStack.sophisticatedCore_set(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)numberOfUpgradeSlots);
        this.stackChangeHandler.run();
        return numberOfUpgradeSlots;
    }

    public Optional<UUID> getContentsUuid() {
        return Optional.ofNullable((UUID)this.storageStack.sophisticatedCore_get(ModCoreDataComponents.STORAGE_UUID));
    }

    private class_2487 getSettingsNbt() {
        UUID storageId = this.getContentsUuid().orElseGet(this::getNewUuid);
        MovingStorageData storageData = MovingStorageData.get(storageId);
        class_2487 baseContentsNbt = storageData.getContents();
        if (!baseContentsNbt.method_10545(SETTINGS_TAG)) {
            baseContentsNbt.method_10566(SETTINGS_TAG, (class_2520)new class_2487());
            storageData.setContents(baseContentsNbt);
        }
        return baseContentsNbt.method_10562(SETTINGS_TAG);
    }

    private class_2487 getContentsNbt() {
        UUID storageId = this.getContentsUuid().orElseGet(this::getNewUuid);
        MovingStorageData storageData = MovingStorageData.get(storageId);
        class_2487 baseContentsNbt = storageData.getContents();
        if (!baseContentsNbt.method_10545("contents")) {
            baseContentsNbt.method_10566("contents", (class_2520)new class_2487());
            storageData.setContents(baseContentsNbt);
        }
        return baseContentsNbt.method_10562("contents");
    }

    public int getMainColor() {
        return StorageBlockItem.getMainColorFromComponentHolder((SophisticatedDataComponentHolder)this.storageStack).orElse(-1);
    }

    public int getAccentColor() {
        return StorageBlockItem.getAccentColorFromComponentHolder((SophisticatedDataComponentHolder)this.storageStack).orElse(-1);
    }

    public Optional<Integer> getOpenTabId() {
        return Optional.ofNullable((Integer)this.storageStack.sophisticatedCore_get(ModCoreDataComponents.OPEN_TAB_ID));
    }

    public void setOpenTabId(int openTabId) {
        this.storageStack.sophisticatedCore_set(ModCoreDataComponents.OPEN_TAB_ID, (Object)openTabId);
        this.stackChangeHandler.run();
    }

    public void removeOpenTabId() {
        this.storageStack.sophisticatedCore_remove(ModCoreDataComponents.OPEN_TAB_ID);
        this.stackChangeHandler.run();
    }

    public void setColors(int mainColor, int accentColor) {
        this.storageStack.sophisticatedCore_set(ModCoreDataComponents.MAIN_COLOR, (Object)mainColor);
        this.storageStack.sophisticatedCore_set(ModCoreDataComponents.ACCENT_COLOR, (Object)accentColor);
        this.stackChangeHandler.run();
    }

    public void setSortBy(SortBy sortBy) {
        this.storageStack.sophisticatedCore_set(ModCoreDataComponents.SORT_BY, (Object)sortBy);
        this.stackChangeHandler.run();
    }

    public SortBy getSortBy() {
        return (SortBy)this.storageStack.sophisticatedCore_getOrDefault(ModCoreDataComponents.SORT_BY, (Object)SortBy.NAME);
    }

    public void sort() {
        HashSet slotIndexesExcludedFromSort = new HashSet();
        slotIndexesExcludedFromSort.addAll(((NoSortSettingsCategory)this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class)).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(((MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).getSlotIndexes());
        slotIndexesExcludedFromSort.addAll(this.getInventoryHandler().getNoSortSlots());
        InventorySorter.sortHandler((IItemHandlerSimpleInserter)this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        return switch (this.getSortBy()) {
            default -> throw new MatchException(null, null);
            case SortBy.COUNT -> InventorySorter.BY_COUNT;
            case SortBy.TAGS -> InventorySorter.BY_TAGS;
            case SortBy.NAME -> InventorySorter.BY_NAME;
            case SortBy.MOD -> InventorySorter.BY_MOD;
        };
    }

    public void onContentsNbtUpdated() {
        this.inventoryHandler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
    }

    public void refreshInventoryForUpgradeProcessing() {
        this.refreshInventoryForInputOutput();
    }

    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
    }

    public void setPersistent(boolean persistent) {
    }

    public void fillWithLoot(class_1657 playerEntity) {
    }

    public RenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    public void setColumnsTaken(int columnsTaken, boolean hasChanged) {
    }

    public int getColumnsTaken() {
        return 0;
    }

    public void setContentsUuid(UUID contentsUuid) {
        this.storageStack.sophisticatedCore_set(ModCoreDataComponents.STORAGE_UUID, (Object)contentsUuid);
        this.onContentsNbtUpdated();
    }

    public static int getDefaultNumberOfInventorySlots(class_1799 storageStack) {
        int n;
        BlockItemBase blockItem;
        class_1792 class_17922 = storageStack.method_7909();
        if (class_17922 instanceof BlockItemBase && (class_17922 = (blockItem = (BlockItemBase)class_17922).method_7711()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)class_17922;
            n = storageBlock.getNumberOfInventorySlots();
        } else {
            n = 0;
        }
        return n;
    }

    public static int getDefaultNumberOfUpgradeSlots(class_1799 storageStack) {
        int n;
        BlockItemBase blockItem;
        class_1792 class_17922 = storageStack.method_7909();
        if (class_17922 instanceof BlockItemBase && (class_17922 = (blockItem = (BlockItemBase)class_17922).method_7711()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)class_17922;
            n = storageBlock.getNumberOfUpgradeSlots();
        } else {
            n = 0;
        }
        return n;
    }

    private boolean isAllowedInStorage(class_1799 stack) {
        if (!(this.storageStack.method_7909() instanceof ShulkerBoxItem)) {
            return true;
        }
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        return !(block instanceof ShulkerBoxBlock) && !(block instanceof class_2480) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(stack.method_7909());
    }

    public String getStorageType() {
        class_1792 storageItem = this.storageStack.method_7909();
        if (!(storageItem instanceof class_1747)) {
            return "undefined";
        }
        class_1747 blockItem = (class_1747)storageItem;
        if (blockItem.method_7711() instanceof ChestBlock) {
            return "chest";
        }
        if (blockItem.method_7711() instanceof ShulkerBoxBlock) {
            return "shulker_box";
        }
        if (blockItem.method_7711() instanceof LimitedBarrelBlock) {
            return "limited_barrel";
        }
        if (blockItem.method_7711() instanceof BarrelBlock) {
            return "barrel";
        }
        return "undefined";
    }

    public class_2561 getDisplayName() {
        return this.storageStack.method_7954();
    }

    public void changeSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        this.setNumberOfInventorySlots(this.getNumberOfInventorySlots() + additionalInventorySlots);
        this.getInventoryHandler().changeSlots(additionalInventorySlots);
        this.setNumberOfUpgradeSlots(this.getNumberOfUpgradeSlots() + additionalUpgradeSlots);
        this.getUpgradeHandler().increaseSize(additionalUpgradeSlots);
    }

    public void setNumberOfInventorySlots(int numberOfInventorySlots) {
        this.storageStack.sophisticatedCore_set(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)numberOfInventorySlots);
        this.stackChangeHandler.run();
    }

    public void setNumberOfUpgradeSlots(int numberOfUpgradeSlots) {
        this.storageStack.sophisticatedCore_set(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)numberOfUpgradeSlots);
        this.stackChangeHandler.run();
    }

    public <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandler(Class<T> upgradeClass, Consumer<T> defaultsHandler) {
        this.upgradeDefaultsHandlers.put(upgradeClass, defaultsHandler);
    }

    public class_1799 getWrappedStorageStack() {
        return this.storageStack;
    }

    public int getBaseStackSizeMultiplier() {
        int n;
        class_1747 blockItem;
        class_1792 class_17922 = this.storageStack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof IStorageBlock) {
            IStorageBlock storageBlock = (IStorageBlock)class_17922;
            n = storageBlock.getBaseStackSizeMultiplier();
        } else {
            n = 1;
        }
        return n;
    }

    private class MovingStorageRenderInfo
    extends RenderInfo {
        public MovingStorageRenderInfo(class_1799 storageStack) {
            super(() -> net$p3pp3rf1y$sophisticatedstorageinmotion$entity$MovingStorageWrapper$this.stackChangeHandler, EntityStorageHolder.isLimitedBarrel(storageStack));
            this.deserialize();
        }

        protected void serializeRenderInfo(class_2487 renderInfo) {
            MovingStorageWrapper.this.storageStack.sophisticatedCore_set(ModCoreDataComponents.RENDER_INFO_TAG, (Object)class_9279.method_57456((class_2487)renderInfo));
        }

        protected Optional<class_2487> getRenderInfoTag() {
            return Optional.ofNullable((class_9279)MovingStorageWrapper.this.storageStack.method_57824((class_9331)ModCoreDataComponents.RENDER_INFO_TAG.get())).map(class_9279::method_57461);
        }
    }
}

