/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingStorageContainerMenu;

public abstract class MovingStorageOpenersCounter {
    private static final int CHECK_TICK_DELAY = 5;
    private final class_1297 entity;
    private int openCount;
    private double maxInteractionRange;
    private long nextOpenRecheck;

    public MovingStorageOpenersCounter(class_1297 entity) {
        this.entity = entity;
        this.openCount = 0;
        this.maxInteractionRange = 0.0;
    }

    protected abstract void onOpen();

    protected abstract void onClose();

    private boolean isOwnContainer(class_1657 player) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof MovingStorageContainerMenu) {
            MovingStorageContainerMenu movingStorageContainerMenu = (MovingStorageContainerMenu)class_17032;
            return movingStorageContainerMenu.getStorageEntity().map(e -> e == this.entity).orElse(false);
        }
        return false;
    }

    public void incrementOpeners(class_1657 player) {
        int i;
        if ((i = this.openCount++) == 0) {
            this.onOpen();
            this.entity.method_37908().method_33596((class_1297)player, (class_6880)class_5712.field_28176, this.entity.method_24515());
            this.nextOpenRecheck = this.entity.method_37908().method_8510() + 5L;
        }
        this.maxInteractionRange = Math.max(player.method_55754(), this.maxInteractionRange);
    }

    public void decrementOpeners(class_1657 player) {
        --this.openCount;
        if (this.openCount == 0) {
            this.onClose();
            this.entity.method_37908().method_33596((class_1297)player, (class_6880)class_5712.field_28177, this.entity.method_24515());
            this.maxInteractionRange = 0.0;
        }
    }

    private List<class_1657> getPlayersWithContainerOpen(class_1937 level, class_2338 pos) {
        double maxDistance = this.maxInteractionRange + 4.0;
        class_238 aabb = new class_238(pos).method_1014(maxDistance);
        return level.method_18023(class_5575.method_31795(class_1657.class), aabb, this::isOwnContainer);
    }

    public void tick() {
        if (this.entity.method_37908().method_8510() > this.nextOpenRecheck && (this.entity.method_37908().method_8510() - this.nextOpenRecheck < 15L || this.openCount > 0)) {
            this.recheckOpeners();
        }
    }

    public void recheckOpeners() {
        class_1937 level = this.entity.method_37908();
        List<class_1657> playersWithStorageOpen = this.getPlayersWithContainerOpen(level, this.entity.method_24515());
        this.maxInteractionRange = 0.0;
        for (class_1657 player : playersWithStorageOpen) {
            this.maxInteractionRange = Math.max(player.method_55754(), this.maxInteractionRange);
        }
        int numberOfPlayers = playersWithStorageOpen.size();
        if (this.openCount != numberOfPlayers) {
            if (numberOfPlayers != 0 && this.openCount == 0) {
                this.onOpen();
                level.method_33596(null, (class_6880)class_5712.field_28176, this.entity.method_24515());
            } else if (numberOfPlayers == 0) {
                this.onClose();
                level.method_33596(null, (class_6880)class_5712.field_28177, this.entity.method_24515());
            }
            this.openCount = numberOfPlayers;
        }
        if (numberOfPlayers > 0) {
            this.nextOpenRecheck = level.method_8510() + 5L;
        }
    }

    public int getOpenerCount() {
        return this.openCount;
    }
}

