/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedstorageinmotion.SophisticatedStorageInMotion;

public class MovingStorageData
extends class_18 {
    private static final String SAVED_DATA_PREFIX = "sophisticatedstorageinmotion/";
    private class_2487 movingStorageContents = new class_2487();
    private boolean toRemove = false;
    private static final Map<UUID, MovingStorageData> clientStorageCopy = new HashMap<UUID, MovingStorageData>();
    private final Set<UUID> updatedStorageSettingsFlags = new HashSet<UUID>();

    private MovingStorageData() {
    }

    public static MovingStorageData get(UUID storageId) {
        MinecraftServer server;
        if (SophisticatedCore.isLogicalServerThread() && (server = SophisticatedCore.getCurrentServer()) != null) {
            class_3218 overworld = server.method_3847(class_1937.field_25179);
            class_26 storage = overworld.method_17983();
            return (MovingStorageData)storage.method_17924(new class_18.class_8645(MovingStorageData::new, MovingStorageData::load, null), SAVED_DATA_PREFIX + String.valueOf(storageId));
        }
        return clientStorageCopy.computeIfAbsent(storageId, id -> new MovingStorageData());
    }

    public static MovingStorageData load(class_2487 nbt, class_7225.class_7874 registries) {
        MovingStorageData storageData = new MovingStorageData();
        storageData.movingStorageContents = nbt;
        return storageData;
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 registries) {
        if (this.movingStorageContents != null) {
            return this.movingStorageContents;
        }
        return new class_2487();
    }

    public void removeStorageContents() {
        this.toRemove = true;
        this.method_80();
    }

    public void method_17919(File file, class_7225.class_7874 registries) {
        if (this.toRemove) {
            file.delete();
        } else {
            try {
                Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                SophisticatedStorageInMotion.LOGGER.error("Failed to create directories for moving storage data", (Throwable)e);
            }
            super.method_17919(file, registries);
        }
    }

    public void setContents(UUID storageUuid, class_2487 contents) {
        for (String key : contents.method_10541()) {
            this.movingStorageContents.method_10566(key, contents.method_10580(key));
            if (!key.equals("settings")) continue;
            this.updatedStorageSettingsFlags.add(storageUuid);
        }
        this.method_80();
    }

    public class_2487 getContents() {
        return this.movingStorageContents;
    }

    public void setContents(class_2487 contents) {
        this.movingStorageContents = contents;
        this.method_80();
    }

    public boolean removeUpdatedStorageSettingsFlag(UUID backpackUuid) {
        return this.updatedStorageSettingsFlags.remove(backpackUuid);
    }
}

