/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.entity;

import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_4719;
import net.minecraft.class_4838;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeRenderRegistry;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SophisticatedMenuProvider;
import net.p3pp3rf1y.sophisticatedcore.extensions.component.SophisticatedDataComponentHolder;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IDynamicRenderTracker;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.IMaterialHolder;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingLimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingStorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageOpenersCounter;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModDataComponents;

public class EntityStorageHolder<T extends class_1297>
implements ILockable,
ICountDisplay,
ITierDisplay,
IUpgradeDisplay,
IFillLevelDisplay,
IMaterialHolder {
    private static final int AVERAGE_DROPPED_ITEM_ENTITY_STACK_SIZE = 20;
    private final T entity;
    @Nullable
    private StorageBlockEntity renderBlockEntity = null;
    private IStorageWrapper storageWrapper = NoopStorageWrapper.INSTANCE;
    private final MovingStorageOpenersCounter openersCounter;
    private boolean updateRenderBlockEntityAttributes = false;

    public EntityStorageHolder(T entity) {
        this.entity = entity;
        this.openersCounter = new MovingStorageOpenersCounter((class_1297)entity, (class_1297)entity){
            final /* synthetic */ class_1297 val$entity;
            {
                this.val$entity = class_12972;
                super(entity);
            }

            @Override
            protected void onOpen() {
                if (EntityStorageHolder.this.isBarrel(((IMovingStorageEntity)this.val$entity).getStorageItem())) {
                    this.playSound(class_3417.field_17604);
                    EntityStorageHolder.this.updateBarrelOpenBlockState(true);
                } else if (EntityStorageHolder.this.isShulkerBox(((IMovingStorageEntity)this.val$entity).getStorageItem())) {
                    this.playSound(class_3417.field_14825);
                    StorageBlockEntity storageBlockEntity = EntityStorageHolder.this.renderBlockEntity;
                    if (storageBlockEntity instanceof ShulkerBoxBlockEntity) {
                        ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)storageBlockEntity;
                        shulkerBoxBlockEntity.setAnimationStatus(ShulkerBoxBlockEntity.AnimationStatus.OPENING);
                    }
                } else if (EntityStorageHolder.this.isChest(((IMovingStorageEntity)this.val$entity).getStorageItem())) {
                    this.playSound(class_3417.field_14982);
                    StorageBlockEntity storageBlockEntity = EntityStorageHolder.this.renderBlockEntity;
                    if (storageBlockEntity instanceof ChestBlockEntity) {
                        ChestBlockEntity chestBlockEntity = (ChestBlockEntity)storageBlockEntity;
                        chestBlockEntity.getChestLidController().method_31674(true);
                    }
                }
            }

            @Override
            protected void onClose() {
                if (EntityStorageHolder.this.isBarrel(((IMovingStorageEntity)this.val$entity).getStorageItem())) {
                    this.playSound(class_3417.field_17603);
                    EntityStorageHolder.this.updateBarrelOpenBlockState(false);
                } else if (EntityStorageHolder.this.isShulkerBox(((IMovingStorageEntity)this.val$entity).getStorageItem())) {
                    this.playSound(class_3417.field_14751);
                    StorageBlockEntity storageBlockEntity = EntityStorageHolder.this.renderBlockEntity;
                    if (storageBlockEntity instanceof ShulkerBoxBlockEntity) {
                        ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)storageBlockEntity;
                        shulkerBoxBlockEntity.setAnimationStatus(ShulkerBoxBlockEntity.AnimationStatus.CLOSING);
                    }
                } else if (EntityStorageHolder.this.isChest(((IMovingStorageEntity)this.val$entity).getStorageItem())) {
                    this.playSound(class_3417.field_14823);
                    StorageBlockEntity storageBlockEntity = EntityStorageHolder.this.renderBlockEntity;
                    if (storageBlockEntity instanceof ChestBlockEntity) {
                        ChestBlockEntity chestBlockEntity = (ChestBlockEntity)storageBlockEntity;
                        chestBlockEntity.getChestLidController().method_31674(false);
                    }
                }
            }

            private void playSound(class_3414 sound) {
                this.val$entity.method_37908().method_43129(null, this.val$entity, sound, class_3419.field_15245, 0.5f, this.val$entity.method_37908().field_9229.method_43057() * 0.1f + 0.9f);
            }
        };
    }

    private void updateBarrelOpenBlockState(boolean open) {
        BarrelBlockEntity barrelBlockEntity;
        StorageBlockEntity storageBlockEntity = this.getRenderBlockEntity();
        if (storageBlockEntity instanceof BarrelBlockEntity && !((barrelBlockEntity = (BarrelBlockEntity)storageBlockEntity) instanceof LimitedBarrelBlockEntity)) {
            barrelBlockEntity.method_31664((class_2680)barrelBlockEntity.method_11010().method_11657((class_2769)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(open)));
        }
    }

    private boolean isBarrel(class_1799 storageItem) {
        return storageItem.method_7909() instanceof BarrelBlockItem;
    }

    private boolean isShulkerBox(class_1799 storageItem) {
        return storageItem.method_7909() instanceof ShulkerBoxItem;
    }

    private boolean isChest(class_1799 storageItem) {
        return storageItem.method_7909() instanceof ChestBlockItem;
    }

    public static boolean areUpgradesVisible(class_1799 storageItem) {
        return (Boolean)storageItem.sophisticatedCore_getOrDefault(ModDataComponents.UPGRADES_VISIBLE, (Object)false);
    }

    public static boolean areCountsVisible(class_1799 storageItem) {
        return (Boolean)storageItem.sophisticatedCore_getOrDefault(ModDataComponents.COUNTS_VISIBLE, (Object)true);
    }

    public static boolean areFillLevelsVisible(class_1799 storageItem) {
        return (Boolean)storageItem.sophisticatedCore_getOrDefault(ModDataComponents.FILL_LEVELS_VISIBLE, (Object)false);
    }

    public void setStorageItemFrom(class_1799 stack, boolean setupDefaults) {
        SimpleItemContent storageItemContents = (SimpleItemContent)stack.method_57824(ModDataComponents.STORAGE_ITEM.get());
        if (storageItemContents == null) {
            class_1799 barrel = new class_1799((class_1935)ModBlocks.BARREL_ITEM.get());
            WoodStorageBlockItem.setWoodType((class_1799)barrel, (class_4719)class_4719.field_21677);
            this.setStorageItem(barrel);
        } else {
            class_1799 storageItem = storageItemContents.copy();
            this.setStorageItem(storageItem);
            if (setupDefaults && EntityStorageHolder.isLimitedBarrel(storageItem)) {
                int n;
                IStorageWrapper iStorageWrapper = this.getStorageWrapper();
                IStorageWrapper iStorageWrapper2 = this.storageWrapper;
                if (iStorageWrapper2 instanceof MovingStorageWrapper) {
                    MovingStorageWrapper movingStorageWrapper = (MovingStorageWrapper)iStorageWrapper2;
                    n = movingStorageWrapper.getNumberOfInventorySlots();
                } else {
                    n = this.storageWrapper.getInventoryHandler().getSlotCount();
                }
                LimitedBarrelBlock.setupDefaultSettings((IStorageWrapper)iStorageWrapper, (int)n);
            }
        }
    }

    public class_2487 saveData(class_7225.class_7874 registries) {
        class_2487 ret = new class_2487();
        class_1799 storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        if (!storageItem.method_7960()) {
            ret.method_10566("storageItem", storageItem.method_57376(registries, (class_2520)new class_2487()));
        }
        return ret;
    }

    public void readData(class_7225.class_7874 registries, class_2487 tag) {
        if (tag.method_10545("storageItem")) {
            this.setStorageItem(class_1799.method_57359((class_7225.class_7874)registries, (class_2487)tag.method_10562("storageItem")));
        }
    }

    public void setStorageItem(class_1799 storageItem) {
        ((IMovingStorageEntity)this.entity).setStorageItem(storageItem);
        this.storageWrapper = NoopStorageWrapper.INSTANCE;
        this.updateRenderBlockEntityAttributes = true;
    }

    public void updateStorageWrapper() {
        class_1799 storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        UUID id = (UUID)storageItem.sophisticatedCore_get(ModCoreDataComponents.STORAGE_UUID);
        if (id == null) {
            id = UUID.randomUUID();
            storageItem.sophisticatedCore_set(ModCoreDataComponents.STORAGE_UUID, (Object)id);
            this.setStorageItem(storageItem);
        }
        this.storageWrapper = MovingStorageWrapper.fromStack(storageItem, this::onContentsChanged, this::onStackChanged);
    }

    public IStorageWrapper getStorageWrapper() {
        if (!((IMovingStorageEntity)this.entity).getStorageItem().method_7960() && this.storageWrapper == NoopStorageWrapper.INSTANCE) {
            this.updateStorageWrapper();
        }
        return this.storageWrapper;
    }

    private void setRenderBlockEntity(StorageBlockEntity storageBlockEntity) {
        this.renderBlockEntity = storageBlockEntity;
    }

    private void onStackChanged() {
        ((IMovingStorageEntity)this.entity).setStorageItem(this.getStorageWrapper().getWrappedStorageStack());
        this.updateRenderBlockEntityAttributes = true;
    }

    private void onContentsChanged() {
        if (this.entity.method_37908().method_8608()) {
            return;
        }
        class_1799 storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        UUID storageId = (UUID)storageItem.sophisticatedCore_get(ModCoreDataComponents.STORAGE_UUID);
        if (storageId == null) {
            return;
        }
        MovingStorageData.get(storageId).method_80();
    }

    public void startOpen(class_1657 player) {
        if (!this.entity.method_31481() && !player.method_7325()) {
            this.openersCounter.incrementOpeners(player);
        }
        class_4838.method_24733((class_1657)player, (boolean)true);
        if (this.renderBlockEntity != null) {
            this.renderBlockEntity.startOpen(player);
        }
    }

    public void stopOpen(class_1657 player) {
        if (!this.entity.method_31481() && !player.method_7325()) {
            this.openersCounter.decrementOpeners(player);
        }
        if (this.renderBlockEntity != null) {
            this.renderBlockEntity.stopOpen(player);
        }
    }

    public void tick() {
        this.openersCounter.tick();
        if (this.entity.method_37908().method_8608()) {
            this.clientTick();
            return;
        }
        this.getStorageWrapper().getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(this.entity, this.entity.method_37908(), this.entity.method_24515()));
        this.runPickupOnItemEntities();
    }

    private void clientTick() {
        StorageBlockEntity storageBlockEntity;
        if (this.entity.method_37908().field_9229.method_43048(10) == 0) {
            RenderInfo renderInfo = this.getStorageWrapper().getRenderInfo();
            this.renderUpgrades(this.entity.method_37908(), this.entity.method_37908().field_9229, renderInfo);
        }
        if ((storageBlockEntity = this.renderBlockEntity) instanceof ChestBlockEntity) {
            ChestBlockEntity chestBlockEntity = (ChestBlockEntity)storageBlockEntity;
            ChestBlockEntity.lidAnimateTick((ChestBlockEntity)chestBlockEntity);
        } else {
            storageBlockEntity = this.renderBlockEntity;
            if (storageBlockEntity instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)storageBlockEntity;
                ShulkerBoxBlockEntity.tick(null, (class_2338)class_2338.field_10980, (class_2680)this.renderBlockEntity.method_11010(), (ShulkerBoxBlockEntity)shulkerBoxBlockEntity);
            }
        }
    }

    protected void renderUpgrades(class_1937 level, class_5819 rand, RenderInfo renderInfo) {
        if (class_310.method_1551().method_1493()) {
            return;
        }
        renderInfo.getUpgradeRenderData().forEach((type, data) -> UpgradeRenderRegistry.getUpgradeRenderer((UpgradeRenderDataType)type).ifPresent(renderer -> this.renderUpgrade((IUpgradeRenderer<T>)renderer, level, rand, (UpgradeRenderDataType<?>)type, (IUpgradeRenderData)data)));
    }

    private <T extends IUpgradeRenderData> void renderUpgrade(IUpgradeRenderer<T> renderer, class_1937 level, class_5819 rand, UpgradeRenderDataType<?> type, IUpgradeRenderData data) {
        type.cast(data).ifPresent(renderData -> renderer.render(level, rand, vector -> vector.add((float)this.entity.method_19538().method_10216(), (float)this.entity.method_19538().method_10214() + 0.8f, (float)this.entity.method_19538().method_10215()), renderData));
    }

    private void runPickupOnItemEntities() {
        class_238 aabb = this.entity.method_5829().method_1014(0.2);
        List collidedWithItemEntities = this.entity.method_37908().method_18467(class_1542.class, aabb);
        collidedWithItemEntities.forEach(itemEntity -> {
            if (itemEntity.method_5805()) {
                this.tryToPickup(this.entity.method_37908(), (class_1542)itemEntity);
            }
        });
    }

    protected void tryToPickup(class_1937 level, class_1542 itemEntity) {
        class_1799 remainingStack = itemEntity.method_6983().method_7972();
        remainingStack = InventoryHelper.runPickupOnPickupResponseUpgrades((class_1937)level, (UpgradeHandler)this.getStorageWrapper().getUpgradeHandler(), (class_1799)remainingStack, (boolean)false);
        if (remainingStack.method_7947() < itemEntity.method_6983().method_7947()) {
            itemEntity.method_6979(remainingStack);
        }
    }

    public static boolean isLocked(class_1799 stack) {
        return (Boolean)stack.sophisticatedCore_getOrDefault(ModDataComponents.LOCKED, (Object)false);
    }

    public static boolean isLockVisible(class_1799 storageItem) {
        return (Boolean)storageItem.sophisticatedCore_getOrDefault(ModDataComponents.LOCK_VISIBLE, (Object)true);
    }

    public static class_2487 getRenderInfoNbt(class_1799 storageItem) {
        return ((class_9279)storageItem.sophisticatedCore_getOrDefault(ModCoreDataComponents.RENDER_INFO_TAG, (Object)class_9279.field_49302)).method_57461();
    }

    public StorageBlockEntity getRenderBlockEntity() {
        class_1792 class_17922;
        class_1799 storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        if (this.renderBlockEntity == null) {
            class_17922 = storageItem.method_7909();
            if (class_17922 instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                if (blockItem.method_7711() instanceof ChestBlock) {
                    this.renderBlockEntity = new ChestBlockEntity(class_2338.field_10980, blockItem.method_7711().method_9564());
                } else if (blockItem.method_7711() instanceof LimitedBarrelBlock) {
                    this.renderBlockEntity = new LimitedBarrelBlockEntity(class_2338.field_10980, (class_2680)((class_2680)blockItem.method_7711().method_9564().method_11657((class_2769)LimitedBarrelBlock.HORIZONTAL_FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)LimitedBarrelBlock.VERTICAL_FACING, (Comparable)VerticalFacing.UP));
                } else if (blockItem.method_7711() instanceof BarrelBlock) {
                    this.renderBlockEntity = new BarrelBlockEntity(class_2338.field_10980, (class_2680)blockItem.method_7711().method_9564().method_11657((class_2769)BarrelBlock.FACING, (Comparable)class_2350.field_11036));
                } else if (blockItem.method_7711() instanceof ShulkerBoxBlock) {
                    this.renderBlockEntity = new ShulkerBoxBlockEntity(class_2338.field_10980, blockItem.method_7711().method_9564());
                }
            }
            if (this.renderBlockEntity == null) {
                this.renderBlockEntity = new ChestBlockEntity(class_2338.field_10980, ((ChestBlock)ModBlocks.CHEST.get()).method_9564());
            }
            this.setRenderBlockEntity(this.renderBlockEntity);
        }
        if (this.renderBlockEntity != null && this.updateRenderBlockEntityAttributes) {
            StorageBlockEntity storageBlockEntity;
            StorageBlockEntity isPacked2;
            this.updateRenderBlockEntityAttributes = false;
            if (this.renderBlockEntity.isLocked() != EntityStorageHolder.isLocked(storageItem)) {
                this.renderBlockEntity.toggleLock();
            }
            if (this.renderBlockEntity.shouldShowLock() != EntityStorageHolder.isLockVisible(storageItem)) {
                this.renderBlockEntity.toggleLockVisibility();
            }
            if (this.renderBlockEntity.shouldShowTier() != StorageBlockItem.showsTier((class_1799)storageItem)) {
                this.renderBlockEntity.toggleTierVisiblity();
            }
            this.renderBlockEntity.getStorageWrapper().getRenderInfo().deserializeFrom(EntityStorageHolder.getRenderInfoNbt(storageItem));
            if (this.renderBlockEntity.shouldShowUpgrades() != EntityStorageHolder.areUpgradesVisible(storageItem)) {
                this.renderBlockEntity.toggleUpgradesVisiblity();
            }
            if ((class_17922 = storageItem.method_7909()) instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)class_17922;
                this.renderBlockEntity.getStorageWrapper().setColors(tintableBlockItem.getMainColor(storageItem).orElse(-1).intValue(), tintableBlockItem.getAccentColor(storageItem).orElse(-1).intValue());
            }
            if ((class_17922 = this.renderBlockEntity) instanceof WoodStorageBlockEntity) {
                WoodStorageBlockEntity woodStorage = (WoodStorageBlockEntity)class_17922;
                WoodStorageBlockItem.getWoodType((SophisticatedDataComponentHolder)storageItem).ifPresent(woodType -> {
                    if (woodStorage.getWoodType() != WoodStorageBlockItem.getWoodType((SophisticatedDataComponentHolder)storageItem)) {
                        woodStorage.setWoodType(woodType);
                    }
                });
                boolean isPacked2 = EntityStorageHolder.isPacked(storageItem);
                if (woodStorage.isPacked() != isPacked2) {
                    woodStorage.setPacked(isPacked2);
                }
            }
            if ((isPacked2 = this.renderBlockEntity) instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)isPacked2;
                Map materials = BarrelBlockItem.getMaterials((class_1799)storageItem);
                if (!barrel.getMaterials().equals(materials)) {
                    barrel.setMaterials(materials);
                }
                barrel.setDynamicRenderTracker(new IDynamicRenderTracker(this){

                    public boolean isDynamicRenderer() {
                        return true;
                    }

                    public boolean isFullyDynamicRenderer() {
                        return true;
                    }

                    public void onRenderInfoUpdated(RenderInfo ri) {
                    }
                });
                StorageBlockEntity storageBlockEntity2 = this.renderBlockEntity;
                if (storageBlockEntity2 instanceof LimitedBarrelBlockEntity) {
                    LimitedBarrelBlockEntity limitedBarrelBlockEntity = (LimitedBarrelBlockEntity)storageBlockEntity2;
                    if (limitedBarrelBlockEntity.shouldShowFillLevels() != EntityStorageHolder.areFillLevelsVisible(storageItem)) {
                        limitedBarrelBlockEntity.toggleFillLevelVisibility();
                    }
                    if (limitedBarrelBlockEntity.shouldShowCounts() != EntityStorageHolder.areCountsVisible(storageItem)) {
                        limitedBarrelBlockEntity.toggleCountVisibility();
                    }
                }
            }
            if ((storageBlockEntity = this.renderBlockEntity) instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)storageBlockEntity;
                chestBlockEntity.showUpgradesOnTop = true;
            }
        }
        return this.renderBlockEntity;
    }

    private static boolean isPacked(class_1799 storageItem) {
        return WoodStorageBlockItem.isPacked((class_1799)storageItem);
    }

    public void onStorageItemSynced() {
        if (this.renderBlockEntity != null && this.renderBlockEntity.method_11010().method_26204().method_8389() != ((IMovingStorageEntity)this.entity).getStorageItem().method_7909()) {
            this.renderBlockEntity = null;
        }
        this.updateRenderBlockEntityAttributes = true;
        this.storageWrapper = NoopStorageWrapper.INSTANCE;
    }

    public class_1269 openContainerMenu(class_1657 player) {
        if (EntityStorageHolder.isPacked(((IMovingStorageEntity)this.entity).getStorageItem())) {
            return class_1269.field_5811;
        }
        player.sophisticatedCore_openMenu((class_3908)new SophisticatedMenuProvider((w, p, pl) -> this.createMenu(w, pl), this.entity.method_5477(), false), buffer -> buffer.method_53002(this.entity.method_5628()));
        return player.method_37908().field_9236 ? class_1269.field_5812 : class_1269.field_21466;
    }

    public MovingStorageContainerMenu<? extends class_1297> createMenu(int id, class_1657 pl) {
        if (EntityStorageHolder.isLimitedBarrel(((IMovingStorageEntity)this.entity).getStorageItem())) {
            return new MovingLimitedBarrelContainerMenu(id, pl, this.entity.method_5628());
        }
        return new MovingStorageContainerMenu(id, pl, this.entity.method_5628());
    }

    public static boolean isLimitedBarrel(class_1799 storageItem) {
        class_1747 blockItem;
        class_1792 class_17922 = storageItem.method_7909();
        return class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof LimitedBarrelBlock;
    }

    public void onDestroy() {
        if (this.entity.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            class_1799 storageItem;
            if (((Boolean)Config.COMMON.dropPacked.get()).booleanValue()) {
                this.pack();
            }
            if (!this.isShulkerBox(storageItem = ((IMovingStorageEntity)this.entity).getStorageItem()) && !EntityStorageHolder.isPacked(storageItem)) {
                this.dropAllItems();
                if (storageItem.sophisticatedCore_has(ModCoreDataComponents.STORAGE_UUID)) {
                    MovingStorageData.get((UUID)storageItem.sophisticatedCore_get(ModCoreDataComponents.STORAGE_UUID)).removeStorageContents();
                    storageItem.sophisticatedCore_remove(ModCoreDataComponents.STORAGE_UUID);
                }
            }
            class_1799 drop = ((IMovingStorageEntity)this.entity).getDropStack();
            drop.sophisticatedCore_set(ModDataComponents.STORAGE_ITEM, (Object)SimpleItemContent.copyOf((class_1799)storageItem));
            if (this.entity.method_16914()) {
                drop.method_57379(class_9334.field_49631, (Object)this.entity.method_5797());
            }
            this.entity.method_5775(drop);
        }
    }

    private void dropAllItems() {
        InventoryHelper.dropItems((SlottedStackStorage)this.getStorageWrapper().getInventoryHandler(), (class_1937)this.entity.method_37908(), (double)this.entity.method_19538().method_10216(), (double)this.entity.method_19538().method_10214(), (double)this.entity.method_19538().method_10215());
        InventoryHelper.dropItems((SlottedStackStorage)this.getStorageWrapper().getUpgradeHandler(), (class_1937)this.entity.method_37908(), (double)this.entity.method_19538().method_10216(), (double)this.entity.method_19538().method_10214(), (double)this.entity.method_19538().method_10215());
    }

    public void toggleLock() {
        boolean locked;
        class_1799 storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        boolean bl = locked = !EntityStorageHolder.isLocked(storageItem);
        if (this.memorizesItemsWhenLocked()) {
            if (locked) {
                ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).selectSlots(0, this.getStorageWrapper().getInventoryHandler().getSlotCount());
            } else {
                ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).unselectAllSlots();
                ItemDisplaySettingsCategory itemDisplaySettings = (ItemDisplaySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class);
                InventoryHelper.iterate((SlottedStorage)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
                    if (stack.method_7960()) {
                        itemDisplaySettings.itemChanged(slot.intValue());
                    }
                });
            }
        }
        storageItem.sophisticatedCore_set(ModDataComponents.LOCKED, (Object)locked);
        this.setStorageItem(storageItem);
    }

    private boolean memorizesItemsWhenLocked() {
        return EntityStorageHolder.isLimitedBarrel(((IMovingStorageEntity)this.entity).getStorageItem());
    }

    public boolean isLocked() {
        return EntityStorageHolder.isLocked(((IMovingStorageEntity)this.entity).getStorageItem());
    }

    public boolean shouldShowLock() {
        return EntityStorageHolder.isLockVisible(((IMovingStorageEntity)this.entity).getStorageItem());
    }

    public void toggleLockVisibility() {
        class_1799 storageItem;
        storageItem.sophisticatedCore_set(ModDataComponents.LOCK_VISIBLE, (Object)(!EntityStorageHolder.isLockVisible(storageItem = ((IMovingStorageEntity)this.entity).getStorageItem()) ? 1 : 0));
        this.setStorageItem(storageItem);
    }

    public boolean shouldShowCounts() {
        return EntityStorageHolder.areCountsVisible(((IMovingStorageEntity)this.entity).getStorageItem());
    }

    public void toggleCountVisibility() {
        class_1799 storageItem;
        storageItem.sophisticatedCore_set(ModDataComponents.COUNTS_VISIBLE, (Object)(!EntityStorageHolder.areCountsVisible(storageItem = ((IMovingStorageEntity)this.entity).getStorageItem()) ? 1 : 0));
        this.setStorageItem(storageItem);
    }

    public List<Integer> getSlotCounts() {
        return EntityStorageHolder.isLimitedBarrel(((IMovingStorageEntity)this.entity).getStorageItem()) ? this.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotCounts() : List.of();
    }

    public boolean shouldShowFillLevels() {
        return EntityStorageHolder.areFillLevelsVisible(((IMovingStorageEntity)this.entity).getStorageItem());
    }

    public void toggleFillLevelVisibility() {
        class_1799 storageItem;
        storageItem.sophisticatedCore_set(ModDataComponents.FILL_LEVELS_VISIBLE, (Object)(!EntityStorageHolder.areFillLevelsVisible(storageItem = ((IMovingStorageEntity)this.entity).getStorageItem()) ? 1 : 0));
        this.setStorageItem(storageItem);
    }

    public List<Float> getSlotFillLevels() {
        return EntityStorageHolder.isLimitedBarrel(((IMovingStorageEntity)this.entity).getStorageItem()) ? this.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotFillRatios() : List.of();
    }

    public boolean shouldShowTier() {
        return StorageBlockItem.showsTier((class_1799)((IMovingStorageEntity)this.entity).getStorageItem());
    }

    public void toggleTierVisiblity() {
        class_1799 storageItem;
        StorageBlockItem.setShowsTier((class_1799)storageItem, (!StorageBlockItem.showsTier((class_1799)(storageItem = ((IMovingStorageEntity)this.entity).getStorageItem())) ? 1 : 0) != 0);
        this.setStorageItem(storageItem);
    }

    public boolean shouldShowUpgrades() {
        return EntityStorageHolder.areUpgradesVisible(((IMovingStorageEntity)this.entity).getStorageItem());
    }

    public void toggleUpgradesVisiblity() {
        class_1799 storageItem;
        storageItem.sophisticatedCore_set(ModDataComponents.UPGRADES_VISIBLE, (Object)(!EntityStorageHolder.areUpgradesVisible(storageItem = ((IMovingStorageEntity)this.entity).getStorageItem()) ? 1 : 0));
        this.setStorageItem(storageItem);
    }

    public boolean isOpen() {
        return this.openersCounter.getOpenerCount() > 0;
    }

    public boolean pack() {
        if (this.isShulkerBox(((IMovingStorageEntity)this.entity).getStorageItem()) || EntityStorageHolder.isPacked(((IMovingStorageEntity)this.entity).getStorageItem())) {
            return false;
        }
        class_1799 storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        WoodStorageBlockItem.setPacked((class_1799)storageItem, (boolean)true);
        this.setStorageItem(storageItem);
        return true;
    }

    public void onPlace() {
        if (EntityStorageHolder.isPacked(((IMovingStorageEntity)this.entity).getStorageItem())) {
            class_1799 storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
            WoodStorageBlockItem.setPacked((class_1799)storageItem, (boolean)false);
            this.setStorageItem(storageItem);
        }
    }

    private boolean canBeHurtByWithFeedback(class_1282 source) {
        class_1297 class_12972;
        if (((Boolean)Config.COMMON.dropPacked.get()).booleanValue() || this.isPacked() || !((class_12972 = source.method_5529()) instanceof class_1657)) {
            return true;
        }
        class_1657 player = (class_1657)class_12972;
        if (player.method_18276() || this.isShulkerBox(((IMovingStorageEntity)this.entity).getStorageItem())) {
            return true;
        }
        AtomicInteger droppedItemEntityCount = new AtomicInteger(0);
        InventoryHelper.iterate((SlottedStorage)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
            if (stack.method_7960()) {
                return;
            }
            droppedItemEntityCount.addAndGet((int)Math.ceil((double)stack.method_7947() / (double)Math.min(stack.method_7914(), 20)));
        });
        if (droppedItemEntityCount.get() <= (Integer)Config.SERVER.tooManyItemEntityDrops.get()) {
            return true;
        }
        ItemBase packingTapeItem = (ItemBase)ModItems.PACKING_TAPE.get();
        class_5250 packingTapeItemName = packingTapeItem.method_7864(new class_1799((class_1935)packingTapeItem)).method_27661().method_27692(class_124.field_1060);
        player.method_43496((class_2561)StorageTranslationHelper.INSTANCE.translStatusMessage("too_many_item_entity_drops", new Object[]{this.entity.method_5477().method_27661().method_27692(class_124.field_1060), class_2561.method_43470((String)String.valueOf(droppedItemEntityCount.get())).method_27692(class_124.field_1061), packingTapeItemName}));
        return false;
    }

    public boolean isPacked() {
        return EntityStorageHolder.isPacked(((IMovingStorageEntity)this.entity).getStorageItem());
    }

    public void setMaterials(Map<BarrelMaterial, class_2960> materials) {
        class_1799 storageItem = ((IMovingStorageEntity)this.entity).getStorageItem();
        if (this.isBarrel(storageItem)) {
            BarrelBlockItem.setMaterials((class_1799)storageItem, materials);
            this.setStorageItem(storageItem);
        }
    }

    public Map<BarrelMaterial, class_2960> getMaterials() {
        return this.isBarrel(((IMovingStorageEntity)this.entity).getStorageItem()) ? BarrelBlockItem.getMaterials((class_1799)((IMovingStorageEntity)this.entity).getStorageItem()) : Collections.emptyMap();
    }

    public boolean canHoldMaterials() {
        return this.isBarrel(((IMovingStorageEntity)this.entity).getStorageItem());
    }

    public boolean hurt(class_1282 source, float amount, BiFunction<class_1282, Float, Boolean> superHurt) {
        if (this.canBeHurtByWithFeedback(source) && superHurt.apply(source, Float.valueOf(amount)).booleanValue()) {
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                if (player.method_31549().field_7477 && this.entity.method_31481()) {
                    this.dropAllItems();
                }
            }
            return true;
        }
        return false;
    }
}

