/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_8710;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SophisticatedMenuProvider;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingStorageSettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModEntities;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageContentsPayload;

public class MovingStorageContainerMenu<T extends class_1297>
extends StorageContainerMenuBase<IStorageWrapper>
implements ISyncedContainer {
    protected final WeakReference<T> storageEntity;
    @Nullable
    private class_2487 lastSettingsNbt = null;

    public MovingStorageContainerMenu(int containerId, class_1657 player, int entityId) {
        this(ModEntities.MOVING_STORAGE_CONTAINER_TYPE.get(), containerId, player, entityId);
    }

    public MovingStorageContainerMenu(class_3917<?> menuType, int containerId, class_1657 player, int entityId) {
        super(menuType, containerId, player, MovingStorageContainerMenu.getWrapper(player.method_37908(), entityId), (IStorageWrapper)NoopStorageWrapper.INSTANCE, -1, false);
        class_1297 class_12972 = player.method_37908().method_8469(entityId);
        if (!(class_12972 instanceof IMovingStorageEntity)) {
            throw new IllegalArgumentException("Incorrect entity with id " + entityId + " expected to find IMovingStorageEntity");
        }
        IMovingStorageEntity movingStorageEntity = (IMovingStorageEntity)class_12972;
        this.storageEntity = new WeakReference<class_1297>((class_1297)movingStorageEntity);
        movingStorageEntity.getStorageHolder().startOpen(player);
    }

    public Optional<T> getStorageEntity() {
        return Optional.ofNullable((class_1297)this.storageEntity.get());
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.getStorageEntity().ifPresent(storageEntity -> ((IMovingStorageEntity)storageEntity).getStorageHolder().stopOpen(player));
    }

    private static IStorageWrapper getWrapper(class_1937 level, int entityId) {
        class_1297 class_12972 = level.method_8469(entityId);
        if (!(class_12972 instanceof IMovingStorageEntity)) {
            return NoopStorageWrapper.INSTANCE;
        }
        IMovingStorageEntity movingStorage = (IMovingStorageEntity)class_12972;
        return movingStorage.getStorageHolder().getStorageWrapper();
    }

    public static MovingStorageContainerMenu<?> fromBuffer(int windowId, class_1661 playerInventory, class_2540 buffer) {
        return new MovingStorageContainerMenu(windowId, playerInventory.field_7546, buffer.readInt());
    }

    public Optional<class_2338> getBlockPosition() {
        return Optional.empty();
    }

    public Optional<class_1297> getEntity() {
        return this.getStorageEntity().map(e -> e);
    }

    protected StorageContainerMenuBase.StorageUpgradeSlot instantiateUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
        return new StorageContainerMenuBase.StorageUpgradeSlot(upgradeHandler, slotIndex){

            protected void onUpgradeChanged() {
                if (MovingStorageContainerMenu.this.player.method_37908().method_8608()) {
                    return;
                }
                ((ItemDisplaySettingsCategory)MovingStorageContainerMenu.this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
            }
        };
    }

    public void openSettings() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.method_10582("action", "openSettings"));
            return;
        }
        this.getStorageEntity().ifPresent(entity -> this.player.sophisticatedCore_openMenu((class_3908)new SophisticatedMenuProvider((w, p, pl) -> this.instantiateSettingsContainerMenu(w, pl, entity.method_5628()), (class_2561)class_2561.method_43471((String)StorageTranslationHelper.INSTANCE.translGui("settings.title")), false), buffer -> buffer.method_53002(entity.method_5628())));
    }

    protected MovingStorageSettingsContainerMenu instantiateSettingsContainerMenu(int windowId, class_1657 player, int entityId) {
        return new MovingStorageSettingsContainerMenu(windowId, player, entityId);
    }

    protected boolean storageItemHasChanged() {
        return false;
    }

    public boolean detectSettingsChangeAndReload() {
        if (this.player.method_37908().field_9236) {
            return this.storageWrapper.getContentsUuid().map(uuid -> {
                MovingStorageData storage = MovingStorageData.get(uuid);
                if (storage.removeUpdatedStorageSettingsFlag((UUID)uuid)) {
                    this.storageWrapper.getSettingsHandler().reloadFrom(storage.getContents().method_10562("settings"));
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean method_7597(class_1657 player) {
        return this.getStorageEntity().map(se -> player.method_5707(se.method_19538()) <= 64.0).orElse(false);
    }

    protected void sendStorageSettingsToClient() {
        if (this.player.method_37908().field_9236) {
            return;
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)this.storageWrapper.getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = this.storageWrapper.getSettingsHandler().getNbt().method_10553();
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                class_2487 settingsContents = new class_2487();
                class_2487 settingsNbt = this.storageWrapper.getSettingsHandler().getNbt();
                if (!settingsNbt.method_33133()) {
                    settingsContents.method_10566("settings", (class_2520)settingsNbt);
                    class_1657 patt0$temp = this.player;
                    if (patt0$temp instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)patt0$temp;
                        PacketDistributor.sendToPlayer((class_3222)serverPlayer, (class_8710)new MovingStorageContentsPayload((UUID)uuid, settingsContents));
                    }
                }
            });
        }
    }

    public float getSlotFillPercentage(int slot) {
        IMovingStorageEntity entity = (IMovingStorageEntity)this.storageEntity.get();
        if (entity == null) {
            return 0.0f;
        }
        List slotFillRatios = entity.getStorageHolder().getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotFillRatios();
        return slot > -1 && slot < slotFillRatios.size() ? ((Float)slotFillRatios.get(slot)).floatValue() : 0.0f;
    }
}

