/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common;

import java.util.UUID;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3966;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.event.common.PlayerEvents;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.ITintable;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.PaintbrushItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.StorageToolHandler;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.TierUpgradeHandler;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;
import org.jetbrains.annotations.Nullable;

public class CommonEventHandler {
    private CommonEventHandler() {
    }

    public static void registerHandlers() {
        PlayerEvents.ITEM_CRAFTED.register(CommonEventHandler::onMovingStorageUncrafted);
        PlayerEvents.ITEM_CRAFTED.register(CommonEventHandler::onMovingStorageCraftedFromShulkerBox);
        UseEntityCallback.EVENT.register(TierUpgradeHandler::onTierUpgradeInteract);
        UseEntityCallback.EVENT.register(StorageToolHandler::onStorageToolInteract);
        UseEntityCallback.EVENT.register(CommonEventHandler::onPacked);
        UseEntityCallback.EVENT.register(CommonEventHandler::onPaintbrushInteract);
        UseEntityCallback.EVENT.register(CommonEventHandler::onStorageUpgradeInteract);
    }

    private static class_1269 onStorageUpgradeInteract(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        IMovingStorageEntity movingStorage;
        class_1799 itemInHand;
        block5: {
            block4: {
                itemInHand = player.method_5998(hand);
                if (!(entity instanceof IMovingStorageEntity)) break block4;
                movingStorage = (IMovingStorageEntity)entity;
                if (itemInHand.method_7909() instanceof UpgradeItemBase) break block5;
            }
            return class_1269.field_5811;
        }
        if (StorageBlockBase.tryAddSingleUpgrade((class_1657)player, (class_1268)hand, (class_1799)itemInHand, (IStorageWrapper)movingStorage.getStorageHolder().getStorageWrapper())) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static class_1269 onPaintbrushInteract(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        IMovingStorageEntity movingStorage;
        class_1799 itemInHand;
        block6: {
            block5: {
                itemInHand = player.method_5998(hand);
                if (!(entity instanceof IMovingStorageEntity)) break block5;
                movingStorage = (IMovingStorageEntity)entity;
                if (itemInHand.method_7909() == ModItems.PAINTBRUSH) break block6;
            }
            return class_1269.field_5811;
        }
        class_1792 class_17922 = movingStorage.getStorageItem().method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return class_1269.field_5811;
        }
        class_1747 blockItem = (class_1747)class_17922;
        class_2680 state = blockItem.method_7711().method_9564();
        class_3414 placeSound = state.method_26231().method_10598();
        if (PaintbrushItem.paint((class_1657)player, (class_1799)itemInHand, movingStorage.getStorageHolder(), (ITintable)movingStorage.getStorageHolder().getStorageWrapper(), (class_243)entity.method_19538(), (class_2350)class_2350.field_11036, (class_3414)placeSound)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static class_1269 onPacked(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        IMovingStorageEntity movingStorage;
        class_1799 itemInHand;
        block7: {
            block6: {
                itemInHand = player.method_5998(hand);
                if (!(entity instanceof IMovingStorageEntity)) break block6;
                movingStorage = (IMovingStorageEntity)entity;
                if (itemInHand.method_7909() == ModItems.PACKING_TAPE && !((Boolean)Config.COMMON.dropPacked.get()).booleanValue()) break block7;
            }
            return class_1269.field_5811;
        }
        if (movingStorage.getStorageHolder().pack()) {
            if (!player.method_7337()) {
                itemInHand.method_7974(itemInHand.method_7919() + 1);
                if (itemInHand.method_7919() >= itemInHand.method_7936()) {
                    player.method_6122(hand, class_1799.field_8037);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static void onMovingStorageUncrafted(class_1657 player, class_1799 result, class_1263 craftMatrix) {
        if (player.method_37908().method_8608() || !(result.method_7909() instanceof StorageBlockItem) || !CommonEventHandler.isUncraftedFromSingleMovingStorage((class_1263)player.method_31548())) {
            return;
        }
        @Nullable UUID storageId = (UUID)result.sophisticatedCore_get(ModCoreDataComponents.STORAGE_UUID);
        if (storageId == null) {
            return;
        }
        MovingStorageData storageData = MovingStorageData.get(storageId);
        class_2487 contents = storageData.getContents();
        contents.method_10566("renderInfo", (class_2520)((class_9279)result.sophisticatedCore_getOrDefault(ModCoreDataComponents.RENDER_INFO_TAG, (Object)class_9279.field_49302)).method_57461());
        class_2487 fullContents = new class_2487();
        fullContents.method_10566("storageWrapper", (class_2520)contents);
        ItemContentsStorage.get().setStorageContents(storageId, fullContents);
        storageData.removeStorageContents();
    }

    private static boolean isUncraftedFromSingleMovingStorage(class_1263 inventory) {
        boolean hasMovingStorage = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!hasMovingStorage && stack.method_7909() instanceof MovingStorageItem) {
                hasMovingStorage = true;
                continue;
            }
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    private static void onMovingStorageCraftedFromShulkerBox(class_1657 player, class_1799 result, class_1263 craftMatrix) {
        class_1937 level = player.method_37908();
        if (level.method_8608()) {
            return;
        }
        if (!CommonEventHandler.isCraftedFromShulkerBox(craftMatrix)) {
            return;
        }
        class_1799 storageItem = MovingStorageItem.getStorageItem(result);
        if (storageItem.method_7909() instanceof ShulkerBoxItem) {
            StackStorageWrapper shulkerStorageWrapper = StackStorageWrapper.fromStack((class_7225.class_7874)level.method_30349(), (class_1799)storageItem);
            shulkerStorageWrapper.getContentsUuid().ifPresent(id -> {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                class_2487 contentsNbt = itemContentsStorage.getOrCreateStorageContents(id).method_10562("storageWrapper");
                class_2487 migratedContentsNbt = new class_2487();
                migratedContentsNbt.method_10566("contents", (class_2520)contentsNbt.method_10562("contents"));
                migratedContentsNbt.method_10566("settings", (class_2520)contentsNbt.method_10562("settings"));
                MovingStorageData.get(id).setContents(migratedContentsNbt);
                storageItem.sophisticatedCore_set(ModCoreDataComponents.RENDER_INFO_TAG, (Object)class_9279.method_57456((class_2487)contentsNbt.method_10562("renderInfo")));
                MovingStorageItem.setStorageItem(result, storageItem);
                itemContentsStorage.removeStorageContents(id);
            });
            MovingStorageItem.setStorageItem(result, storageItem);
        }
    }

    private static boolean isCraftedFromShulkerBox(class_1263 craftingGrid) {
        boolean foundShulker = false;
        for (int slot = 0; slot < craftingGrid.method_5439(); ++slot) {
            if (!(craftingGrid.method_5438(slot).method_7909() instanceof ShulkerBoxItem)) continue;
            foundShulker = true;
        }
        return foundShulker;
    }
}

