/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.ILootrEntityConverter;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.api.filter.ILootrFilter;
import noobanidus.mods.lootr.common.api.filter.ILootrFilterProvider;
import org.jetbrains.annotations.Nullable;

public class LootrServiceRegistry {
    private static LootrServiceRegistry INSTANCE;
    private final Map<class_2591<?>, Function<?, ?>> blockEntityConverterMap = new Object2ObjectOpenHashMap();
    private final Map<class_1299<?>, Function<?, ?>> entityConverterMap = new Object2ObjectOpenHashMap();
    private final List<ILootrFilter> filters = new ObjectArrayList();

    public LootrServiceRegistry() {
        ServiceLoader<ILootrBlockEntityConverter> loader = ServiceLoader.load(ILootrBlockEntityConverter.class);
        for (ILootrBlockEntityConverter iLootrBlockEntityConverter : loader) {
            this.blockEntityConverterMap.put(iLootrBlockEntityConverter.getBlockEntityType(), iLootrBlockEntityConverter);
        }
        ServiceLoader<ILootrEntityConverter> loader2 = ServiceLoader.load(ILootrEntityConverter.class);
        for (ILootrEntityConverter converter2 : loader2) {
            this.entityConverterMap.put(converter2.getEntityType(), converter2);
        }
        ServiceLoader<ILootrFilterProvider> serviceLoader = ServiceLoader.load(ILootrFilterProvider.class);
        for (ILootrFilterProvider provider : serviceLoader) {
            this.filters.addAll(provider.getFilters());
        }
        this.filters.sort(Comparator.comparingInt(ILootrFilter::getPriority));
    }

    public static LootrServiceRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LootrServiceRegistry();
        }
        return INSTANCE;
    }

    @Nullable
    private static <T> Function<T, ILootrBlockEntity> getBlockEntity(class_2591<?> clazz) {
        return LootrServiceRegistry.getInstance().blockEntityConverterMap.get(clazz);
    }

    @Nullable
    private static <T> Function<T, ILootrCart> getEntity(class_1299<?> clazz) {
        return LootrServiceRegistry.getInstance().entityConverterMap.get(clazz);
    }

    @Nullable
    public static <T extends class_2586> ILootrBlockEntity convertBlockEntity(T blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        Function<T, ILootrBlockEntity> converter = LootrServiceRegistry.getBlockEntity(blockEntity.method_11017());
        if (converter == null) {
            return null;
        }
        return converter.apply(blockEntity);
    }

    @Nullable
    public static <T extends class_1297> ILootrCart convertEntity(T entity) {
        if (entity == null) {
            return null;
        }
        Function<T, ILootrCart> converter = LootrServiceRegistry.getEntity(entity.method_5864());
        if (converter == null) {
            return null;
        }
        return converter.apply(entity);
    }

    public static List<ILootrFilter> getFilters() {
        return LootrServiceRegistry.getInstance().filters;
    }
}

