/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.DataToCopy;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.PlatformAPI;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;

public class BlockEntityTicker {
    private static final Object listLock = new Object();
    private static final Object worldLock = new Object();
    private static final Set<Entry> blockEntityEntries = new ObjectLinkedOpenHashSet();
    private static final Set<Entry> pendingEntries = new ObjectLinkedOpenHashSet();
    private static boolean tickingList = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(class_1937 level, class_2338 position) {
        if (LootrAPI.isDisabled()) {
            return;
        }
        if (LootrAPI.getServer() == null) {
            return;
        }
        class_5321 dimension = level.method_27983();
        if (LootrAPI.isDimensionBlocked((class_5321<class_1937>)dimension)) {
            return;
        }
        class_1923 chunkPos = new class_1923(position);
        ObjectLinkedOpenHashSet chunks = new ObjectLinkedOpenHashSet();
        chunks.add(chunkPos);
        int oX = chunkPos.field_9181;
        int oZ = chunkPos.field_9180;
        chunks.add(chunkPos);
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                class_1923 newPos = new class_1923(oX + x, oZ + z);
                if (!LootrAPI.isWorldBorderSafe(level, newPos)) continue;
                chunks.add(newPos);
            }
        }
        Entry newEntry = new Entry((class_5321<class_1937>)dimension, position, (Set<class_1923>)chunks, LootrAPI.getCurrentTicks());
        Object object = listLock;
        synchronized (object) {
            if (tickingList) {
                pendingEntries.add(newEntry);
            } else {
                blockEntityEntries.add(newEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onServerTick() {
        ObjectLinkedOpenHashSet copy;
        if (LootrAPI.isDisabled()) {
            return;
        }
        ObjectLinkedOpenHashSet toRemove = new ObjectLinkedOpenHashSet();
        Object object = listLock;
        synchronized (object) {
            tickingList = true;
            copy = new ObjectLinkedOpenHashSet(blockEntityEntries);
            tickingList = false;
        }
        object = worldLock;
        synchronized (object) {
            MinecraftServer server = LootrAPI.getServer();
            if (server == null) {
                LootrAPI.LOG.error("MinecraftServer was null during ServerTickEvent!");
                return;
            }
            for (Entry entry : copy) {
                class_2621 be;
                class_3218 level;
                block28: {
                    block27: {
                        class_2586 blockEntity;
                        level = server.method_3847(entry.getDimension());
                        if (level == null || LootrAPI.hasExpired(entry.age(server)) || !LootrAPI.isWorldBorderSafe((class_1937)level, entry.getPosition())) {
                            toRemove.add(entry);
                            continue;
                        }
                        if (!level.method_14178().method_12123(entry.getPosition().method_10263() >> 4, entry.getPosition().method_10260() >> 4)) continue;
                        boolean skip = false;
                        for (class_1923 chunkPos : entry.getChunkPositions()) {
                            if (level.method_14178().method_12123(chunkPos.field_9181, chunkPos.field_9180)) continue;
                            skip = true;
                            break;
                        }
                        if (skip || LootrAPI.anyUnloadedChunks(entry.getDimension(), entry.getChunkPositions())) continue;
                        if (level.method_8503().method_27728().method_28057().method_28029()) {
                            class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
                            class_1923 thisPos = new class_1923(entry.getPosition());
                            if (registry.method_40266(LootrTags.Structure.STRUCTURE_BLACKLIST).filter(tag -> tag.method_40247() != 0).isPresent()) {
                                if (LootrAPI.isTaggedStructurePresent(level, thisPos, LootrTags.Structure.STRUCTURE_BLACKLIST, entry.getPosition())) {
                                    toRemove.add(entry);
                                    continue;
                                }
                            } else if (registry.method_40266(LootrTags.Structure.STRUCTURE_WHITELIST).filter(tag -> tag.method_40247() != 0).isPresent() && !LootrAPI.isTaggedStructurePresent(level, thisPos, LootrTags.Structure.STRUCTURE_WHITELIST, entry.getPosition())) {
                                toRemove.add(entry);
                                continue;
                            }
                        }
                        if (!((blockEntity = level.method_8321(entry.getPosition())) instanceof class_2621)) break block27;
                        be = (class_2621)blockEntity;
                        if (!(LootrAPI.resolveBlockEntity(blockEntity) instanceof ILootrBlockEntity)) break block28;
                    }
                    toRemove.add(entry);
                    continue;
                }
                if (be.method_54869() == null || LootrAPI.isLootTableBlacklisted((class_5321<class_52>)be.method_54869())) {
                    toRemove.add(entry);
                    continue;
                }
                class_2680 stateAt = level.method_8320(entry.getPosition());
                class_2680 replacement = LootrAPI.replacementBlockState(stateAt);
                if (replacement == null) {
                    toRemove.add(entry);
                    continue;
                }
                DataToCopy data = PlatformAPI.copySpecificData((class_2586)be);
                class_5321 table = be.method_54869();
                long seed = be.method_54870();
                be.method_11285(null);
                level.method_22352(entry.getPosition(), false);
                level.method_8652(entry.getPosition(), replacement, 2);
                class_2586 newBlockEntity = level.method_8321(entry.getPosition());
                PlatformAPI.restoreSpecificData(data, newBlockEntity);
                if (LootrAPI.resolveBlockEntity(newBlockEntity) instanceof ILootrBlockEntity && newBlockEntity instanceof class_2621) {
                    class_2621 rbe = (class_2621)newBlockEntity;
                    rbe.method_54867(table, seed);
                } else {
                    LootrAPI.LOG.error("replacement " + String.valueOf(replacement) + " is not an ILootrBlockEntity " + String.valueOf(entry.getDimension()) + " at " + String.valueOf(entry.getPosition()));
                }
                toRemove.add(entry);
            }
        }
        object = listLock;
        synchronized (object) {
            tickingList = true;
            blockEntityEntries.removeAll((Collection<?>)toRemove);
            blockEntityEntries.addAll(pendingEntries);
            tickingList = false;
            pendingEntries.clear();
        }
    }

    public static class Entry {
        private final class_5321<class_1937> dimension;
        private final class_2338 position;
        private final Set<class_1923> chunks;
        private final long addedAt;

        public Entry(class_5321<class_1937> dimension, class_2338 position, Set<class_1923> chunks, long addedAt) {
            this.dimension = dimension;
            this.position = position;
            this.chunks = chunks;
            this.addedAt = addedAt;
        }

        public class_5321<class_1937> getDimension() {
            return this.dimension;
        }

        public class_2338 getPosition() {
            return this.position;
        }

        public Set<class_1923> getChunkPositions() {
            return this.chunks;
        }

        public long age(MinecraftServer server) {
            return (long)server.method_3780() - this.addedAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.dimension.equals(entry.dimension)) {
                return false;
            }
            return this.position.equals((Object)entry.position);
        }

        public int hashCode() {
            int result = this.dimension.hashCode();
            result = 31 * result + this.position.hashCode();
            return result;
        }
    }
}

