/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.customterrain;

import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3532;
import net.minecraft.class_4657;
import net.minecraft.class_5216;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6677;
import net.minecraft.class_6880;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import net.potionstudios.biomeswevegone.world.level.levelgen.util.BlendUtil;

public class CragGardenExtension {
    public static void runCragGardenExtension(Function<class_2338, class_6880<class_1959>> biomeGetter, class_2791 chunk, long worldSeed, class_5216.class_5487 noiseParameters, class_5216.class_5487 cliffSpacingParams) {
        class_1923 pos = chunk.method_12004();
        class_6677 randomSource = new class_6677(worldSeed);
        class_6677 chunkRandom = new class_6677(pos.method_8324() + worldSeed);
        class_5216 normalNoise = class_5216.method_38476((class_5819)randomSource, (class_5216.class_5487)noiseParameters);
        class_5216 cliffJumpNoise = class_5216.method_38476((class_5819)randomSource, (class_5216.class_5487)cliffSpacingParams);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_4657 topBlocksProvider = new class_4657(new class_6005.class_6006().method_34975((Object)BWGBlocks.OVERGROWN_STONE.get().method_9564(), 3).method_54453((Object)class_2246.field_28681.method_9564()));
        class_4657 stonesProvider = new class_4657(new class_6005.class_6006().method_54453((Object)class_2246.field_10340.method_9564()).method_54453((Object)class_2246.field_10115.method_9564()).method_54453((Object)BWGBlocks.ROCKY_STONE_SET.getBase().method_9564()));
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = pos.method_33939(x);
                int worldZ = pos.method_33941(z);
                int landHeight = chunk.method_12005(class_2902.class_2903.field_13195, worldX, worldZ) / 10 * 10;
                if (chunk.method_31607() >= landHeight) continue;
                mutable.method_10103(worldX, landHeight, worldZ);
                class_6880<class_1959> currentBiome = biomeGetter.apply((class_2338)mutable);
                if (!currentBiome.method_40225(BWGBiomes.CRAG_GARDENS)) continue;
                double normalizedCliffNoise = cliffJumpNoise.method_27406((double)worldX * 0.05, 0.0, (double)worldZ * 0.05) + 0.5;
                int cliffJumpNoiseOffset = class_3532.method_15357((double)(normalizedCliffNoise * 10.0));
                double blendRadius = BlendUtil.blendBiomeEdge(currentBiome, biomeGetter, (class_2338)mutable, 16, 1);
                int currentSurfaceHeight = (int)((double)CragGardenExtension.getSurfaceHeight(normalNoise, worldX, worldZ, Math.max(10, cliffJumpNoiseOffset * 2)) * blendRadius);
                for (int y = -5; y <= currentSurfaceHeight; ++y) {
                    mutable.method_10103(worldX, y + landHeight, worldZ);
                    class_2680 state = stonesProvider.method_23455((class_5819)chunkRandom, (class_2338)mutable);
                    if (y == currentSurfaceHeight && chunk.method_8320((class_2338)mutable.method_10098(class_2350.field_11036)).method_26227().method_15769()) {
                        state = topBlocksProvider.method_23455((class_5819)chunkRandom, (class_2338)mutable);
                        mutable.method_10098(class_2350.field_11033);
                    }
                    chunk.method_12010((class_2338)mutable, state, false);
                }
            }
        }
    }

    private static int getSurfaceHeight(class_5216 normalNoise, int worldX, int worldZ, int spacing) {
        double normalizedNoise = (normalNoise.method_27406((double)worldX * 0.005, 0.0, (double)worldZ * 0.005) + 1.0) * 0.5;
        return class_3532.method_15357((double)(normalizedNoise * 50.0)) / spacing * spacing;
    }
}

