/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils.modinfo.fabric;

import com.teamresourceful.resourcefullib.common.utils.modinfo.ModInfo;
import java.nio.file.Path;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.jetbrains.annotations.Nullable;

public class ModInfoUtilsImpl {
    @Nullable
    public static ModInfo getModInfo(String id) {
        return FabricLoader.getInstance().getModContainer(id).map(Info::new).orElse(null);
    }

    public static int getLoadedMods() {
        return FabricLoader.getInstance().getAllMods().size();
    }

    public static boolean isModLoaded(String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    public static boolean isMixinModLoaded(String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    private record Info(ModContainer container) implements ModInfo
    {
        @Override
        public String displayName() {
            return this.container.getMetadata().getName();
        }

        @Override
        public String id() {
            return this.container.getMetadata().getId();
        }

        @Override
        public String version() {
            return this.container.getMetadata().getVersion().getFriendlyString();
        }

        @Override
        public List<Path> getPaths() {
            return List.copyOf(this.container.getRootPaths());
        }
    }
}

