/*
 * Decompiled with CFR 0.152.
 */
package com.cobeffectiveness.type;

import com.cobeffectiveness.CobEffectiveness;
import com.cobeffectiveness.type.ChartJson;
import com.cobeffectiveness.type.EffectivenessChart;
import com.cobeffectiveness.type.Type;
import com.cobeffectiveness.type.TypeIcon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public final class ChartParser {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    private ChartParser() {
    }

    public static void applyFromStream(InputStream in) {
        ChartJson json = (ChartJson)GSON.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), ChartJson.class);
        if (json == null) {
            CobEffectiveness.logWarn("Chart JSON is empty");
            return;
        }
        EffectivenessChart.configure(json, name -> {
            try {
                return Type.fromCobblemon(name);
            }
            catch (Exception e) {
                return null;
            }
        });
        if (json.tiles != null) {
            TypeIcon.configure(json.tiles.cols, json.tiles.rows, json.tiles.tile_w, json.tiles.tile_h, json.order);
        }
    }
}

