/*
 * Decompiled with CFR 0.152.
 */
package com.cobeffectiveness.fabric.battle;

import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.battle.ActiveClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattle;
import com.cobblemon.mod.common.client.battle.ClientBattlePokemon;
import com.cobblemon.mod.common.client.battle.ClientBattleSide;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobeffectiveness.CobEffectiveness;
import com.cobeffectiveness.battle.OpponentSnapshot;
import com.cobeffectiveness.type.Type;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_310;

public final class PokemonTypeFetcher {
    private PokemonTypeFetcher() {
    }

    public static void refreshFromCurrentBattle() {
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            OpponentSnapshot.clear();
            return;
        }
        ClientBattle battle = CobblemonClient.INSTANCE.getBattle();
        if (battle == null) {
            OpponentSnapshot.clear();
            return;
        }
        ClientBattleSide side1 = battle.getSide1();
        ClientBattleSide side2 = battle.getSide2();
        UUID me = mc.field_1724.method_5667();
        boolean iAmSide1 = side1.getActors().stream().anyMatch(a -> me.equals(a.getUuid()));
        ClientBattleSide enemy = iAmSide1 ? side2 : side1;
        EnumSet<Type> out = EnumSet.noneOf(Type.class);
        for (ActiveClientBattlePokemon active : enemy.getActiveClientBattlePokemon()) {
            PokemonTypeFetcher.resolveTypes(active, out);
        }
        if (out.isEmpty()) {
            OpponentSnapshot.clear();
        } else {
            OpponentSnapshot.update(out);
        }
    }

    private static void resolveTypes(ActiveClientBattlePokemon active, Set<Type> into) {
        ClientBattlePokemon bp = active.getBattlePokemon();
        if (bp == null) {
            return;
        }
        Species species = bp.getSpecies();
        Set aspects = bp.getProperties().getAspects();
        FormData form = species.getForm(aspects);
        form.getPrimaryType();
        try {
            into.add(Type.fromCobblemon(form.getPrimaryType().getName()));
        }
        catch (IllegalArgumentException ex) {
            CobEffectiveness.logWarn("Unknown primary type '{}'", form.getPrimaryType().getName());
        }
        if (form.getSecondaryType() != null) {
            try {
                into.add(Type.fromCobblemon(form.getSecondaryType().getName()));
            }
            catch (IllegalArgumentException ex) {
                CobEffectiveness.logWarn("Unknown secondary type '{}'", form.getSecondaryType().getName());
            }
        }
    }
}

