/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei.drawable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;

public class ChimneySmokeAnimatedDrawable
implements IDrawableAnimated {
    private final Random random = new Random();
    private final List<IDrawable> smokeParticles = new ArrayList<IDrawable>();
    private final List<class_3545<class_241, Integer>> currentParticles = new ArrayList<class_3545<class_241, Integer>>();
    private float speed = 1.0f;
    private float intensity = 1.0f;
    private int animationSpeedTicks = 1;
    private long previousGameTime = 0L;
    private int particleAddDelay = 0;

    public ChimneySmokeAnimatedDrawable(IGuiHelper helper) {
        IDrawableStatic particle11 = helper.drawableBuilder(class_2960.method_60656((String)"textures/particle/big_smoke_11.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.smokeParticles.add((IDrawable)particle11);
        IDrawableStatic particle10 = helper.drawableBuilder(class_2960.method_60656((String)"textures/particle/big_smoke_10.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
        this.smokeParticles.add((IDrawable)particle10);
        for (int i = 0; i < 12; ++i) {
            IDrawableStatic particle = helper.drawableBuilder(class_2960.method_60656((String)("textures/particle/big_smoke_" + i + ".png")), 0, 0, 16, 16).setTextureSize(16, 16).build();
            this.smokeParticles.add((IDrawable)particle);
        }
    }

    public void draw(class_332 guiGraphics, int xOffset, int yOffset) {
        this.calculateAnimationTick();
        for (class_3545<class_241, Integer> particle : this.currentParticles) {
            class_241 pos = (class_241)particle.method_15442();
            int index = (Integer)particle.method_15441();
            IDrawable particleFrame = this.smokeParticles.get(index);
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            particleFrame.draw(guiGraphics, (int)((float)xOffset + pos.field_1343), (int)((float)yOffset + pos.field_1342));
        }
    }

    private void update() {
        --this.particleAddDelay;
        if (this.particleAddDelay <= 0 && this.currentParticles.size() < (int)(11.0f * this.getIntensity())) {
            this.particleAddDelay = this.random.nextInt(4, (int)(11.0f - 5.0f * this.getIntensity()));
            this.currentParticles.add((class_3545<class_241, Integer>)new class_3545((Object)new class_241((float)this.random.nextGaussian(), (float)(-(this.random.nextDouble() * 5.0))), (Object)0));
        }
        ArrayList<class_3545<class_241, Integer>> particlesToRemove = new ArrayList<class_3545<class_241, Integer>>();
        for (class_3545<class_241, Integer> particle : this.currentParticles) {
            particle.method_34965((Object)((Integer)particle.method_15441() + 1));
            particle.method_34964((Object)((class_241)particle.method_15442()).method_35586(new class_241((float)this.random.nextInt(0, 2), -2.0f * this.getSpeed())));
            if ((Integer)particle.method_15441() < this.smokeParticles.size()) continue;
            particlesToRemove.add(particle);
        }
        particlesToRemove.forEach(particleToRemove -> this.currentParticles.remove(particleToRemove));
    }

    private void calculateAnimationTick() {
        long gameTime = Objects.requireNonNull(class_310.method_1551().field_1687).method_8510();
        if (Math.abs(gameTime - this.previousGameTime) > (long)this.animationSpeedTicks) {
            this.update();
            this.previousGameTime = gameTime;
        }
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 16;
    }

    public int getAnimationSpeedTicks() {
        return this.animationSpeedTicks;
    }

    public void setAnimationSpeedTicks(int ticks) {
        this.animationSpeedTicks = ticks;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setIntensity(float strength) {
        this.intensity = strength;
    }
}

