/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.jei.category;

import io.github.mortuusars.sootychimneys.SootyChimneys;
import io.github.mortuusars.sootychimneys.block.ChimneyBlock;
import io.github.mortuusars.sootychimneys.data.smoke.SmokeProperties;
import io.github.mortuusars.sootychimneys.integration.jei.JeiRecipeTypes;
import io.github.mortuusars.sootychimneys.integration.jei.drawable.ChimneySmokeAnimatedDrawable;
import io.github.mortuusars.sootychimneys.integration.jei.recipe.SootCoveringJeiRecipe;
import io.github.mortuusars.sootychimneys.integration.jei.renderer.ScalableItemStackRenderer;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class SootCoveringRecipeCategory
implements IRecipeCategory<SootCoveringJeiRecipe> {
    public static final int BG_WIDTH = 153;
    public static final int BG_HEIGHT = 65;
    public static final Map<class_1792, Integer> CHIMNEY_SMOKE_Y_ORIGIN = new HashMap<class_1792, Integer>(){
        {
            this.put((class_1792)SootyChimneys.Items.BRICK_CHIMNEY.get(), 3);
            this.put((class_1792)SootyChimneys.Items.DIRTY_BRICK_CHIMNEY.get(), 3);
            this.put((class_1792)SootyChimneys.Items.COBBLESTONE_CHIMNEY.get(), 3);
            this.put((class_1792)SootyChimneys.Items.DIRTY_COBBLESTONE_CHIMNEY.get(), 3);
            this.put((class_1792)SootyChimneys.Items.STONE_BRICK_CHIMNEY.get(), 0);
            this.put((class_1792)SootyChimneys.Items.DIRTY_STONE_BRICK_CHIMNEY.get(), 0);
            this.put((class_1792)SootyChimneys.Items.MUD_BRICK_CHIMNEY.get(), 3);
            this.put((class_1792)SootyChimneys.Items.DIRTY_MUD_BRICK_CHIMNEY.get(), 3);
            this.put((class_1792)SootyChimneys.Items.IRON_CHIMNEY.get(), 2);
            this.put((class_1792)SootyChimneys.Items.DIRTY_IRON_CHIMNEY.get(), 2);
            this.put((class_1792)SootyChimneys.Items.COPPER_CHIMNEY.get(), -1);
            this.put((class_1792)SootyChimneys.Items.DIRTY_COPPER_CHIMNEY.get(), -1);
            this.put((class_1792)SootyChimneys.Items.TERRACOTTA_CHIMNEY.get(), 10);
            this.put((class_1792)SootyChimneys.Items.DIRTY_TERRACOTTA_CHIMNEY.get(), 10);
        }
    };
    private final class_2561 title;
    private final IDrawable background;
    private final IDrawableStatic icon;
    private final IGuiHelper helper;

    public SootCoveringRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.title = class_2561.method_43471((String)"jei.sootychimneys.category.soot_covering");
        class_2960 texture = SootyChimneys.resource("textures/gui/jei/soot_covering.png");
        this.background = helper.createDrawable(texture, 0, 0, 153, 65);
        this.icon = helper.drawableBuilder(SootyChimneys.resource("textures/gui/jei/soot_covering_icon.png"), 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull SootCoveringJeiRecipe recipe, @NotNull IFocusGroup focuses) {
        ChimneySmokeAnimatedDrawable ingredientSmoke = this.createSmokeDrawable(recipe.getCleanChimney());
        Integer yOffset = CHIMNEY_SMOKE_Y_ORIGIN.get(recipe.getCleanChimney().method_7909());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 10, 18).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new ScalableItemStackRenderer(2.5f)).setOverlay((IDrawable)ingredientSmoke, 12, yOffset.intValue()).addItemStack(recipe.getCleanChimney())).setSlotName("CleanChimney");
        ChimneySmokeAnimatedDrawable resultSmoke = this.createSmokeDrawable(recipe.getDirtyChimney());
        Integer yOffset1 = CHIMNEY_SMOKE_Y_ORIGIN.get(recipe.getDirtyChimney().method_7909());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 18).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new ScalableItemStackRenderer(2.5f)).setOverlay((IDrawable)resultSmoke, 12, yOffset1.intValue()).addItemStack(recipe.getDirtyChimney())).setSlotName("DirtyChimney");
    }

    private ChimneySmokeAnimatedDrawable createSmokeDrawable(class_1799 chimney) {
        class_1747 blockItem;
        ChimneySmokeAnimatedDrawable drawable = new ChimneySmokeAnimatedDrawable(this.helper);
        class_1792 class_17922 = chimney.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof ChimneyBlock) {
            ChimneyBlock chimneyBlock = (ChimneyBlock)class_17922;
            SmokeProperties smokeProperties = chimneyBlock.getType().smokeProperties();
            drawable.setSpeed(smokeProperties.getSpeed());
            drawable.setIntensity(smokeProperties.getIntensity());
        }
        return drawable;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public RecipeType<SootCoveringJeiRecipe> getRecipeType() {
        return JeiRecipeTypes.SOOT_COVERING;
    }
}

