/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network.common.s2c;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.config.ConfigPackets;
import lol.bai.badpackets.api.play.PlayPackets;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.network.Packet;
import mcp.mobius.waila.util.Log;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class ConfigSyncCommonS2CPacket
implements Packet {
    private static final Log LOG = Log.create();
    private static final Gson GSON = new Gson();
    public static final class_8710.class_9154<Payload> TYPE = new class_8710.class_9154(Waila.id("config"));
    public static final class_9139<class_2540, Payload> CODEC = class_9139.method_56438((p, buf) -> {
        Map<String, List<class_2960>> groups = p.map.keySet().stream().collect(Collectors.groupingBy(class_2960::method_12836));
        buf.method_10804(groups.size());
        groups.forEach((namespace, entries) -> {
            buf.method_10814(namespace);
            buf.method_10804(entries.size());
            entries.forEach(e -> {
                buf.method_10814(e.method_12832());
                Object v = p.map.get(e);
                if (v instanceof Boolean) {
                    Boolean z = (Boolean)v;
                    buf.method_52997(0);
                    buf.method_52964(z.booleanValue());
                } else if (v instanceof Integer) {
                    Integer i = (Integer)v;
                    buf.method_52997(1);
                    buf.method_10804(i.intValue());
                } else if (v instanceof Double) {
                    Double d = (Double)v;
                    buf.method_52997(2);
                    buf.method_52940(d.doubleValue());
                } else if (v instanceof String) {
                    String str = (String)v;
                    buf.method_52997(3);
                    buf.method_10814(str);
                } else if (v instanceof Enum) {
                    Enum en = (Enum)v;
                    buf.method_52997(3);
                    buf.method_10814(en.name());
                }
            });
        });
    }, buf -> {
        HashMap<class_2960, Object> map = new HashMap<class_2960, Object>();
        int groupSize = buf.method_10816();
        for (int i = 0; i < groupSize; ++i) {
            String namespace = buf.method_19772();
            int groupLen = buf.method_10816();
            block7: for (int j = 0; j < groupLen; ++j) {
                class_2960 id = class_2960.method_60655((String)namespace, (String)buf.method_19772());
                byte type = buf.readByte();
                switch (type) {
                    case 0: {
                        map.put(id, buf.readBoolean());
                        continue block7;
                    }
                    case 1: {
                        map.put(id, buf.method_10816());
                        continue block7;
                    }
                    case 2: {
                        map.put(id, buf.readDouble());
                        continue block7;
                    }
                    case 3: {
                        map.put(id, buf.method_19772());
                    }
                }
            }
        }
        return new Payload(map);
    });

    @Override
    public void common() {
        ConfigPackets.registerClientChannel(TYPE, CODEC);
        PlayPackets.registerClientChannel(TYPE, CODEC);
    }

    @Override
    public void client() {
        ConfigPackets.registerClientReceiver(TYPE, (context, payload) -> ConfigSyncCommonS2CPacket.receive(payload));
        PlayPackets.registerClientReceiver(TYPE, (context, payload) -> ConfigSyncCommonS2CPacket.receive(payload));
    }

    private static void receive(Payload payload) {
        Map<class_2960, Object> map = payload.map;
        for (ConfigEntry<Object> config : PluginConfig.getSyncableConfigs()) {
            class_2960 id = config.getId();
            Object clientOnlyValue = config.getClientOnlyValue();
            Object syncedValue = map.get(id);
            if (clientOnlyValue instanceof Enum) {
                Enum e = (Enum)clientOnlyValue;
                if (!(syncedValue instanceof Enum)) {
                    syncedValue = Enum.valueOf(e.getDeclaringClass(), (String)map.getOrDefault(id, e.name()));
                }
            }
            if (syncedValue instanceof Double) {
                Double d = (Double)syncedValue;
                if (clientOnlyValue instanceof Integer) {
                    syncedValue = d.intValue();
                }
            }
            config.setServerValue(syncedValue);
        }
        LOG.info("Received config from the server: {}", GSON.toJson(map));
    }

    public record Payload(Map<class_2960, Object> map) implements class_8710
    {
        public Payload() {
            this(PluginConfig.getSyncableConfigs().stream().filter(it -> it.getOrigin().isEnabled()).collect(Collectors.toMap(ConfigEntry::getId, ConfigEntry::getLocalValue)));
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }
}

