/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.store.db;

import com.mojang.logging.LogUtils;
import dev.gegy.roles.config.PlayerRolesConfig;
import dev.gegy.roles.store.PlayerRoleSet;
import dev.gegy.roles.store.db.Uuid2BinaryDatabase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import org.slf4j.Logger;

public final class PlayerRoleDatabase
implements Closeable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Uuid2BinaryDatabase binary;

    private PlayerRoleDatabase(Uuid2BinaryDatabase binary) {
        this.binary = binary;
    }

    public static PlayerRoleDatabase open(Path path) throws IOException {
        Uuid2BinaryDatabase binary = Uuid2BinaryDatabase.open(path);
        return new PlayerRoleDatabase(binary);
    }

    public void tryLoadInto(UUID uuid, PlayerRoleSet roles) {
        try {
            ByteBuffer bytes = this.binary.get(uuid);
            if (bytes != null) {
                try {
                    PlayerRoleDatabase.deserializeRoles(roles, bytes);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to deserialize roles for {}, dropping", (Object)uuid, (Object)e);
                    this.binary.remove(uuid);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load roles for {}", (Object)uuid, (Object)e);
        }
    }

    public void trySave(UUID uuid, PlayerRoleSet roles) {
        try {
            if (!roles.isEmpty()) {
                ByteBuffer bytes = PlayerRoleDatabase.serializeRoles(roles);
                this.binary.put(uuid, bytes);
            } else {
                this.binary.remove(uuid);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save roles for {}", (Object)uuid, (Object)e);
        }
    }

    private static ByteBuffer serializeRoles(PlayerRoleSet roles) throws IOException {
        class_2487 nbt = new class_2487();
        nbt.method_10566("roles", (class_2520)roles.serialize());
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            class_2507.method_10634((class_2487)nbt, (OutputStream)output);
            ByteBuffer byteBuffer = ByteBuffer.wrap(output.toByteArray());
            return byteBuffer;
        }
    }

    private static void deserializeRoles(PlayerRoleSet roles, ByteBuffer bytes) throws IOException {
        PlayerRolesConfig config = PlayerRolesConfig.get();
        try (ByteArrayInputStream input = new ByteArrayInputStream(bytes.array());){
            class_2487 nbt = class_2507.method_10629((InputStream)input, (class_2505)class_2505.method_53898());
            roles.deserialize(config, nbt.method_10554("roles", 8));
        }
    }

    @Override
    public void close() throws IOException {
        this.binary.close();
    }
}

