/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.store;

import dev.gegy.roles.PlayerRoles;
import dev.gegy.roles.api.Role;
import dev.gegy.roles.api.RoleProvider;
import dev.gegy.roles.api.RoleReader;
import dev.gegy.roles.api.override.RoleOverrideReader;
import dev.gegy.roles.override.RoleOverrideMap;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class PlayerRoleSet
implements RoleReader {
    private final Role everyoneRole;
    @Nullable
    private final class_3222 player;
    private final ObjectSortedSet<Role> roles = new ObjectAVLTreeSet();
    private final RoleOverrideMap overrides = new RoleOverrideMap();
    private boolean dirty;

    public PlayerRoleSet(Role everyoneRole, @Nullable class_3222 player) {
        this.everyoneRole = everyoneRole;
        this.player = player;
        this.rebuildOverrides();
    }

    public void rebuildOverridesAndNotify() {
        this.rebuildOverrides();
        if (this.player != null) {
            this.overrides.notifyChange(this.player);
        }
    }

    private void rebuildOverrides() {
        this.overrides.clear();
        this.stream().forEach(role -> this.overrides.addAll(role.getOverrides()));
    }

    public boolean add(Role role) {
        if (this.roles.add((Object)role)) {
            this.dirty = true;
            this.rebuildOverridesAndNotify();
            return true;
        }
        return false;
    }

    public boolean remove(Role role) {
        if (this.roles.remove((Object)role)) {
            this.dirty = true;
            this.rebuildOverridesAndNotify();
            return true;
        }
        return false;
    }

    public Iterator<Role> iterator() {
        return this.roles.iterator();
    }

    public Stream<Role> stream() {
        return Stream.concat(this.roles.stream(), Stream.of(this.everyoneRole));
    }

    public boolean has(Role role) {
        return role == this.everyoneRole || this.roles.contains((Object)role);
    }

    public RoleOverrideReader overrides() {
        return this.overrides;
    }

    public class_2499 serialize() {
        class_2499 list = new class_2499();
        for (Role role : this.roles) {
            list.add((Object)class_2519.method_23256((String)role.getId()));
        }
        return list;
    }

    public void deserialize(RoleProvider roleProvider, class_2499 list) {
        this.roles.clear();
        for (int i = 0; i < list.size(); ++i) {
            String name = list.method_10608(i);
            Role role = roleProvider.get(name);
            if (role == null || name.equalsIgnoreCase("everyone")) {
                this.dirty = true;
                PlayerRoles.LOGGER.warn("Encountered invalid role '{}'", (Object)name);
                continue;
            }
            this.roles.add((Object)role);
        }
        this.rebuildOverrides();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEmpty() {
        return this.roles.isEmpty();
    }

    public void reloadFrom(RoleProvider roleProvider, PlayerRoleSet roles) {
        class_2499 nbt = roles.serialize();
        this.deserialize(roleProvider, nbt);
        this.dirty |= roles.dirty;
    }

    public void copyFrom(PlayerRoleSet roles) {
        this.roles.clear();
        this.roles.addAll(roles.roles);
        this.dirty = roles.dirty;
        this.rebuildOverrides();
    }

    public PlayerRoleSet copy() {
        PlayerRoleSet copy = new PlayerRoleSet(this.everyoneRole, this.player);
        copy.copyFrom(this);
        return copy;
    }
}

