/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.override.permission;

import com.mojang.serialization.Codec;
import dev.gegy.roles.api.override.RoleOverrideResult;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class PermissionKeyRules {
    public static final Codec<PermissionKeyRules> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)RoleOverrideResult.CODEC).xmap(map -> {
        Builder rules = PermissionKeyRules.builder();
        map.forEach(rules::add);
        return rules.build();
    }, override -> {
        HashMap<String, RoleOverrideResult> map = new HashMap<String, RoleOverrideResult>(override.exactPermissions);
        for (KeyMatcher keyMatcher : override.keyMatchers) {
            map.put(keyMatcher.asPattern(), keyMatcher.result);
        }
        return map;
    });
    private final Map<String, RoleOverrideResult> exactPermissions;
    private final KeyMatcher[] keyMatchers;

    private PermissionKeyRules(Map<String, RoleOverrideResult> exactPermissions, KeyMatcher[] keyMatchers) {
        this.exactPermissions = exactPermissions;
        this.keyMatchers = keyMatchers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public RoleOverrideResult test(String permission) {
        RoleOverrideResult result = this.exactPermissions.get(permission);
        if (result != null) {
            return result;
        }
        String[] tokens = permission.split("\\.");
        for (KeyMatcher matcher : this.keyMatchers) {
            result = matcher.test(tokens);
            if (result == null) continue;
            return result;
        }
        return RoleOverrideResult.PASS;
    }

    static final class KeyMatcher {
        final String[] pattern;
        final RoleOverrideResult result;

        KeyMatcher(String permission, RoleOverrideResult result) {
            this.pattern = permission.split("\\.");
            this.result = result;
        }

        @Nullable
        RoleOverrideResult test(String[] tokens) {
            String[] pattern = this.pattern;
            int patternIdx = 0;
            String endWildcard = null;
            for (String token : tokens) {
                if (endWildcard == null) {
                    String match = pattern[patternIdx];
                    if (match.equals("*")) {
                        if (++patternIdx < pattern.length) {
                            endWildcard = pattern[patternIdx];
                            continue;
                        }
                        return this.result;
                    }
                    if (token.equals(match)) {
                        if (++patternIdx < pattern.length) continue;
                        return this.result;
                    }
                    return null;
                }
                if (!token.equals(endWildcard)) continue;
                endWildcard = null;
                if (++patternIdx < pattern.length) continue;
                return this.result;
            }
            if (endWildcard != null) {
                return null;
            }
            return this.result;
        }

        String asPattern() {
            return String.join((CharSequence)".", this.pattern);
        }
    }

    public static class Builder {
        private final Map<String, RoleOverrideResult> exactPermissions = new Object2ObjectOpenHashMap();
        private final List<KeyMatcher> keyMatchers = new ArrayList<KeyMatcher>();

        Builder() {
        }

        public Builder add(String key, RoleOverrideResult result) {
            if (key.contains("*")) {
                this.keyMatchers.add(new KeyMatcher(key, result));
            } else {
                this.exactPermissions.putIfAbsent(key, result);
            }
            return this;
        }

        public PermissionKeyRules build() {
            return new PermissionKeyRules(this.exactPermissions, this.keyMatchers.toArray(new KeyMatcher[0]));
        }
    }
}

