/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.override.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import dev.gegy.roles.PlayerRoles;
import dev.gegy.roles.api.PlayerRolesApi;
import dev.gegy.roles.api.RoleReader;
import dev.gegy.roles.api.override.RoleOverrideResult;
import dev.gegy.roles.override.command.CommandOverrideRules;
import dev.gegy.roles.override.command.CommandRequirementHooks;
import dev.gegy.roles.override.command.CommandTestContext;
import dev.gegy.roles.override.command.MatchableCommand;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;

public record CommandOverride(CommandOverrideRules rules) {
    public static final Codec<CommandOverride> CODEC = CommandOverrideRules.CODEC.xmap(CommandOverride::new, override -> override.rules);
    private static boolean registered;

    public static void initialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(s -> {
            if (registered) {
                return;
            }
            registered = true;
            ServerLifecycleEvents.SERVER_STARTED.register(server -> CommandOverride.hookCommands((CommandDispatcher<class_2168>)server.method_3734().method_9235()));
        });
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resources, success) -> CommandOverride.hookCommands((CommandDispatcher<class_2168>)server.method_3734().method_9235()));
    }

    private static void hookCommands(CommandDispatcher<class_2168> dispatcher) {
        try {
            CommandRequirementHooks<class_2168> hooks = CommandRequirementHooks.tryCreate((nodes, parent) -> {
                MatchableCommand command = MatchableCommand.compile(nodes);
                return source -> switch (CommandOverride.canUseCommand(source, command)) {
                    case RoleOverrideResult.ALLOW -> true;
                    case RoleOverrideResult.DENY -> false;
                    case RoleOverrideResult.HIDDEN -> {
                        if (!CommandTestContext.isSuggesting()) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> parent.test(source);
                };
            });
            hooks.applyTo(dispatcher);
        }
        catch (ReflectiveOperationException e) {
            PlayerRoles.LOGGER.error("Failed to reflect into command requirements!", (Throwable)e);
        }
    }

    private static RoleOverrideResult canUseCommand(class_2168 source, MatchableCommand command) {
        if (CommandOverride.doesBypassPermissions(source)) {
            return RoleOverrideResult.PASS;
        }
        RoleReader roles = PlayerRolesApi.lookup().bySource(source);
        return roles.overrides().test(PlayerRoles.COMMANDS, m -> m.test(command));
    }

    public static boolean doesBypassPermissions(class_2168 source) {
        return source.method_9259(4);
    }

    public RoleOverrideResult test(MatchableCommand command) {
        return this.rules.test(command);
    }
}

